/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.perspective;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ViewTool;
import org.eclipse.wst.ws.internal.explorer.platform.util.HTMLUtils;

public abstract class Node {
    protected TreeElement element_;
    protected NodeManager nodeManager_;
    protected int nodeId_;
    protected int nodeDepth_;
    protected String imagePath_;
    protected boolean isOpen_;
    protected Vector childNodes_;
    protected ToolManager toolManager_;
    protected Node parent_;
    private String anchorName_;
    private int viewId_;

    public Node(TreeElement element, NodeManager nodeManager, int nodeDepth, String imagePath) {
        this.element_ = element;
        this.nodeManager_ = nodeManager;
        this.nodeId_ = nodeManager.addToNodeTable(this);
        this.nodeDepth_ = nodeDepth;
        Controller controller = this.nodeManager_.getController();
        this.imagePath_ = imagePath == null ? controller.getPathWithContext("images/space.gif") : imagePath;
        this.isOpen_ = true;
        this.childNodes_ = new Vector();
        this.toolManager_ = new ToolManager(this);
        this.initTools();
        this.anchorName_ = new StringBuffer("action").append(this.nodeId_).toString();
        this.parent_ = null;
        this.viewId_ = -1;
    }

    public TreeElement getTreeElement() {
        return this.element_;
    }

    public String getNodeName() {
        return this.element_.getName();
    }

    public NodeManager getNodeManager() {
        return this.nodeManager_;
    }

    public int getNodeId() {
        return this.nodeId_;
    }

    public int getNodeDepth() {
        return this.nodeDepth_;
    }

    public void setImagePath(String path) {
        this.imagePath_ = path;
    }

    public boolean isOpen() {
        return this.isOpen_;
    }

    public boolean isVisible() {
        Node parentNode = this.parent_;
        while (parentNode != null) {
            if (!parentNode.isOpen()) {
                return false;
            }
            parentNode = parentNode.getParent();
        }
        return true;
    }

    public final void setVisibilityOfChildren(boolean open) {
        this.isOpen_ = open;
        this.nodeManager_.updateMaxDepthVisible();
    }

    public int getMaxDepthVisible() {
        if (!this.isOpen_) {
            return this.nodeDepth_;
        }
        int currentDepth = this.nodeDepth_;
        Enumeration e = this.childNodes_.elements();
        while (e.hasMoreElements()) {
            Node thisNode = (Node)e.nextElement();
            int depth = thisNode.getMaxDepthVisible();
            if (depth <= currentDepth) continue;
            currentDepth = depth;
        }
        return currentDepth;
    }

    public final void setParent(Node node) {
        this.parent_ = node;
    }

    public final Node getParent() {
        return this.parent_;
    }

    public final void setViewId(int viewId) {
        this.viewId_ = viewId;
    }

    public final int getViewId() {
        return this.viewId_;
    }

    public final int getViewToolId() {
        ToolManager viewToolManager = this.getViewToolManager();
        if (viewToolManager != null) {
            return viewToolManager.getSelectedToolId();
        }
        return -1;
    }

    public final boolean addChild(Node childNode) {
        childNode.setParent(this);
        this.childNodes_.addElement(childNode);
        this.nodeManager_.updateMaxDepthVisible();
        return true;
    }

    public Vector getChildNodes() {
        return this.childNodes_;
    }

    public final Node getChildNode(TreeElement element) {
        Enumeration e = this.childNodes_.elements();
        while (e.hasMoreElements()) {
            Node presentNode = (Node)e.nextElement();
            if (presentNode.getTreeElement() != element) continue;
            return presentNode;
        }
        return null;
    }

    public final void removeChildNodes(boolean isEntry) {
        int numberOfChildNodes = this.childNodes_.size();
        int i = numberOfChildNodes - 1;
        while (i >= 0) {
            Node childNode = (Node)this.childNodes_.elementAt(i);
            childNode.removeChildNodes(false);
            this.nodeManager_.removeFromNodeTable(childNode.getNodeId());
            --i;
        }
        if (numberOfChildNodes > 0) {
            this.childNodes_.removeAllElements();
            if (isEntry) {
                this.nodeManager_.updateMaxDepthVisible();
            }
        }
    }

    public final boolean removeChildNode(TreeElement element) {
        Node childNode = this.getChildNode(element);
        if (childNode != null) {
            int childNodeId = childNode.getNodeId();
            if (this.nodeManager_.getSelectedNodeId() == childNodeId) {
                this.nodeManager_.setSelectedNodeId(this.nodeId_);
            }
            this.childNodes_.removeElement(childNode);
            this.nodeManager_.removeFromNodeTable(childNodeId);
            this.nodeManager_.updateMaxDepthVisible();
            return true;
        }
        return false;
    }

    public String getAnchorName() {
        return this.anchorName_;
    }

    public ToolManager getToolManager() {
        return this.toolManager_;
    }

    public ToolManager getViewToolManager() {
        if (this.viewId_ != -1) {
            ViewTool viewTool = (ViewTool)this.toolManager_.getSelectedTool();
            return viewTool.getToolManager(this.viewId_);
        }
        return null;
    }

    public ToolManager getCurrentToolManager() {
        ToolManager toolManager = this.getViewToolManager();
        if (toolManager == null) {
            toolManager = this.toolManager_;
        }
        return toolManager;
    }

    protected abstract void initTools();

    protected abstract String getToggleNodeActionHref();

    protected String getToggleNodeActionTarget() {
        return "perspective_workarea";
    }

    protected void addToggle(HttpServletResponse response, StringBuffer treeView, boolean isLastChild) {
        if (this.nodeDepth_ != 1) {
            treeView.append("    <td align=\"left\" width=16 height=16 nowrap>");
            if (this.childNodes_.size() > 0) {
                String toggleImageTag;
                String toggleAlt;
                String href = this.nodeManager_.getController().getPathWithContext(this.getToggleNodeActionHref());
                if (this.isOpen_) {
                    toggleAlt = this.nodeManager_.getController().getMessage("ALT_CLOSE");
                    toggleImageTag = isLastChild ? HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/minus_last.gif"), toggleAlt, "16", "16", null) : HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/minus_notlast.gif"), toggleAlt, "16", "16", null);
                } else {
                    toggleAlt = this.nodeManager_.getController().getMessage("ALT_OPEN");
                    toggleImageTag = isLastChild ? HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/plus_last.gif"), toggleAlt, "16", "16", null) : HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/plus_notlast.gif"), toggleAlt, "16", "16", null);
                }
                String linkTag = HTMLUtils.getHTMLLinkTag(response, href, this.getToggleNodeActionTarget(), String.valueOf(this.nodeId_), toggleImageTag, null);
                treeView.append(linkTag);
            } else {
                String toggleImageTag = isLastChild ? HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/line_last.gif"), "", "16", "16", null) : HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/line_notlast.gif"), "", "16", "16", null);
                treeView.append(toggleImageTag);
            }
            treeView.append("</td>").append(HTMLUtils.LINE_SEPARATOR);
        }
    }

    protected abstract String getLinkActionHref();

    protected String getLinkActionTarget() {
        return "perspective_workarea";
    }

    public String getOpenImagePath() {
        return this.imagePath_;
    }

    public String getClosedImagePath() {
        return this.imagePath_;
    }

    protected void addHTMLLabel(HttpServletResponse response, StringBuffer treeView, boolean isLastChild) {
        Hashtable<String, String> additionalAttributes = new Hashtable<String, String>();
        additionalAttributes.put("name", this.anchorName_);
        String imagePath = this.nodeManager_.getSelectedNodeId() == this.nodeId_ ? this.getOpenImagePath() : this.getClosedImagePath();
        String imageTag = HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext(imagePath), this.getNodeName(), "16", "16", additionalAttributes);
        String baseHref = this.getLinkActionHref();
        String href = baseHref == null ? baseHref : this.nodeManager_.getController().getPathWithContext(baseHref);
        String target = this.getLinkActionTarget();
        additionalAttributes.clear();
        treeView.append("    <td align=\"left\" width=16 height=16 nowrap>");
        if (href != null) {
            treeView.append(HTMLUtils.getHTMLLinkTag(response, href, target, null, imageTag, additionalAttributes));
        } else {
            treeView.append(imageTag);
        }
        treeView.append("</td>").append(HTMLUtils.LINE_SEPARATOR);
        treeView.append("    <td align=\"left\" width=3 height=10 nowrap>").append(HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/space.gif"), "", "3", "10", null)).append("</td>").append(HTMLUtils.LINE_SEPARATOR);
        treeView.append("    <td align=\"left\" nowrap>").append(HTMLUtils.LINE_SEPARATOR);
        treeView.append("      ");
        if (href != null) {
            String textAnchorClass = this.nodeManager_.getSelectedNodeId() == this.nodeId_ ? "selectedTextAnchor" : "unselectedTextAnchor";
            additionalAttributes.put("class", textAnchorClass);
            treeView.append(HTMLUtils.getHTMLLinkTag(response, href, target, this.anchorName_, this.getNodeName(), additionalAttributes));
        } else {
            treeView.append("<strong>").append(this.getNodeName()).append("</strong>");
        }
        treeView.append(HTMLUtils.LINE_SEPARATOR).append("    </td>").append(HTMLUtils.LINE_SEPARATOR);
    }

    public void renderNode(HttpServletResponse response, StringBuffer treeView, String prefixColumns, boolean isLastChild) {
        String space_16x16 = HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/space.gif"), "", "16", "16", null);
        String line_16x16 = HTMLUtils.getHTMLImageTag(response, this.nodeManager_.getController().getPathWithContext("images/line.gif"), "", "16", "16", null);
        treeView.append("<table cellspacing=0 cellpadding=0 border=0>").append(HTMLUtils.LINE_SEPARATOR);
        treeView.append("  <tr>").append(HTMLUtils.LINE_SEPARATOR);
        treeView.append("    <td align=\"left\" width=16 height=16 nowrap>").append(space_16x16).append("</td>").append(HTMLUtils.LINE_SEPARATOR);
        StringBuffer newPrefixColumns = new StringBuffer(prefixColumns);
        if (this.nodeDepth_ >= 2) {
            if (prefixColumns.length() > 0) {
                treeView.append(prefixColumns).append(HTMLUtils.LINE_SEPARATOR);
            }
            newPrefixColumns.append("    <td align=\"left\" width=16 height=16 nowrap>");
            if (isLastChild) {
                newPrefixColumns.append(space_16x16);
            } else {
                newPrefixColumns.append(line_16x16);
            }
            newPrefixColumns.append("</td>").append(HTMLUtils.LINE_SEPARATOR);
        }
        this.addToggle(response, treeView, isLastChild);
        this.addHTMLLabel(response, treeView, isLastChild);
        treeView.append("  </tr>").append(HTMLUtils.LINE_SEPARATOR);
        treeView.append("</table>").append(HTMLUtils.LINE_SEPARATOR);
        int numberOfChildNodes = this.childNodes_.size();
        if (numberOfChildNodes > 0 && this.isOpen_) {
            int i = 0;
            while (i < numberOfChildNodes - 1) {
                Node childNode = (Node)this.childNodes_.elementAt(i);
                childNode.renderNode(response, treeView, newPrefixColumns.toString(), false);
                ++i;
            }
            Node lastChildNode = (Node)this.childNodes_.elementAt(numberOfChildNodes - 1);
            lastChildNode.renderNode(response, treeView, newPrefixColumns.toString(), true);
        }
    }

    public final String toString() {
        return this.getNodeName();
    }
}

