"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const vscode_html_languageservice_1 = require("vscode-html-languageservice");
const language_service_1 = require("@volar/language-service");
function register(htmlLs) {
    const docForEmptyLineCompletion = vscode_html_languageservice_1.TextDocument.create('file:///foo.html', 'html', 0, '< />');
    const htmlDocForEmptyLineCompletion = htmlLs.parseHTMLDocument(docForEmptyLineCompletion);
    const posForEmptyLine = docForEmptyLineCompletion.positionAt(1);
    return async (pugDoc, pos, serviceContext, documentContext, options) => {
        const offset = pugDoc.pugTextDocument.offsetAt(pos);
        if (pugDoc.emptyLineEnds.includes(offset)) {
            const htmlComplete = htmlLs.doComplete(docForEmptyLineCompletion, posForEmptyLine, htmlDocForEmptyLineCompletion, options);
            for (const item of htmlComplete.items) {
                item.textEdit = undefined;
            }
            return htmlComplete;
        }
        const htmlPos = pugDoc.map.getGeneratedPosition(pos);
        if (!htmlPos) {
            return;
        }
        const htmlComplete = documentContext ? await htmlLs.doComplete2(pugDoc.htmlTextDocument, htmlPos, pugDoc.htmlDocument, documentContext, options) : htmlLs.doComplete(pugDoc.htmlTextDocument, htmlPos, pugDoc.htmlDocument, options);
        return (0, language_service_1.transformCompletionList)(htmlComplete, htmlRange => pugDoc.map.getSourceRange(htmlRange), pugDoc.map.embeddedDocument, serviceContext);
    };
}
exports.register = register;
//# sourceMappingURL=completion.js.map