/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.counting;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.ITcRelation;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.topsort.TopologicalSorting;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;

public class CountingTcRelation<V>
implements ITcRelation<V> {
    private IMultiLookup<V, V> tuplesForward = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.MULTISETS, Object.class);
    private IMultiLookup<V, V> tuplesBackward = null;

    protected CountingTcRelation(boolean backwardIndexing) {
        if (backwardIndexing) {
            this.tuplesBackward = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.MULTISETS, Object.class);
        }
    }

    protected boolean isEmpty() {
        return this.tuplesForward.countKeys() == 0;
    }

    protected void clear() {
        this.tuplesForward.clear();
        if (this.tuplesBackward != null) {
            this.tuplesBackward.clear();
        }
    }

    protected void union(CountingTcRelation<V> rA) {
        IMultiLookup<V, V> rForward = rA.tuplesForward;
        for (Object source : rForward.distinctKeys()) {
            IMemoryView targetBag = rForward.lookup(source);
            for (Object target : targetBag.distinctValues()) {
                this.addTuple(source, target, targetBag.getCount(target));
            }
        }
    }

    public int getCount(V source, V target) {
        IMemoryView bucket = this.tuplesForward.lookup(source);
        return bucket == null ? 0 : bucket.getCount(target);
    }

    public boolean addTuple(V source, V target, int count) {
        IMultiLookup.ChangeGranularity change;
        if (this.tuplesBackward != null) {
            this.tuplesBackward.addPairPositiveMultiplicity(target, source, count);
        }
        return (change = this.tuplesForward.addPairPositiveMultiplicity(source, target, count)) != IMultiLookup.ChangeGranularity.DUPLICATE;
    }

    public boolean updateTuple(V source, V target, boolean isInsertion) {
        IMultiLookup.ChangeGranularity change;
        if (isInsertion) {
            IMultiLookup.ChangeGranularity change2;
            if (this.tuplesBackward != null) {
                this.tuplesBackward.addPair(target, source);
            }
            return (change2 = this.tuplesForward.addPair(source, target)) != IMultiLookup.ChangeGranularity.DUPLICATE;
        }
        if (this.tuplesBackward != null) {
            this.tuplesBackward.removePair(target, source);
        }
        return (change = this.tuplesForward.removePair(source, target)) != IMultiLookup.ChangeGranularity.DUPLICATE;
    }

    public void deleteTupleEnd(V deleted) {
        int i;
        int count;
        Set sourcesToDelete = CollectionsFactory.createSet();
        Set targetsToDelete = CollectionsFactory.createSet();
        for (Object target : this.tuplesForward.lookupOrEmpty(deleted).distinctValues()) {
            targetsToDelete.add(target);
        }
        if (this.tuplesBackward != null) {
            for (Object source : this.tuplesBackward.lookupOrEmpty(deleted).distinctValues()) {
                sourcesToDelete.add(source);
            }
        } else {
            for (Object sourceCandidate : this.tuplesForward.distinctKeys()) {
                if (!this.tuplesForward.lookupOrEmpty(sourceCandidate).containsNonZero(deleted)) continue;
                sourcesToDelete.add(sourceCandidate);
            }
        }
        for (Object source : sourcesToDelete) {
            count = this.tuplesForward.lookupOrEmpty(source).getCount(deleted);
            i = 0;
            while (i < count) {
                this.tuplesForward.removePair(source, deleted);
                ++i;
            }
        }
        for (Object target : targetsToDelete) {
            count = this.tuplesForward.lookupOrEmpty(deleted).getCount(target);
            i = 0;
            while (i < count) {
                this.tuplesForward.removePair(deleted, target);
                ++i;
            }
        }
        if (this.tuplesBackward != null) {
            for (Object source : sourcesToDelete) {
                count = this.tuplesBackward.lookupOrEmpty(deleted).getCount(source);
                i = 0;
                while (i < count) {
                    this.tuplesBackward.removePair(deleted, source);
                    ++i;
                }
            }
            for (Object target : targetsToDelete) {
                count = this.tuplesBackward.lookupOrEmpty(target).getCount(deleted);
                i = 0;
                while (i < count) {
                    this.tuplesBackward.removePair(target, deleted);
                    ++i;
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TcRelation = ");
        for (Object source : this.tuplesForward.distinctKeys()) {
            IMemoryView targets = this.tuplesForward.lookup(source);
            for (Object target : targets.distinctValues()) {
                sb.append("{(" + source + "," + target + ")," + targets.getCount(target) + "} ");
            }
        }
        return sb.toString();
    }

    @Override
    public Set<V> getTupleEnds(V source) {
        IMemoryView tupEnds = this.tuplesForward.lookup(source);
        if (tupEnds == null) {
            return null;
        }
        return tupEnds.distinctValues();
    }

    public Set<V> getTupleStarts(V target) {
        if (this.tuplesBackward != null) {
            IMemoryView tupStarts = this.tuplesBackward.lookup(target);
            if (tupStarts == null) {
                return null;
            }
            return tupStarts.distinctValues();
        }
        throw new UnsupportedOperationException("built without backward indexing");
    }

    @Override
    public Set<V> getTupleStarts() {
        Set nodes = CollectionsFactory.createSet();
        for (Object s : this.tuplesForward.distinctKeys()) {
            nodes.add(s);
        }
        return nodes;
    }

    public boolean containsTuple(V source, V target) {
        return this.tuplesForward.lookupOrEmpty(source).containsNonZero(target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CountingTcRelation aTR = (CountingTcRelation)obj;
        return this.tuplesForward.equals(aTR.tuplesForward);
    }

    public int hashCode() {
        return this.tuplesForward.hashCode();
    }

    public static <V> CountingTcRelation<V> createFrom(IBiDirectionalGraphDataSource<V> gds) {
        List<V> topologicalSorting = TopologicalSorting.compute(gds);
        CountingTcRelation<Object> tc = new CountingTcRelation<Object>(true);
        Collections.reverse(topologicalSorting);
        for (V n : topologicalSorting) {
            IMemoryView<V> sourceNodes = gds.getSourceNodes(n);
            Set<V> tupEnds = tc.getTupleEnds(n);
            for (Object s : sourceNodes.distinctValues()) {
                int count = sourceNodes.getCount(s);
                int i = 0;
                while (i < count) {
                    tc.updateTuple(s, n, true);
                    if (tupEnds != null) {
                        for (V t : tupEnds) {
                            tc.updateTuple(s, t, true);
                        }
                    }
                    ++i;
                }
            }
        }
        return tc;
    }
}

