/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.telnet.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.telnet.core.TelnetConnection;
import org.eclipse.remote.telnet.core.TelnetProtocol;
import org.eclipse.remote.telnet.internal.core.Logger;
import org.eclipse.remote.telnet.internal.core.messages.Messages;

public class TelnetCommandShell
implements IRemoteProcess {
    private final TelnetConnection telnetConnection;
    private TelnetProtocol protocol;

    public TelnetCommandShell(IRemoteConnection remoteConnection, TelnetConnection telnetConnection) {
        this.telnetConnection = telnetConnection;
        assert (remoteConnection.getService(IRemoteConnectionHostService.class) != null);
    }

    public void destroy() {
        if (this.protocol != null) {
            this.protocol.interrupt();
        }
    }

    public int exitValue() {
        return 0;
    }

    public InputStream getErrorStream() {
        return null;
    }

    public InputStream getInputStream() {
        if (this.protocol != null) {
            PipedOutputStream pipedOutput = new PipedOutputStream();
            this.protocol.setClientOutputStream(pipedOutput);
            try {
                return new PipedInputStream(pipedOutput);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public OutputStream getOutputStream() {
        if (this.protocol != null) {
            return this.protocol.getOutputStream();
        }
        return null;
    }

    public int waitFor() throws InterruptedException {
        if (this.protocol != null && this.protocol.isConnected()) {
            this.wait();
        }
        return 0;
    }

    public boolean isCompleted() {
        return this.protocol == null || !this.protocol.isAlive();
    }

    public IRemoteConnection getRemoteConnection() {
        return this.telnetConnection.getRemoteConnection();
    }

    public <T extends IRemoteProcess.Service> T getService(Class<T> service) {
        return null;
    }

    public <T extends IRemoteProcess.Service> boolean hasService(Class<T> service) {
        return false;
    }

    public IRemoteProcessBuilder getProcessBuilder() {
        return null;
    }

    public void connect() throws RemoteConnectionException {
        IRemoteConnectionHostService hostSvc = (IRemoteConnectionHostService)this.telnetConnection.getRemoteConnection().getService(IRemoteConnectionHostService.class);
        int remaining = 10;
        while (remaining >= 0) {
            if (remaining < 10) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                int nTimeout = hostSvc.getTimeout() * 1000;
                String strHost = hostSvc.getHostname();
                int nPort = hostSvc.getPort();
                InetSocketAddress address = new InetSocketAddress(strHost, nPort);
                Socket socket = new Socket();
                socket.connect(address, nTimeout);
                remaining = 0;
                socket.setOOBInline(true);
                socket.setKeepAlive(true);
                this.protocol = new TelnetProtocol(socket, this);
                this.protocol.start();
            }
            catch (UnknownHostException ex) {
                throw new RemoteConnectionException(Messages.TelnetCommandShell_0 + ex.getMessage());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new RemoteConnectionException(socketTimeoutException.getMessage());
            }
            catch (ConnectException connectException) {
                if (remaining == 0) {
                    throw new RemoteConnectionException(connectException.getMessage());
                }
                --remaining;
                continue;
            }
            catch (Exception exception) {
                try {
                    Logger.logException(exception);
                    throw new RemoteConnectionException(exception.getMessage());
                }
                catch (Throwable throwable) {
                    --remaining;
                    throw throwable;
                }
            }
            --remaining;
        }
    }

    protected void terminated() {
        this.telnetConnection.terminated(this);
    }
}

