/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPHP;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class PHPSourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
IInformationControlExtension3,
IInformationControlExtension5,
DisposeListener {
    private static final int BORDER = 1;
    private Shell fShell;
    private StyledText fText;
    private Font fTextFont;
    private SourceViewer fViewer;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private Dictionary<?, ?> fContextStyleMap = null;
    private IStructuredDocumentRegion fNodes = null;
    private RegionParser fParser = null;
    private LineStyleProviderForPHP styleProvider;
    private String fInput = "";
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor = false;

    public void setParser(RegionParser newParser) {
        this.fParser = newParser;
    }

    public void setContextStyleMap(Dictionary<?, ?> newContextStyleMap) {
        this.fContextStyleMap = newContextStyleMap;
    }

    public Dictionary<?, ?> getContextStyleMap() {
        return this.fContextStyleMap;
    }

    public RegionParser getParser() {
        return this.fParser;
    }

    public TextAttribute getAttribute(String namedStyle) {
        TextAttribute ta = new TextAttribute(this.fText.getBackground(), this.fText.getForeground(), 0);
        if (namedStyle != null && this.styleProvider != null) {
            ta = this.styleProvider.getTextAttributeForColor(namedStyle);
        }
        return ta;
    }

    public void applyStyles() {
        if (this.fText == null || this.fText.isDisposed() || this.fInput == null || this.fInput.length() == 0) {
            return;
        }
        IStructuredDocumentRegion node = this.fNodes;
        LineStyleProviderForPHP styler = new LineStyleProviderForPHP();
        ArrayList<StyleRange> holdResults = new ArrayList<StyleRange>();
        styler.prepareTextRegions(node, 0, this.fNodes.getEnd(), holdResults);
        for (StyleRange element : holdResults) {
            this.fText.setStyleRange(element);
        }
    }

    public void initColorsMap() {
        IModelManager mmanager = StructuredModelManager.getModelManager();
        this.setParser(mmanager.createStructuredDocumentFor(ContentTypeIdForPHP.ContentTypeID_PHP).getParser());
        this.styleProvider = new LineStyleProviderForPHP();
        Hashtable<String, String> contextStyleMap = new Hashtable<String, String>(this.styleProvider.getColorTypesMap());
        this.setContextStyleMap(contextStyleMap);
    }

    public PHPSourceViewerInformationControl(Shell parent, int shellStyle, int style) {
        this(parent, shellStyle, style, null);
    }

    public PHPSourceViewerInformationControl(Shell parent, int shellStyle, int style, String statusFieldText) {
        int border;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        style = style | 0x200 | 0x100;
        this.initializeColors();
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (shellStyle & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        if (statusFieldText != null) {
            composite = new Composite((Composite)composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 1;
            composite.setLayout((Layout)layout);
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(this.fBackgroundColor);
        }
        this.fViewer = new ProjectionViewer((Composite)composite, null, null, false, style);
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.fText.setForeground(parent.getDisplay().getSystemColor(28));
        this.fText.setBackground(this.fBackgroundColor);
        this.initializeFont();
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    PHPSourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        if (statusFieldText != null) {
            this.fSeparator = new Label((Composite)composite, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)composite, 131072);
            this.fStatusField.setText(statusFieldText);
            Font font = this.fStatusField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDatas);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gd2 = new GridData(1842);
            this.fStatusField.setLayoutData((Object)gd2);
            this.fStatusField.setForeground(display.getSystemColor(17));
            this.fStatusField.setBackground(display.getSystemColor(29));
        }
        this.initColorsMap();
        this.addDisposeListener(this);
    }

    private void initializeColors() {
        IPreferenceStore editorStore = EditorsPlugin.getDefault().getPreferenceStore();
        RGB bgRGB = editorStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : PreferenceConverter.getColor((IPreferenceStore)editorStore, (String)"AbstractTextEditor.Color.Background");
        if (bgRGB != null) {
            this.fBackgroundColor = new Color((Device)this.fShell.getDisplay(), bgRGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.fShell.getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    public PHPSourceViewerInformationControl(Shell parent, int style) {
        this(parent, 12, style);
    }

    public PHPSourceViewerInformationControl(Shell parent, int style, String statusFieldText) {
        this(parent, 12, style, statusFieldText);
    }

    public PHPSourceViewerInformationControl(Shell parent) {
        this(parent, 0);
    }

    public PHPSourceViewerInformationControl(Shell parent, String statusFieldText) {
        this(parent, 0, statusFieldText);
    }

    private void initializeFont() {
        this.fTextFont = JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont");
        StyledText styledText = this.getViewer().getTextWidget();
        styledText.setFont(this.fTextFont);
    }

    public void setInput(Object input) {
        if (input instanceof String) {
            this.setInformation((String)input);
        } else {
            this.setInformation(null);
        }
    }

    public void setInformation(String content) {
        if (content == null) {
            this.fViewer.setInput(null);
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<?");
        buf.append(content);
        buf.append("?>");
        Document doc = new Document(buf.toString());
        DocumentReader docReader = new DocumentReader((IDocument)doc);
        this.getParser().reset((Reader)docReader);
        IStructuredDocumentRegion sdRegion = this.getParser().getDocumentRegions();
        ITextRegionList phpRegionsList = sdRegion.getRegions();
        phpRegionsList.remove(0);
        phpRegionsList.remove(phpRegionsList.size() - 1);
        for (ITextRegion tokenRegion : phpRegionsList) {
            tokenRegion.adjustStart(-2);
        }
        sdRegion.setRegions(phpRegionsList);
        this.fInput = content;
        this.fNodes = sdRegion;
        doc = new Document(this.fInput);
        doc.setDocumentPartitioner((IDocumentPartitioner)new PHPStructuredTextPartitioner());
        this.fViewer.setInput((Object)doc);
        this.applyStyles();
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        if (this.fBackgroundColor != null && !this.fBackgroundColor.isDisposed() && !this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        this.fStatusTextFont = null;
        this.fShell = null;
        this.fText = null;
    }

    public final void dispose() {
        if (this.fBackgroundColor != null && !this.fBackgroundColor.isDisposed() && !this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void setSize(int width, int height) {
        if (this.fStatusField != null) {
            GridData gd = (GridData)this.fViewer.getTextWidget().getLayoutData();
            Point statusSize = this.fStatusField.computeSize(-1, -1, true);
            Point separatorSize = this.fSeparator.computeSize(-1, -1, true);
            gd.heightHint = height - statusSize.y - separatorSize.y;
        }
        this.fShell.setSize(width, height);
        if (this.fStatusField != null) {
            this.fShell.pack(true);
        }
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this.fShell.computeSize(x, y);
        if (size.x > this.fMaxWidth) {
            x = this.fMaxWidth;
        }
        if (size.y > this.fMaxHeight) {
            y = this.fMaxHeight;
        }
        if (x != -1 || y != -1) {
            size = this.fShell.computeSize(x, y, false);
        }
        return size;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this.fShell) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public boolean isVisible() {
        return this.fShell != null && !this.fShell.isDisposed() && this.fShell.isVisible();
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        GC gc = new GC((Drawable)this.fText);
        gc.setFont(this.fTextFont);
        double width = gc.getFontMetrics().getAverageCharacterWidth();
        int height = this.fText.getLineHeight();
        gc.dispose();
        return new Point((int)((double)widthInChars * width), heightInChars * height);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new PHPSourceViewerInformationControl(parent);
            }
        };
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public Rectangle computeTrim() {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        this.addInternalTrim(trim);
        return trim;
    }

    private void addInternalTrim(Rectangle trim) {
        Rectangle textTrim = this.fText.computeTrim(0, 0, 0, 0);
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
        if (this.fStatusField != null) {
            trim.height += this.fSeparator.computeSize((int)-1, (int)-1).y;
            trim.height += this.fStatusField.computeSize((int)-1, (int)-1).y;
            ++trim.height;
        }
    }

    public boolean restoresSize() {
        return false;
    }

    public boolean restoresLocation() {
        return false;
    }
}

