/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.core;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.core.EvaluationContext;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMContext;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMContext;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;

public class OCLEvaluationContext
extends EvaluationContext {
    private final @Nullable ExpressionInOCL expressionObject;
    private final @Nullable EObject contextObject;
    private final @NonNull URI constraintURI;
    private final @Nullable URI contextURI;

    protected static @NonNull IVMContext createVMContext(@Nullable ExpressionInOCL expressionObject, @Nullable EObject contextObject) {
        EnvironmentFactoryInternal environmentFactory = ThreadLocalExecutor.basicGetEnvironmentFactory();
        if (environmentFactory == null) {
            environmentFactory = ASResourceFactoryRegistry.INSTANCE.createEnvironmentFactory(OCL.NO_PROJECTS, null);
        }
        return new VMContext(environmentFactory);
    }

    public OCLEvaluationContext(@NonNull ExpressionInOCL expressionObject, @Nullable EObject contextObject) {
        super(OCLEvaluationContext.createVMContext(expressionObject, contextObject));
        this.expressionObject = expressionObject;
        this.contextObject = contextObject;
        this.constraintURI = (URI)ClassUtil.nonNullState((Object)EcoreUtil.getURI((EObject)expressionObject));
        this.contextURI = contextObject != null ? EcoreUtil.getURI((EObject)contextObject) : null;
    }

    public OCLEvaluationContext(@NonNull URI constraintURI, @NonNull URI contextURI) {
        super(OCLEvaluationContext.createVMContext(null, null));
        this.expressionObject = null;
        this.contextObject = null;
        this.constraintURI = constraintURI;
        this.contextURI = contextURI;
    }

    public @NonNull URI getConstraintURI() {
        return this.constraintURI;
    }

    public @Nullable EObject getContextObject() {
        return this.contextObject;
    }

    public @Nullable URI getContextURI() {
        return this.contextURI;
    }

    public @NonNull URI getDebuggableURI() {
        return this.constraintURI;
    }

    public @Nullable ExpressionInOCL getExpressionObject() {
        return this.expressionObject;
    }
}

