/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.tld;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLElementDeclaration;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.w3c.dom.Element;

public final class CMUtil {
    public static String getTagURI(CMElementDeclaration decl) {
        CMDocument doc;
        if (decl instanceof CMNodeWrapper) {
            decl = (CMElementDeclaration)((CMNodeWrapper)decl).getOriginNode();
        }
        if (decl instanceof TLDElementDeclaration && (doc = ((TLDElementDeclaration)decl).getOwnerDocument()) instanceof TLDDocument) {
            TLDDocument tldDoc = (TLDDocument)doc;
            return CMUtil.getURIFromDoc(tldDoc, null);
        }
        return null;
    }

    public static String getURIFromDoc(TLDDocument doc, IProject project) {
        String uri = doc.getUri();
        IProject proj = project;
        if (uri == null) {
            Path baseLoc = new Path(doc.getBaseLocation());
            if (proj == null && (proj = CMUtil.getProjectFor((IPath)baseLoc)) == null) {
                return null;
            }
            uri = CMUtil.isTagDirDocument(doc, proj) ? CMUtil.getTagDirURI(doc, proj) : CMUtil.getStandaloneTLDURI(doc, proj);
        }
        return uri;
    }

    public static String getURIFromTaglibRecord(ITaglibRecord tldRec, IProject project) {
        String uri = tldRec.getDescriptor().getURI();
        if (uri == null || uri.trim().equals("")) {
            CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
            TLDDocument doc = (TLDDocument)factory.createCMDocument(tldRec);
            if (tldRec.getRecordType() == 1) {
                uri = CMUtil.getStandaloneTLDURI(doc, project);
            } else if (tldRec.getRecordType() == 8) {
                uri = CMUtil.getTagDirURI(doc, project);
            }
        }
        return uri;
    }

    private static String getStandaloneTLDURI(TLDDocument doc, IProject project) {
        Path p = new Path(doc.getBaseLocation());
        IPath webContentPath = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getLocation();
        return CMUtil.getURIFromPath(p.makeAbsolute().makeRelativeTo(webContentPath.makeAbsolute()));
    }

    private static String getTagDirURI(TLDDocument doc, IProject project) {
        IVirtualFolder rootFolder;
        Path p = new Path(doc.getBaseLocation());
        IVirtualComponent projectComp = ComponentCore.createComponent((IProject)project);
        if (projectComp != null && (rootFolder = projectComp.getRootFolder()) != null) {
            IPath webContentPath = rootFolder.getUnderlyingFolder().getFullPath();
            return CMUtil.getURIFromPath(p.makeRelativeTo(webContentPath));
        }
        return null;
    }

    private static String getURIFromPath(IPath uriPath) {
        if (uriPath != null) {
            return "/" + uriPath.toString();
        }
        return null;
    }

    public static boolean isTagDirDocument(TLDDocument tldDoc, IProject project) {
        IPath webContentPath;
        Path p;
        return (tldDoc.getUri() == null || tldDoc.getUri().equals("")) && (p = new Path(tldDoc.getBaseLocation())).matchingFirstSegments(webContentPath = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getFullPath()) == webContentPath.segmentCount() && (p = p.removeFirstSegments(webContentPath.segmentCount())).matchingFirstSegments((IPath)new Path("WEB-INF/tags")) == 2;
    }

    private static IProject getProjectFor(IPath path) {
        IResource res;
        String[] segs = path.segments();
        Object projectPath = new String();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IProject project = null;
        int p = 0;
        while (p < projects.length) {
            if (projects[p].isOpen()) {
                int s = 0;
                while (s < segs.length) {
                    if (segs[s].equalsIgnoreCase(projects[p].getName())) {
                        int s2 = s + 1;
                        while (s2 < segs.length) {
                            projectPath = (String)projectPath + "/" + segs[s2];
                            ++s2;
                        }
                        project = projects[p];
                        break;
                    }
                    ++s;
                }
            }
            ++p;
        }
        if (project == null) {
            return null;
        }
        if (!project.getWorkspace().isTreeLocked()) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                JSFCorePlugin.log(2, "Error.RefreshingLocal", e);
            }
        }
        if ((res = project.findMember((IPath)new Path((String)projectPath))) != null && res.exists()) {
            return project;
        }
        return null;
    }

    public static boolean isJSP(CMElementDeclaration decl) {
        if (!decl.supports("isJSP")) {
            return false;
        }
        Boolean b = (Boolean)decl.getProperty("isJSP");
        return b;
    }

    public static boolean isHTML(CMElementDeclaration decl) {
        return !CMUtil.isJSP(decl) && decl instanceof HTMLElementDeclaration;
    }

    public static CMElementDeclaration getElementDeclaration(Element element) {
        if (element == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)element.getOwnerDocument();
        if (notifier == null) {
            return null;
        }
        ModelQueryAdapter mqa = (ModelQueryAdapter)notifier.getAdapterFor(ModelQueryAdapter.class);
        if (mqa == null) {
            return null;
        }
        return mqa.getModelQuery().getCMElementDeclaration(element);
    }

    public static TLDElementDeclaration getTLDElementDeclaration(Element element) {
        CMElementDeclaration decl = CMUtil.getElementDeclaration(element);
        if (decl instanceof CMNodeWrapper) {
            decl = ((CMNodeWrapper)decl).getOriginNode();
        }
        if (decl instanceof TLDElementDeclaration) {
            return (TLDElementDeclaration)decl;
        }
        return null;
    }

    public static CMElementDeclaration getTLDElementDeclaration(String uri, String elementName, IDocument document) {
        TLDCMDocumentManager tldmgr = TaglibController.getTLDCMDocumentManager((IDocument)document);
        if (tldmgr != null) {
            for (TaglibTracker tracker : tldmgr.getTaglibTrackers()) {
                if (!tracker.getURI().equals(uri)) continue;
                return (CMElementDeclaration)tracker.getElements().getNamedItem(tracker.getPrefix() + ":" + elementName);
            }
        }
        return null;
    }

    public static String getElementNamespaceURI(Element element) {
        CMElementDeclaration decl = CMUtil.getElementDeclaration(element);
        if (decl == null) {
            String uri = element.getNamespaceURI();
            return uri;
        }
        if (CMUtil.isJSP(decl)) {
            return "jsp";
        }
        if (CMUtil.isHTML(decl)) {
            return "html";
        }
        return CMUtil.getTagURI(decl);
    }

    public static boolean canHaveDirectTextChild(Element element) {
        CMElementDeclaration decl = CMUtil.getElementDeclaration(element);
        if (decl == null) {
            return true;
        }
        int contentType = decl.getContentType();
        return contentType != 2 && contentType != 1;
    }

    private CMUtil() {
    }
}

