/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Map;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.ExternalGpg;
import org.eclipse.egit.core.internal.signing.ExternalProcessRunner;
import org.eclipse.egit.core.internal.signing.GpgConfigurationException;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

public class ExternalGpgSigner
extends GpgSigner
implements GpgObjectSigner {
    private static final String PINENTRY_USER_DATA = "PINENTRY_USER_DATA";
    private static final String GPG_TTY = "GPG_TTY";

    public void sign(CommitBuilder commit, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        this.signObject((ObjectBuilder)commit, gpgSigningKey, committer, null, null);
    }

    public void signObject(ObjectBuilder object, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException {
        try {
            String keySpec = gpgSigningKey;
            if (StringUtils.isEmptyOrNull((String)gpgSigningKey)) {
                keySpec = String.valueOf('<') + committer.getEmailAddress() + '>';
            }
            object.setGpgSignature(new GpgSignature(this.signWithGpg(object.build(), keySpec, config)));
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        return this.canLocateSigningKey(gpgSigningKey, committer, null, null);
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException {
        String program;
        String string = program = config != null ? config.getProgram() : null;
        if (StringUtils.isEmptyOrNull((String)program) && StringUtils.isEmptyOrNull((String)(program = ExternalGpg.getGpg()))) {
            return false;
        }
        String keySpec = gpgSigningKey;
        if (StringUtils.isEmptyOrNull((String)keySpec)) {
            keySpec = String.valueOf('<') + committer.getEmailAddress() + '>';
        }
        ProcessBuilder process = new ProcessBuilder(new String[0]);
        process.command(program, "--locate-keys", "--with-colons", "--batch", "--no-tty", keySpec);
        this.gpgEnvironment(process);
        try {
            boolean[] result = new boolean[1];
            ExternalProcessRunner.run(process, null, b -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (BufferedReader r = new BufferedReader(new InputStreamReader(b.openInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    boolean keyFound = false;
                    while ((line = r.readLine()) != null) {
                        String[] fields;
                        if (!line.startsWith("pub:") && !line.startsWith("sub:") || (fields = line.split(":")).length <= 11 || fields[11].indexOf(115) < 0) continue;
                        keyFound = true;
                        break;
                    }
                    blArray[0] = keyFound;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }, null);
            if (!result[0] && !StringUtils.isEmptyOrNull((String)gpgSigningKey)) {
                Activator.logWarning(MessageFormat.format(CoreText.ExternalGpgSigner_noKeyFound, gpgSigningKey), null);
            }
            return result[0];
        }
        catch (IOException e) {
            Activator.logError(e.getLocalizedMessage(), e);
            return false;
        }
    }

    private byte[] signWithGpg(byte[] data, String keySpec, GpgConfig config) throws IOException, CanceledException {
        String program;
        String string = program = config != null ? config.getProgram() : null;
        if (StringUtils.isEmptyOrNull((String)program) && StringUtils.isEmptyOrNull((String)(program = ExternalGpg.getGpg()))) {
            throw new IOException(CoreText.ExternalGpgSigner_gpgNotFound);
        }
        ProcessBuilder process = new ProcessBuilder(new String[0]);
        process.command(program, "-bsau", keySpec, "--batch", "--no-tty", "--status-fd", "2", "--output", "-");
        this.gpgEnvironment(process);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ByteArrayInputStream dataIn = new ByteArrayInputStream(data);){
            class Holder {
                byte[] rawData;

                Holder() {
                }
            }
            Holder result = new Holder();
            ExternalProcessRunner.run(process, dataIn, b -> {
                boolean isValid = false;
                Throwable error = null;
                try {
                    isValid = this.isValidSignature(b);
                }
                catch (IOException | PGPException e) {
                    error = e;
                }
                if (!isValid) {
                    throw new IOException(MessageFormat.format(CoreText.ExternalGpgSigner_noSignature, ExternalProcessRunner.toString(b)), error);
                }
                holder.rawData = b.toByteArray();
            }, e -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferedReader r = new BufferedReader(new InputStreamReader(e.openInputStream(), StandardCharsets.UTF_8));){
                        String line;
                        boolean pinentry = false;
                        while ((line = r.readLine()) != null) {
                            if (!pinentry && line.startsWith("[GNUPG:] PINENTRY_LAUNCHED")) {
                                pinentry = true;
                                this.checkTerminalPrompt(line);
                                continue;
                            }
                            if (!pinentry) continue;
                            if (line.startsWith("[GNUPG:] FAILURE sign")) {
                                throw new CanceledException(CoreText.ExternalGpgSigner_signingCanceled);
                            }
                            if (!line.startsWith("[GNUPG:]")) continue;
                            pinentry = false;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return result.rawData;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private PGPSignature parseSignature(InputStream in) throws IOException, PGPException {
        InputStream sigIn;
        block14: {
            PGPSignature pGPSignature;
            block15: {
                Object obj;
                block12: {
                    PGPSignature pGPSignature2;
                    block13: {
                        Throwable throwable = null;
                        Object var3_4 = null;
                        sigIn = PGPUtil.getDecoderStream((InputStream)in);
                        try {
                            BcPGPObjectFactory pgpFactory = new BcPGPObjectFactory(sigIn);
                            obj = pgpFactory.nextObject();
                            if (obj instanceof PGPCompressedData) {
                                obj = new BcPGPObjectFactory(((PGPCompressedData)obj).getDataStream()).nextObject();
                            }
                            if (!(obj instanceof PGPSignatureList)) break block12;
                            pGPSignature2 = ((PGPSignatureList)obj).get(0);
                            if (sigIn == null) break block13;
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (sigIn != null) {
                                    sigIn.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        sigIn.close();
                    }
                    return pGPSignature2;
                }
                if (!(obj instanceof PGPSignature)) break block14;
                pGPSignature = (PGPSignature)obj;
                if (sigIn == null) break block15;
                sigIn.close();
            }
            return pGPSignature;
        }
        if (sigIn != null) {
            sigIn.close();
        }
        return null;
    }

    private boolean isValidSignature(TemporaryBuffer b) throws IOException, PGPException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream data = b.openInputStream();){
            boolean bl = this.parseSignature(data) != null;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void gpgEnvironment(ProcessBuilder process) {
        try {
            Map<String, String> childEnv = process.environment();
            String value = childEnv.get(PINENTRY_USER_DATA);
            if (!StringUtils.isEmptyOrNull((String)value)) {
                childEnv.remove(PINENTRY_USER_DATA);
            }
            if (!StringUtils.isEmptyOrNull((String)(value = childEnv.get(GPG_TTY)))) {
                childEnv.remove(GPG_TTY);
            }
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            Activator.logWarning(CoreText.ExternalGpgSigner_environmentError, e);
        }
    }

    private void checkTerminalPrompt(String gpgTraceLine) {
        String pinentryType;
        String[] parts = gpgTraceLine.split(" ");
        if (parts.length > 3 && "[GNUPG:]".equals(parts[0]) && "PINENTRY_LAUNCHED".equals(parts[1]) && ("tty".equals(pinentryType = parts[3]) || "curses".equals(pinentryType))) {
            throw new GpgConfigurationException(MessageFormat.format(CoreText.ExternalGpgSigner_ttyInput, gpgTraceLine));
        }
    }
}

