/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share.io;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddAbortException;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.example.collab.share.io.FileReceiverUI;
import org.eclipse.ecf.example.collab.share.io.FileSenderUI;
import org.eclipse.ecf.example.collab.share.io.FileTransferListener;
import org.eclipse.ecf.example.collab.share.io.FileTransferParams;
import org.eclipse.ecf.example.collab.share.io.FileTransferSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class EclipseFileTransfer
extends FileTransferSharedObject
implements FileTransferListener {
    private static final long serialVersionUID = -4496151870561737078L;
    FileSenderUI senderUI;
    ID sharedObjectID;
    protected File localFile = null;
    protected FileReceiverUI receiverUI = null;
    protected EclipseCollabSharedObject receiver = null;

    public EclipseFileTransfer(FileSenderUI view, ID target, InputStream ins, FileTransferParams params, ID sharedObjectID) {
        super(target, ins, params);
        this.senderUI = view;
        this.progressListener = this;
        this.sharedObjectID = sharedObjectID;
    }

    @Override
    protected void addRemoteParticipants(ID[] ids) {
        ID groupID = this.getContext().getConnectedID();
        if (ids != null && this.participantIDs != null) {
            int i = 0;
            while (i < ids.length) {
                if (groupID == null || !groupID.equals((Object)ids[i])) {
                    if (this.targetReceiver == null) {
                        if (!this.getHomeContainerID().equals((Object)ids[i])) {
                            this.participantIDs.add(ids[i]);
                        }
                    } else if (this.targetReceiver.equals((Object)ids[i])) {
                        this.participantIDs.add(ids[i]);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    protected ReplicaSharedObjectDescription getReplicaDescription(ID remoteMember) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("args", new Object[]{this.transferParams, this.sharedObjectID});
        return new ReplicaSharedObjectDescription(this.getClass(), this.getID(), this.getConfig().getHomeContainerID(), map, EclipseFileTransfer.getNextReplicateID());
    }

    @Override
    public void init(ISharedObjectConfig config) throws SharedObjectInitException {
        super.init(config);
        Map props = config.getProperties();
        Object[] args = (Object[])props.get("args");
        if (args != null && args.length == 2) {
            this.transferParams = (FileTransferParams)args[0];
            this.sharedObjectID = (ID)args[1];
            this.progressListener = this;
        }
        if (args != null && args.length == 5) {
            this.senderUI = (FileSenderUI)args[0];
            this.targetReceiver = (ID)args[1];
            this.setInputStream((InputStream)args[2]);
            this.transferParams = (FileTransferParams)args[3];
            this.sharedObjectID = (ID)args[4];
            this.progressListener = this;
        }
    }

    public EclipseFileTransfer(FileTransferParams params, ID receiverID) {
        super(params);
        this.progressListener = this;
        this.sharedObjectID = receiverID;
    }

    public EclipseFileTransfer() {
    }

    @Override
    public void sendStart(FileTransferSharedObject obj, long length, float rate) {
        if (this.senderUI != null) {
            this.senderUI.sendStart(this.transferParams.getRemoteFile(), length, rate);
        }
    }

    @Override
    public void sendData(FileTransferSharedObject obj, int dataLength) {
        if (this.senderUI != null) {
            this.senderUI.sendData(this.transferParams.getRemoteFile(), dataLength);
        }
    }

    @Override
    public void sendDone(FileTransferSharedObject obj, Exception e) {
        if (this.senderUI != null) {
            this.senderUI.sendDone(this.transferParams.getRemoteFile(), e);
        }
    }

    protected File createPath(EclipseCollabSharedObject sharedObject, boolean server, File file, long length, float rate) {
        File downloadDir = new File(sharedObject.getLocalFullDownloadPath());
        downloadDir.mkdirs();
        File retFile = new File(downloadDir, file.getName());
        return retFile;
    }

    @Override
    public void receiveStart(FileTransferSharedObject obj, File aFile, long length, float rate) {
        final FileReceiver r = new FileReceiver(aFile, length, rate);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                r.run();
            }
        });
    }

    @Override
    public void receiveData(FileTransferSharedObject obj, int dataLength) {
        if (this.receiverUI != null) {
            this.receiverUI.receiveData(this.getHomeContainerID(), this.localFile, dataLength);
        }
    }

    @Override
    public void receiveDone(FileTransferSharedObject obj, Exception e) {
        if (this.receiverUI != null) {
            this.receiverUI.receiveDone(this.getHomeContainerID(), this.localFile, e);
        }
    }

    @Override
    protected boolean votingCompleted() throws SharedObjectAddAbortException {
        if (this.failedParticipants != null && this.failedParticipants.size() > 0) {
            return true;
        }
        return this.state == 1 && this.participantIDs.size() == 0;
    }

    private class FileReceiver
    implements Runnable {
        private File aFile = null;
        private final long length;
        private final float rate;

        public FileReceiver(File aFile, long length, float rate) {
            this.aFile = aFile;
            this.length = length;
            this.rate = rate;
        }

        @Override
        public void run() {
            if (ClientPlugin.getDefault().getPluginPreferences().getBoolean("confirmFileReceive")) {
                MessageDialog dialog = new MessageDialog(ClientPlugin.getDefault().getActiveShell(), Messages.EclipseFileTransfer_DIALOG_RECEIVE_CONF_TITLE, null, Messages.EclipseFileTransfer_DIALOG_RECEIVE_CONF_TEXT, 3, null, 0);
                dialog.setBlockOnOpen(true);
                int response = dialog.open();
                if (response == 1) {
                    return;
                }
            }
            EclipseFileTransfer.this.receiver = (EclipseCollabSharedObject)EclipseFileTransfer.this.getContext().getSharedObjectManager().getSharedObject(EclipseFileTransfer.this.sharedObjectID);
            EclipseFileTransfer.this.receiverUI = EclipseFileTransfer.this.receiver.getFileReceiverUI(EclipseFileTransfer.this, EclipseFileTransfer.this.transferParams);
            EclipseFileTransfer.this.localFile = EclipseFileTransfer.this.createPath(EclipseFileTransfer.this.receiver, EclipseFileTransfer.this.getContext().isGroupManager(), this.aFile, this.length, this.rate);
            EclipseFileTransfer.this.transferParams.setRemoteFile(EclipseFileTransfer.this.localFile);
            if (EclipseFileTransfer.this.receiverUI != null) {
                EclipseFileTransfer.this.receiverUI.receiveStart(EclipseFileTransfer.this.getHomeContainerID(), EclipseFileTransfer.this.localFile, this.length, this.rate);
            }
        }
    }
}

