/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.lsp.clangd.ClangdCProjectDescriptionListener;
import org.eclipse.cdt.lsp.clangd.ClangdCompilationDatabaseSettings;
import org.eclipse.cdt.lsp.clangd.internal.config.MacroResolver;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.yaml.snakeyaml.Yaml;

@Component(property={"service.ranking:Integer=0"})
public class ClangdConfigurationFileManager
implements ClangdCProjectDescriptionListener {
    public static final String CLANGD_CONFIG_FILE_NAME = ".clangd";
    private static final String COMPILE_FLAGS = "CompileFlags";
    private static final String COMPILATTION_DATABASE = "CompilationDatabase";
    private static final String SET_COMPILATION_DB = "CompileFlags: {CompilationDatabase: %s}";
    private static final String EMPTY = "";
    @Reference
    private ICBuildConfigurationManager build;
    @Reference
    private ClangdCompilationDatabaseSettings settings;

    @Override
    public void handleEvent(CProjectDescriptionEvent event) {
        this.setCompilationDatabasePath(event.getProject(), event.getNewCProjectDescription());
    }

    protected void setCompilationDatabasePath(IProject project, ICProjectDescription newCProjectDescription) {
        if (project != null && newCProjectDescription != null && this.settings.enableSetCompilationDatabasePath(project)) {
            String relativeDatabasePath = this.getRelativeDatabasePath(project, newCProjectDescription);
            if (!relativeDatabasePath.isEmpty()) {
                this.setCompilationDatabase(project, relativeDatabasePath);
            } else {
                Platform.getLog(this.getClass()).error("Cannot determine path to compile_commands.json");
            }
        }
    }

    private String getRelativeDatabasePath(IProject project, ICProjectDescription newCProjectDescription) {
        if (project != null && newCProjectDescription != null) {
            ICConfigurationDescription config = newCProjectDescription.getDefaultSettingConfiguration();
            IPath cwdBuilder = config.getBuildSetting().getBuilderCWD();
            String projectLocation = project.getLocation().addTrailingSeparator().toOSString();
            if (cwdBuilder != null) {
                try {
                    String cwdString = new MacroResolver().resolveValue(cwdBuilder.toOSString(), EMPTY, null, config);
                    return cwdString.replace(projectLocation, EMPTY);
                }
                catch (CdtVariableException e) {
                    Platform.getLog(this.getClass()).log(e.getStatus());
                }
            } else {
                return this.buildConfiguration((IResource)project).filter(CBuildConfiguration.class::isInstance).map(bc -> {
                    try {
                        return ((CBuildConfiguration)bc).getBuildContainer();
                    }
                    catch (CoreException e) {
                        Platform.getLog(this.getClass()).log(e.getStatus());
                        return null;
                    }
                }).map(c -> c.getLocation()).map(l -> l.toOSString().replace(projectLocation, EMPTY)).orElse(EMPTY);
            }
        }
        return EMPTY;
    }

    private Optional<ICBuildConfiguration> buildConfiguration(IResource initial) {
        try {
            IBuildConfiguration active = initial.getProject().getActiveBuildConfig();
            if (active != null && this.build != null) {
                return Optional.ofNullable(this.build.getBuildConfiguration(active));
            }
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }

    public void setCompilationDatabase(IProject project, String databasePath) {
        block28: {
            IFile configFile = project.getFile(CLANGD_CONFIG_FILE_NAME);
            try {
                if (this.createClangdConfigFile(configFile, project.getDefaultCharset(), databasePath, false)) {
                    return;
                }
                Map data = null;
                Yaml yaml = new Yaml();
                Throwable throwable = null;
                Object var7_10 = null;
                try (InputStream inputStream = configFile.getContents();){
                    try {
                        data = (Map)yaml.load(inputStream);
                    }
                    catch (Exception e) {
                        Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (data == null) {
                    this.createClangdConfigFile(configFile, project.getDefaultCharset(), databasePath, true);
                    return;
                }
                Map map = (Map)data.get(COMPILE_FLAGS);
                if (map == null) break block28;
                Object cdb = map.get(COMPILATTION_DATABASE);
                if (cdb != null && cdb instanceof String && cdb.equals(databasePath)) {
                    return;
                }
                map.put(COMPILATTION_DATABASE, databasePath);
                data.put(COMPILE_FLAGS, map);
                Throwable throwable3 = null;
                Object var9_15 = null;
                try (PrintWriter yamlWriter = new PrintWriter(configFile.getLocation().toFile());){
                    yaml.dump((Object)data, (Writer)yamlWriter);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (CoreException e) {
                Platform.getLog(this.getClass()).log(e.getStatus());
            }
            catch (IOException e) {
                Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean createClangdConfigFile(IFile configFile, String charset, String databasePath, boolean overwriteContent) {
        block17: {
            if (!configFile.exists() || overwriteContent) {
                block16: {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    ByteArrayInputStream data = new ByteArrayInputStream(String.format(SET_COMPILATION_DB, databasePath).getBytes(charset));
                    try {
                        if (overwriteContent) {
                            configFile.setContents((InputStream)data, 2, (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            configFile.create((InputStream)data, false, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (data == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (data != null) {
                                    data.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (CoreException e) {
                            Platform.getLog(this.getClass()).log(e.getStatus());
                            break block17;
                        }
                        catch (IOException e) {
                            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                        }
                    }
                    data.close();
                }
                return true;
            }
        }
        return false;
    }
}

