/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.SwarmJoin;

final class ImmutableSwarmJoin
implements SwarmJoin {
    private final String listenAddr;
    @Nullable
    private final String advertiseAddr;
    private final List<String> remoteAddrs;
    private final String joinToken;

    private ImmutableSwarmJoin(String listenAddr, @Nullable String advertiseAddr, List<String> remoteAddrs, String joinToken) {
        this.listenAddr = listenAddr;
        this.advertiseAddr = advertiseAddr;
        this.remoteAddrs = remoteAddrs;
        this.joinToken = joinToken;
    }

    @Override
    @JsonProperty(value="ListenAddr")
    public String listenAddr() {
        return this.listenAddr;
    }

    @Override
    @JsonProperty(value="AdvertiseAddr")
    @Nullable
    public String advertiseAddr() {
        return this.advertiseAddr;
    }

    @Override
    @JsonProperty(value="RemoteAddrs")
    public List<String> remoteAddrs() {
        return this.remoteAddrs;
    }

    @Override
    @JsonProperty(value="JoinToken")
    public String joinToken() {
        return this.joinToken;
    }

    public final ImmutableSwarmJoin withListenAddr(String value) {
        String newValue = Objects.requireNonNull(value, "listenAddr");
        if (this.listenAddr.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmJoin(newValue, this.advertiseAddr, this.remoteAddrs, this.joinToken);
    }

    public final ImmutableSwarmJoin withAdvertiseAddr(@Nullable String value) {
        if (Objects.equals(this.advertiseAddr, value)) {
            return this;
        }
        return new ImmutableSwarmJoin(this.listenAddr, value, this.remoteAddrs, this.joinToken);
    }

    public final ImmutableSwarmJoin withRemoteAddrs(String ... elements) {
        List<String> newValue = ImmutableSwarmJoin.createUnmodifiableList(false, ImmutableSwarmJoin.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSwarmJoin(this.listenAddr, this.advertiseAddr, newValue, this.joinToken);
    }

    public final ImmutableSwarmJoin withRemoteAddrs(Iterable<String> elements) {
        if (this.remoteAddrs == elements) {
            return this;
        }
        List<String> newValue = ImmutableSwarmJoin.createUnmodifiableList(false, ImmutableSwarmJoin.createSafeList(elements, true, false));
        return new ImmutableSwarmJoin(this.listenAddr, this.advertiseAddr, newValue, this.joinToken);
    }

    public final ImmutableSwarmJoin withJoinToken(String value) {
        String newValue = Objects.requireNonNull(value, "joinToken");
        if (this.joinToken.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmJoin(this.listenAddr, this.advertiseAddr, this.remoteAddrs, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSwarmJoin && this.equalTo(0, (ImmutableSwarmJoin)another);
    }

    private boolean equalTo(int synthetic, ImmutableSwarmJoin another) {
        return this.listenAddr.equals(another.listenAddr) && Objects.equals(this.advertiseAddr, another.advertiseAddr) && this.remoteAddrs.equals(another.remoteAddrs) && this.joinToken.equals(another.joinToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.listenAddr.hashCode();
        h += (h << 5) + Objects.hashCode(this.advertiseAddr);
        h += (h << 5) + this.remoteAddrs.hashCode();
        h += (h << 5) + this.joinToken.hashCode();
        return h;
    }

    public String toString() {
        return "SwarmJoin{listenAddr=" + this.listenAddr + ", advertiseAddr=" + this.advertiseAddr + ", remoteAddrs=" + this.remoteAddrs + ", joinToken=" + this.joinToken + "}";
    }

    public static ImmutableSwarmJoin copyOf(SwarmJoin instance) {
        if (instance instanceof ImmutableSwarmJoin) {
            return (ImmutableSwarmJoin)instance;
        }
        return ImmutableSwarmJoin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements SwarmJoin.Builder {
        private static final long INIT_BIT_LISTEN_ADDR = 1L;
        private static final long INIT_BIT_JOIN_TOKEN = 2L;
        private long initBits = 3L;
        private String listenAddr;
        private String advertiseAddr;
        private List<String> remoteAddrs = new ArrayList<String>();
        private String joinToken;

        private Builder() {
        }

        public final Builder from(SwarmJoin instance) {
            Objects.requireNonNull(instance, "instance");
            this.listenAddr(instance.listenAddr());
            String advertiseAddrValue = instance.advertiseAddr();
            if (advertiseAddrValue != null) {
                this.advertiseAddr(advertiseAddrValue);
            }
            this.addAllRemoteAddrs(instance.remoteAddrs());
            this.joinToken(instance.joinToken());
            return this;
        }

        @Override
        @JsonProperty(value="ListenAddr")
        public final Builder listenAddr(String listenAddr) {
            this.listenAddr = Objects.requireNonNull(listenAddr, "listenAddr");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="AdvertiseAddr")
        public final Builder advertiseAddr(@Nullable String advertiseAddr) {
            this.advertiseAddr = advertiseAddr;
            return this;
        }

        public final Builder remoteAddr(String element) {
            this.remoteAddrs.add(Objects.requireNonNull(element, "remoteAddrs element"));
            return this;
        }

        public final Builder remoteAddrs(String ... elements) {
            for (String element : elements) {
                this.remoteAddrs.add(Objects.requireNonNull(element, "remoteAddrs element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="RemoteAddrs")
        public final Builder remoteAddrs(Iterable<String> elements) {
            this.remoteAddrs.clear();
            return this.addAllRemoteAddrs(elements);
        }

        public final Builder addAllRemoteAddrs(Iterable<String> elements) {
            for (String element : elements) {
                this.remoteAddrs.add(Objects.requireNonNull(element, "remoteAddrs element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="JoinToken")
        public final Builder joinToken(String joinToken) {
            this.joinToken = Objects.requireNonNull(joinToken, "joinToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableSwarmJoin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSwarmJoin(this.listenAddr, this.advertiseAddr, ImmutableSwarmJoin.createUnmodifiableList(true, this.remoteAddrs), this.joinToken);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("listenAddr");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("joinToken");
            }
            return "Cannot build SwarmJoin, some of required attributes are not set " + attributes;
        }
    }
}

