/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IDropToFrameHandler;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.commands.ActionStepOut;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFRunnable;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;

public class DropToFrameCommand
implements IDropToFrameHandler {
    private final TCFModel model;

    public DropToFrameCommand(TCFModel model) {
        this.model = model;
    }

    public void canExecute(final IEnabledStateRequest request) {
        new TCFRunnable(this.model, (IRequest)request){

            @Override
            public void run() {
                Object[] elements = request.getElements();
                if (elements.length != 1 || !(elements[0] instanceof TCFNodeStackFrame)) {
                    request.setEnabled(false);
                    this.done();
                    return;
                }
                TCFNodeStackFrame frame_node = (TCFNodeStackFrame)elements[0];
                TCFNodeExecContext exe_node = (TCFNodeExecContext)frame_node.getParent();
                if (!exe_node.getStackTrace().validate(this)) {
                    return;
                }
                if (frame_node.getFrameNo() < 1) {
                    request.setEnabled(false);
                    this.done();
                    return;
                }
                TCFDataCache<IRunControl.RunControlContext> ctx_cache = exe_node.getRunContext();
                if (!ctx_cache.validate((Runnable)this)) {
                    return;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)ctx_cache.getData();
                if (!this.canStepOut(ctx)) {
                    request.setEnabled(false);
                    this.done();
                    return;
                }
                int action_cnt = DropToFrameCommand.this.model.getLaunch().getContextActionsCount(ctx.getID());
                if (action_cnt > 0 || !this.canStepOut(ctx)) {
                    request.setEnabled(false);
                    this.done();
                    return;
                }
                TCFDataCache<TCFContextState> state_cache = exe_node.getMinState();
                if (!state_cache.validate((Runnable)this)) {
                    return;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                request.setEnabled(state_data != null && state_data.is_suspended);
                this.done();
            }

            private boolean canStepOut(IRunControl.RunControlContext ctx) {
                if (ctx == null) {
                    return false;
                }
                if (ctx.canResume(5)) {
                    return true;
                }
                if (!ctx.hasState()) {
                    return false;
                }
                return ctx.canResume(0) && DropToFrameCommand.this.model.getLaunch().getService(IBreakpoints.class) != null;
            }
        };
    }

    public boolean execute(final IDebugCommandRequest request) {
        new TCFRunnable(this.model, (IRequest)request){

            @Override
            public void run() {
                Object[] elements = request.getElements();
                if (elements.length != 1 || !(elements[0] instanceof TCFNodeStackFrame)) {
                    request.setStatus(Status.CANCEL_STATUS);
                    this.done();
                    return;
                }
                TCFNodeStackFrame frame_node = (TCFNodeStackFrame)elements[0];
                TCFNodeExecContext exe_node = (TCFNodeExecContext)frame_node.getParent();
                if (!exe_node.getStackTrace().validate(this)) {
                    return;
                }
                int frameNo = frame_node.getFrameNo();
                if (frameNo < 1) {
                    request.setStatus(Status.CANCEL_STATUS);
                    this.done();
                    return;
                }
                TCFDataCache<IRunControl.RunControlContext> ctx_cache = exe_node.getRunContext();
                if (!ctx_cache.validate((Runnable)this)) {
                    return;
                }
                TCFDataCache<TCFContextState> state_cache = exe_node.getMinState();
                if (!state_cache.validate((Runnable)this)) {
                    return;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                if (state_data == null || !state_data.is_suspended) {
                    request.setStatus(Status.CANCEL_STATUS);
                    this.done();
                    return;
                }
                Map stack = (Map)exe_node.getStackTrace().getData();
                for (TCFNode node : stack.values()) {
                    TCFNodeStackFrame frame_to_step_out = (TCFNodeStackFrame)node;
                    if (frame_to_step_out.getFrameNo() != frameNo - 1) continue;
                    new ActionStepOut(exe_node, false, frame_to_step_out, request, new Runnable(){

                        @Override
                        public void run() {
                            request.done();
                        }
                    });
                    return;
                }
                request.setStatus(Status.CANCEL_STATUS);
                this.done();
            }
        };
        return false;
    }
}

