/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.tunneling;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.php.internal.server.core.Activator;
import org.eclipse.php.internal.server.core.tunneling.Messages;

public class SSHTunnelSession {
    private static final int DEFAULT_TIMEOUT = 45000;
    private static Hashtable<String, SSHTunnelSession> pool = new Hashtable();
    private Session session;

    public static SSHTunnelSession getSession(String username, String password, String hostname, int port, IProgressMonitor monitor) throws JSchException {
        String key = SSHTunnelSession.getPoolKey(username, hostname, port);
        try {
            SSHTunnelSession jschSession = pool.get(key);
            if (jschSession != null && !jschSession.getSession().isConnected()) {
                pool.remove(key);
                jschSession = null;
            }
            if (jschSession == null) {
                IJSchService service = SSHTunnelSession.getJSchService();
                IJSchLocation jlocation = service.getLocation(username, hostname, port);
                Session session = null;
                session = SSHTunnelSession.createSession(service, jlocation, password, monitor);
                if (session == null) {
                    throw new JSchException(String.valueOf(Messages.SSHTunnelSession_0) + hostname);
                }
                if (session.getTimeout() != 45000) {
                    session.setTimeout(45000);
                }
                SSHTunnelSession schSession = new SSHTunnelSession(session);
                pool.put(key, schSession);
                return schSession;
            }
            return jschSession;
        }
        catch (JSchException e) {
            pool.remove(key);
            if (e.toString().indexOf("Auth cancel") != -1) {
                throw new OperationCanceledException();
            }
            throw e;
        }
    }

    private static Session createSession(IJSchService service, IJSchLocation location, String password, IProgressMonitor monitor) throws JSchException {
        Session session = service.createSession(location, null);
        session.setTimeout(45000);
        if (password != null) {
            session.setPassword(password);
        }
        service.connect(session, 45000, monitor);
        return session;
    }

    private static IJSchService getJSchService() {
        return Activator.getDefault().getJSchService();
    }

    private static String getPoolKey(String username, String hostname, int port) {
        return String.valueOf(username) + "@" + hostname + ":" + port;
    }

    public static void shutdown() {
        if (SSHTunnelSession.getJSch() != null && pool.size() > 0) {
            Enumeration<SSHTunnelSession> e = pool.elements();
            while (e.hasMoreElements()) {
                SSHTunnelSession session = e.nextElement();
                try {
                    session.getSession().disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pool.clear();
        }
    }

    public static JSch getJSch() {
        return SSHTunnelSession.getJSchService().getJSch();
    }

    private SSHTunnelSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void dispose() {
        pool.remove(SSHTunnelSession.getPoolKey(this.session.getUserName(), this.session.getHost(), this.session.getPort()));
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
    }
}

