// DO NOT EDIT
// Generated by JFlex 1.9.1 http://jflex.de/
// source: documentor_compiler_ast_scanner.flex

/*******************************************************************************
 * Copyright (c) 2006, 2015, 2018 Zend Corporation and IBM Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import org.eclipse.php.internal.core.Logger;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag.TagKind;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;

//@SuppressWarnings({"unused", "nls"})


@SuppressWarnings("fallthrough")
public class DocumentorLexer implements IDocumentorLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;
  public static final int ST_IN_FIRST_LINE = 2;
  public static final int ST_IN_SHORT_DESC = 4;
  public static final int ST_IN_LONG_DESC = 6;
  public static final int ST_IN_TAGS = 8;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8, 9
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\327\u0100\10\u0200\u1020\u0100";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\1\11\0"+
    "\1\4\2\0\1\5\1\6\1\7\20\0\1\10\32\5"+
    "\6\0\32\5\1\11\1\0\1\12\u0182\0\u0100\13";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[768];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\1\0\1\1\1\0\1\1\1\2\1\3"+
    "\1\2\1\3\1\2\2\4\3\2\2\5\4\2\2\6"+
    "\1\2\2\1\2\2\2\1\2\2\4\0\1\7\3\10"+
    "\1\0\2\1\2\0\1\1\1\11\1\12\3\0\1\13"+
    "\1\1\2\0\1\14\2\0\1\1\1\15\1\0\1\16"+
    "\1\17\2\0\2\20\2\0\1\21\1\22\1\23\2\0"+
    "\1\24";

  private static int [] zzUnpackAction() {
    int [] result = new int[80];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\14\0\30\0\44\0\60\0\74\0\110\0\124"+
    "\0\140\0\154\0\170\0\170\0\204\0\220\0\234\0\170"+
    "\0\250\0\264\0\300\0\314\0\170\0\330\0\344\0\360"+
    "\0\374\0\u0108\0\170\0\u0114\0\u0120\0\u012c\0\u0138\0\u0144"+
    "\0\u0150\0\u015c\0\u0168\0\u0174\0\u0180\0\u018c\0\u0198\0\234"+
    "\0\264\0\170\0\u01a4\0\170\0\u01b0\0\300\0\314\0\344"+
    "\0\360\0\374\0\u01bc\0\170\0\360\0\u01c8\0\u0108\0\u0120"+
    "\0\170\0\u01d4\0\u0144\0\u0150\0\170\0\u0174\0\u0180\0\u01e0"+
    "\0\u0174\0\u01ec\0\u01f8\0\u0204\0\u0210\0\u021c\0\170\0\u0228"+
    "\0\u0234\0\u0240\0\170\0\170\0\u0234\0\u024c\0\u0258\0\170";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[80];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\13\13\1\14\7\13\1\15\3\13\24\14\1\16\4\14"+
    "\1\13\1\17\1\20\1\21\1\22\1\13\1\23\4\13"+
    "\1\14\1\13\1\24\1\25\1\26\1\27\1\13\1\23"+
    "\1\13\1\30\1\31\1\13\1\14\1\13\1\32\1\33"+
    "\1\34\1\35\6\13\1\14\1\13\1\36\1\33\1\34"+
    "\1\37\3\13\1\30\1\31\1\13\1\14\1\13\1\40"+
    "\1\33\1\34\1\41\6\13\1\14\1\13\1\42\1\33"+
    "\1\34\1\43\3\13\1\44\1\45\1\13\1\14\20\0"+
    "\1\46\13\0\1\47\10\0\1\50\2\0\1\51\11\0"+
    "\1\20\20\0\1\52\5\0\1\53\1\54\1\55\2\0"+
    "\1\56\6\0\1\57\1\25\1\26\1\60\3\0\1\61"+
    "\1\62\4\0\1\25\12\0\1\63\1\25\1\26\3\0"+
    "\1\64\1\61\1\62\2\0\1\65\4\0\7\65\10\0"+
    "\1\66\4\0\1\67\2\0\1\70\11\0\1\33\20\0"+
    "\1\71\5\0\1\36\2\0\1\37\3\0\1\61\1\62"+
    "\3\0\1\72\5\0\1\71\1\61\1\62\3\0\1\73"+
    "\2\0\1\74\16\0\1\75\5\0\1\42\2\0\1\43"+
    "\3\0\1\76\1\77\3\0\1\100\5\0\1\75\1\76"+
    "\1\77\2\0\1\101\4\0\7\101\10\0\1\102\7\0"+
    "\1\103\13\0\1\104\10\0\1\53\1\54\1\55\12\0"+
    "\1\54\12\0\1\63\1\25\1\26\4\0\1\61\1\62"+
    "\7\0\1\105\7\0\1\72\6\0\1\61\1\62\3\0"+
    "\1\100\6\0\1\76\1\77\7\0\1\106\7\0\1\103"+
    "\1\107\1\110\11\0\1\104\6\0\1\111\1\112\7\0"+
    "\1\105\4\0\1\113\6\0\1\106\4\0\1\114\3\0"+
    "\1\107\11\0\1\115\4\0\7\115\10\0\1\116\10\0"+
    "\1\117\13\0\1\117\4\0\1\120\1\0";

  private static int [] zzUnpacktrans() {
    int [] result = new int[612];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\1\1\0\1\1\1\0\1\1\2\11\3\1"+
    "\1\11\4\1\1\11\5\1\1\11\12\1\4\0\1\11"+
    "\1\1\1\11\1\1\1\0\2\1\2\0\1\1\1\11"+
    "\1\1\3\0\1\11\1\1\2\0\1\11\2\0\2\1"+
    "\1\0\2\1\2\0\1\11\1\1\2\0\2\11\1\1"+
    "\2\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[80];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  private boolean zzEOFDone;

  /* user code: */
	private String shortDesc;
	private String longDesc;
	private ArrayList<PHPDocTag> tagList;
	private TagKind currTagKind;
	private int tagPosition;
	private String matchedTagName;
	private Scalar indentedTagName;
	private StringBuilder sBuffer;
	private int numOfLines;
	private List<Scalar> textList;

	@Override
	public PHPDocBlock parse() {
		oldString = null;
		shortDesc = "";
		longDesc = "";
		tagList = new ArrayList<>();
		currTagKind = null;
		tagPosition = 0;
		matchedTagName = "";
		indentedTagName = null;
		sBuffer = new StringBuilder();
		numOfLines = 1;
		textList = new ArrayList<>();

		useOldString = true;
		int start = zzStartRead - _zzPushbackPos;

		// start parsing
		try {
			next_token();
		} catch (IOException e) {
			Logger.logException(e);
		}
		if (!tagList.isEmpty() && !textList.isEmpty()) {
			Scalar lastText = textList.get(textList.size() - 1);
			PHPDocTag lastTag = tagList.get(tagList.size() - 1);
			if (lastText.sourceEnd() >= lastTag.sourceEnd()) {
				textList.remove(textList.size() - 1);
				lastTag.getTexts().add(lastText);
				// replace last tag by a new one with updated source range and internal references
				tagList.set(tagList.size() - 1, new PHPDocTag(lastTag.sourceStart(), lastText.sourceEnd(),
						lastTag.getTagKind(), lastTag.getMatchedTag(), lastTag.getValue(), lastTag.getTagText(), lastTag.getTexts()));
			}
		}

		PHPDocTag[] tags = new PHPDocTag[tagList.size()];
		tagList.toArray(tags);

		PHPDocBlock rv = new PHPDocBlock(start, zzMarkedPos - _zzPushbackPos,
				shortDesc, longDesc, tags, textList);

		return rv;
	}

	private void startTagsState(TagKind firstState, int position, String tagName, Scalar indentedTag) {
		updateStartPos();
		handleDesc();
		currTagKind = firstState;
		tagPosition = position - _zzPushbackPos;
		matchedTagName = tagName;
		indentedTagName = indentedTag;
		sBuffer = new StringBuilder();
		yybegin(ST_IN_TAGS);
	}

	private int findTagPosition() {
		for (int i = zzStartRead; i < zzMarkedPos; i++) {
			if (zzBuffer[i] == '@' || zzBuffer[i] == '{') {
				return i;
			}
		}
		return -1;
	}

	// should only be used with ^{LINESTART}... rules:
	private int findIndentedLineStartTagPosition() {
		// we want to keep all blanks after
		// '*', see also token LINESTART
		for (int i = zzStartRead; i < zzMarkedPos; i++) {
			if (zzBuffer[i] == '*') {
				return i + 1;
			}
			if (zzBuffer[i] == '@' || zzBuffer[i] == '{') {
				break;
			}
		}
		return zzStartRead;
	}

	private void setNewTag(TagKind newTag, int position, String tagName, Scalar indentedTag) {
		updateStartPos();
		setTagValue();

		sBuffer = new StringBuilder();
		currTagKind = newTag;
		tagPosition = position - _zzPushbackPos;
		matchedTagName = tagName;
		indentedTagName = indentedTag;
	}

	private void setTagValue() {
		String value = sBuffer.toString();
		// special case for backward compatibility
		if (currTagKind == TagKind.DESC) {
			shortDesc = shortDesc + value;
			shortDesc = shortDesc.trim();
			return;
		}

		PHPDocTag basicPHPDocTag = new PHPDocTag(tagPosition, zzStartRead - _zzPushbackPos, currTagKind, matchedTagName,
				value, indentedTagName, getTexts(tagPosition, zzStartRead - _zzPushbackPos, true));
		tagList.add(basicPHPDocTag);
	}

	@NonNull
	private List<Scalar> getTexts(int start, int end, boolean remove) {
		List<Scalar> result = new ArrayList<>();
		for (Iterator<Scalar> iterator = textList.iterator(); iterator.hasNext();) {
			Scalar scalar = iterator.next();
			if (scalar.sourceStart() >= start && scalar.sourceEnd() <= end) {
				result.add(scalar);
				if (remove) {
					iterator.remove();
				}
			}
		}
		// Scalar[] texts = new Scalar[result.size()];
		// result.toArray(texts);
		return result;
	}

	private void appendText() {
		if (oldString != null) {
			sBuffer.append(oldString);
		}
		String sb = new String(zzBuffer, startPos, zzMarkedPos - startPos);
		if (oldString != null) {
			addText(oldString, sb);
		} else {
			addText(sb);
		}
		sBuffer.append(sb);
		updateStartPos();
	}

	private void addText(String oldString, String string) {
		textList.add(new Scalar(startPos - _zzPushbackPos - oldString.length(), startPos - _zzPushbackPos + string.length(), oldString + string,
				Scalar.TYPE_STRING));
	}

	private void addText(String string) {
		textList.add(new Scalar(startPos - _zzPushbackPos, startPos - _zzPushbackPos + string.length(), string,
				Scalar.TYPE_STRING));
	}

	private void handleDesc() {
		if (zzLexicalState == ST_IN_SHORT_DESC || zzLexicalState == ST_IN_FIRST_LINE) {
			shortDesc = sBuffer.toString().trim();
		} else {
			longDesc = sBuffer.toString().trim();
		}

		sBuffer = new StringBuilder();
	}

	private void startLongDescState(boolean withNewLine) {
		handleDesc();
		updateStartPos();
		if (!withNewLine) {
			addText("");
		}
		yybegin(ST_IN_LONG_DESC);
	}

	private void handleNewLine() {
		appendText();
		if (numOfLines == 4) {
			int firstLineEnd = sBuffer.indexOf("\n", 1);
			if (firstLineEnd == -1) {
				firstLineEnd = sBuffer.indexOf("\r", 1);
			}
			shortDesc = sBuffer.substring(0, firstLineEnd);
			shortDesc = shortDesc.trim();
			sBuffer.delete(0, firstLineEnd);
			yybegin(ST_IN_LONG_DESC);
		} else {
			numOfLines++;
		}
	}
	private void appendLastText() {
		String sb = new String(zzBuffer, startPos, zzMarkedPos - startPos - 2);
		// ignore last text if it only contains white spaces
		if (StringUtils.isNotBlank(sb)) {
			addText(sb);
			sBuffer.append(sb);
		}
		updateStartPos();
	}

	int maxNumberofLines = 4;

	private void handleDocEnd_shortDesc() {
		appendLastText();
		if (numOfLines == maxNumberofLines) {
			int firstLineEnd = sBuffer.indexOf("\n", 1);
			if (firstLineEnd == -1) {
				firstLineEnd = sBuffer.indexOf("\r", 1);
			}
			shortDesc = sBuffer.substring(0, firstLineEnd);
			shortDesc = shortDesc.trim();
			sBuffer.delete(0, firstLineEnd);
			longDesc = sBuffer.toString().trim();
		} else {
			shortDesc = sBuffer.toString().trim();
		}
	}

	private void handleDocEnd_longDesc() {
		appendLastText();
		longDesc = sBuffer.toString().trim();
	}

	private void handleDocEnd_inTags() {
		appendLastText();
		setTagValue();
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to given parameters. Be
	 * careful, method {@link #next_token()} also caches those properties using
	 * internal variables (zzCurrentPosL, zzMarkedPosL, zzBufferL, zzEndReadL)
	 * that should be accordingly resetted by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 *
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	@Override
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		// (re)set all properties like in yyreset(java.io.Reader reader)

		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		// XXX: never used
		this.yychar = 0;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		oldString = null;

		// NB: zzAtBOL and zzLexicalState won't be set using (directly) the
		// array "parameters", we always restart this scanner with the YYINITIAL
		// state
		this.zzAtBOL = this.zzAtEOF ? false : true;
		this.zzLexicalState = YYINITIAL;
	}

	@Override
	public int[] getParameters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
			zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
			zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	@Override
	public char[] getBuffer() {
		return zzBuffer;
	}



  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private boolean useOldString = false;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DocumentorLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    if (useOldString) {
      String saveOldString = oldString;
      oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
      if (saveOldString != null) {
        oldString = saveOldString + oldString;
      }
    }

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    String saveOldString = oldString;
    oldString = null;

    /* first: make room (if you can) */
    if (zzRefill()) {
      oldString = saveOldString;
      return YYEOF;
    }

    oldString = saveOldString;

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      _zzPushbackPos = 0;
      startPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      oldString = null;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
    
  yyclose();    }
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public int next_token() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':  // fall through
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
        return YYEOF;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { updateStartPos(findIndentedLineStartTagPosition());
            }
          // fall through
          case 21: break;
          case 2:
            { 
            }
          // fall through
          case 22: break;
          case 3:
            { System.out.print(yytext());
            }
          // fall through
          case 23: break;
          case 4:
            { handleNewLine();
            }
          // fall through
          case 24: break;
          case 5:
            { startLongDescState(false);
            }
          // fall through
          case 25: break;
          case 6:
            { appendText();
            }
          // fall through
          case 26: break;
          case 7:
            { maxNumberofLines = 4;
	handleDocEnd_shortDesc();
	return -1;
            }
          // fall through
          case 27: break;
          case 8:
            { appendText();
	startLongDescState(true);
            }
          // fall through
          case 28: break;
          case 9:
            { maxNumberofLines = 5;
	handleDocEnd_shortDesc();
	return -1;
            }
          // fall through
          case 29: break;
          case 10:
            { int position = findTagPosition();
	// NB: no need to check if "value" contains the closing "*/" PHPDoc string
	// since character '*' is not allowed in {TAG_NAME_CHARS}
	String value = new String(zzBuffer, position, zzMarkedPos - position);

	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = findIndentedLineStartTagPosition();
	String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
	Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
			indentedText, Scalar.TYPE_STRING);
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		startTagsState(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		startTagsState(TagKind.UNKNOWN, position, value, indentedTag);
	}
            }
          // fall through
          case 30: break;
          case 11:
            { handleDocEnd_longDesc();return -1;
            }
          // fall through
          case 31: break;
          case 12:
            { handleDocEnd_inTags();return -1;
            }
          // fall through
          case 32: break;
          case 13:
            { int position = findTagPosition();
	// NB: no need to check if "value" contains the closing "*/" PHPDoc string
	// since character '*' is not allowed in {TAG_NAME_CHARS}
	String value = new String(zzBuffer, position, zzMarkedPos - position);

	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = findIndentedLineStartTagPosition();
	String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
	Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
			indentedText, Scalar.TYPE_STRING);
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		setNewTag(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		setNewTag(TagKind.UNKNOWN, position, value, indentedTag);
	}
            }
          // fall through
          case 33: break;
          case 14:
            { yypushback(yylength());
		updateStartPos();
		// https://bugs.eclipse.org/bugs/show_bug.cgi?id=474332
		// look for @tags on the first line of this PHPDoc block
		yybegin(ST_IN_FIRST_LINE);
            }
          // fall through
          case 34: break;
          case 15:
            { // https://bugs.eclipse.org/bugs/show_bug.cgi?id=474332
	// no @tags were found on first line, continue normal
	// processing...
	updateStartPos(zzStartRead + 3); // skip "/**"
	yybegin(ST_IN_SHORT_DESC);
            }
          // fall through
          case 35: break;
          case 16:
            { updateStartPos();
		yybegin(ST_IN_SHORT_DESC);
            }
          // fall through
          case 36: break;
          case 17:
            { int position = findTagPosition();
	String value = new String(zzBuffer, position, zzMarkedPos - position);
	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = findIndentedLineStartTagPosition();
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
		Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
				indentedText, Scalar.TYPE_STRING);
		startTagsState(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		updateStartPos(indentedTagPosition);
		// no need to call yypushback(zzMarkedPos - indentedTagPosition) here...
	}
            }
          // fall through
          case 37: break;
          case 18:
            { int position = findTagPosition();
	String value = new String(zzBuffer, position, zzMarkedPos - position);
	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = findIndentedLineStartTagPosition();
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
		Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
				indentedText, Scalar.TYPE_STRING);
		setNewTag(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		updateStartPos(indentedTagPosition);
		// no need to call yypushback(zzMarkedPos - indentedTagPosition) here...
	}
            }
          // fall through
          case 38: break;
          case 19:
            { int position = findTagPosition();
	// NB: no need to check if "value" contains the closing "*/" PHPDoc string
	// since character '*' is not allowed in {TAG_NAME_CHARS}
	String value = new String(zzBuffer, position, zzMarkedPos - position);

	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = zzStartRead + 3; // skip "/**"
	String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
	Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
			indentedText, Scalar.TYPE_STRING);
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		startTagsState(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		startTagsState(TagKind.UNKNOWN, position, value, indentedTag);
	}
            }
          // fall through
          case 39: break;
          case 20:
            { int position = findTagPosition();
	String value = new String(zzBuffer, position, zzMarkedPos - position);
	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = zzStartRead + 3; // skip "/**"
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
		Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
				indentedText, Scalar.TYPE_STRING);
		startTagsState(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		// https://bugs.eclipse.org/bugs/show_bug.cgi?id=474332
		// no @tags were found on first line, continue normal
		// processing...
		updateStartPos(indentedTagPosition);
		// no need to call yypushback(zzMarkedPos - indentedTagPosition) here...
		yybegin(ST_IN_SHORT_DESC);
	}
            }
          // fall through
          case 40: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String[] argv) {
    if (argv.length == 0) {
      System.out.println("Usage : java DocumentorLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          // Side-effect: is encodingName valid?
          java.nio.charset.Charset.forName(encodingName);
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        DocumentorLexer scanner = null;
        java.io.FileInputStream stream = null;
        java.io.Reader reader = null;
        try {
          stream = new java.io.FileInputStream(argv[i]);
          reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new DocumentorLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
        finally {
          if (reader != null) {
            try {
              reader.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
          if (stream != null) {
            try {
              stream.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
        }
      }
    }
  }


}
