/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;

public class JavaActiveSearchResultUpdater
implements IElementChangedListener,
IQueryListener {
    private final JavaSearchResult fResult;
    private static final int REMOVED_FLAGS = 1185;

    public JavaActiveSearchResultUpdater(JavaSearchResult result) {
        this.fResult = result;
        NewSearchUI.addQueryListener((IQueryListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        HashSet removedElements = new HashSet();
        HashSet potentiallyRemovedElements = new HashSet();
        this.collectRemoved(potentiallyRemovedElements, removedElements, delta);
        if (removedElements.size() > 0) {
            this.handleRemoved(removedElements);
        }
        if (potentiallyRemovedElements.size() > 0) {
            this.handleRemoved(potentiallyRemovedElements);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleRemoved(Set removedElements) {
        Object[] elements;
        Object[] objectArray = elements = this.fResult.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.isContainedInRemoved(removedElements, element)) {
                Object object = element;
                if (object instanceof IJavaElement) {
                    void je;
                    IJavaElement cfr_ignored_0 = (IJavaElement)object;
                    IJavaElement cfr_ignored_1 = (IJavaElement)object;
                    if (!je.exists()) {
                        Match[] matches;
                        Match[] matchArray = matches = this.fResult.getMatches(element);
                        int n3 = matches.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Match matche = matchArray[n4];
                            this.fResult.removeMatch(matche);
                            ++n4;
                        }
                    }
                } else {
                    Object object2 = element;
                    if (object2 instanceof IResource) {
                        void resource;
                        Match[] cfr_ignored_2 = (Match[])object2;
                        IResource cfr_ignored_3 = (IResource)object2;
                        if (!resource.exists()) {
                            Match[] matches;
                            Match[] matchArray = matches = this.fResult.getMatches(element);
                            int n5 = matches.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Match matche = matchArray[n6];
                                this.fResult.removeMatch(matche);
                                ++n6;
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isContainedInRemoved(Set removedElements, Object object) {
        Iterator elements = removedElements.iterator();
        while (elements.hasNext()) {
            if (!this.isParentOf(elements.next(), object)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentOf(Object ancestor, Object descendant) {
        while (descendant != null && !ancestor.equals(descendant)) {
            descendant = this.getParent(descendant);
        }
        return descendant != null;
    }

    private Object getParent(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getParent();
        }
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        return null;
    }

    private void collectRemoved(Set potentiallyRemovedSet, Set removedElements, IJavaElementDelta delta) {
        int n;
        if (delta.getKind() == 2) {
            removedElements.add(delta.getElement());
        } else if (delta.getKind() == 4) {
            int flags = delta.getFlags();
            if ((flags & 0x4A1) != 0) {
                potentiallyRemovedSet.add(delta.getElement());
            } else {
                IJavaElementDelta[] childDeltas;
                IJavaElementDelta[] iJavaElementDeltaArray = childDeltas = delta.getAffectedChildren();
                int n2 = childDeltas.length;
                n = 0;
                while (n < n2) {
                    IJavaElementDelta childDelta = iJavaElementDeltaArray[n];
                    this.collectRemoved(potentiallyRemovedSet, removedElements, childDelta);
                    ++n;
                }
            }
        }
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            IResourceDelta[] iResourceDeltaArray = resourceDeltas;
            n = resourceDeltas.length;
            int n3 = 0;
            while (n3 < n) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n3];
                this.collectRemovals(removedElements, resourceDelta);
                ++n3;
            }
        }
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
        if (this.fResult.equals(query.getSearchResult())) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    private void collectRemovals(Set removals, IResourceDelta delta) {
        if (delta.getKind() == 2) {
            removals.add(delta.getResource());
        } else {
            IResourceDelta[] children;
            IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta element = iResourceDeltaArray[n2];
                this.collectRemovals(removals, element);
                ++n2;
            }
        }
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }
}

