/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.junit;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;

public class InteractionContextTestUtil {
    public static void setupTestConfiguration(Set<IType> contextTestCases, ILaunchConfiguration configuration, IProgressMonitor pm) throws CoreException {
        String testKindId = "org.eclipse.jdt.junit.loader.junit3";
        IJavaProject javaProject = null;
        for (IType type : contextTestCases) {
            IProjectNature nature = type.getJavaProject().getProject().getNature("org.eclipse.pde.PluginNature");
            if (nature == null) continue;
            javaProject = type.getJavaProject();
        }
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        if (javaProject != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
        }
        if (contextTestCases.size() > 0) {
            testKindId = TestKindRegistry.getContainerTestKindId((IJavaElement)((IJavaElement)contextTestCases.iterator().next()));
            workingCopy.setAttribute("org.eclipse.jdt.junit.TEST_KIND", testKindId);
        }
        workingCopy.doSave();
    }

    /*
     * WARNING - void declaration
     */
    public static Set<IType> getTestCasesInContext() {
        HashSet<IType> testTypes = new HashSet<IType>();
        List interesting = ContextCore.getContextManager().getActiveContext().getInteresting();
        AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((String)"java");
        try {
            for (IInteractionElement element : interesting) {
                if (!element.getContentType().equals("java")) continue;
                Object javaElement = bridge.getObjectForHandle(element.getHandleIdentifier());
                Object object = javaElement;
                if (object instanceof IType) {
                    void type;
                    IType cfr_ignored_0 = (IType)object;
                    IType cfr_ignored_1 = (IType)object;
                    if (InteractionContextTestUtil.isTestType((IType)type)) {
                        testTypes.add((IType)type);
                    }
                }
                for (IInteractionRelation relation : element.getRelations()) {
                    void testMethod;
                    IInteractionElement target;
                    Object targetObject;
                    Object object2;
                    if (!relation.getRelationshipHandle().equals("org.eclipse.mylyn.java.relation.junitreferences") || !((object2 = (targetObject = bridge.getObjectForHandle((target = relation.getTarget()).getHandleIdentifier()))) instanceof IMethod)) continue;
                    IMethod cfr_ignored_2 = (IMethod)object2;
                    IMethod cfr_ignored_3 = (IMethod)object2;
                    if (!InteractionContextTestUtil.isTestType((IType)testMethod.getParent())) continue;
                    testTypes.add((IType)testMethod.getParent());
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not add all test types", (Throwable)e));
        }
        return testTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTestType(IType type) {
        try {
            if (Flags.isAbstract((int)type.getFlags())) {
                return false;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
        try {
            IType[] supertypes;
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = supertypes = hierarchy.getAllSuperclasses(type);
            int n = supertypes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType supertype = iTypeArray[n2];
                if (supertype.getFullyQualifiedName().equals("junit.framework.TestCase")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }
}

