/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql.lexer;

import java.io.IOException;
import java.util.List;
import lpg.lpgjavaruntime.IntSegmentedTuple;
import lpg.lpgjavaruntime.LexParser;
import lpg.lpgjavaruntime.LpgLexStream;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.Token;
import org.eclipse.datatools.sqltools.parsers.sql.lexer.SQLCharacterKindMap;

public abstract class AbstractSQLLexer
extends LpgLexStream {
    protected ParseTable prs;
    protected LexParser lexParser;
    protected static boolean printTokens = false;
    protected static final int ECLIPSE_TAB_VALUE = 4;
    protected static final SQLCharacterKindMap DEFAULT_CHAR_KIND_MAP = new SQLCharacterKindMap();
    protected SQLCharacterKindMap charKindMap = DEFAULT_CHAR_KIND_MAP;
    protected static final char TOKEN_EOF = '\uffff';
    protected List commentTokens = null;

    public abstract void lexer(PrsStream var1);

    protected final void makeComment(int kind) {
        int startOffset = this.lexParser.getToken(1);
        int endOffset = this.lexParser.getLastToken();
        this.commentTokens.add(new Token(this.getPrsStream(), startOffset, endOffset, kind));
        if (printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    protected final void makeToken(int kind) {
        int startOffset = this.lexParser.getToken(1);
        int endOffset = this.lexParser.getLastToken();
        this.getPrsStream().makeToken(startOffset, endOffset, kind);
        if (printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    protected final int getCurrentTokenLength() {
        int startOffset = this.lexParser.getToken(1);
        int endOffset = this.lexParser.getLastToken();
        return endOffset - startOffset;
    }

    protected final void skipToken() {
        if (printTokens) {
            this.printValue(this.lexParser.getToken(1), this.lexParser.getLastToken());
        }
    }

    public List getCommentTokens() {
        return this.commentTokens;
    }

    protected final void printValue(int startOffset, int endOffset) {
        String s = new String(this.getInputChars(), startOffset, endOffset - startOffset + 1);
        System.out.print(s);
    }

    @Override
    public void reportError(int left_loc, int right_loc) {
        this.makeToken(left_loc, right_loc, 0);
    }

    @Override
    public int getKind(int arg0) {
        return 0;
    }

    public AbstractSQLLexer() {
    }

    public AbstractSQLLexer(char[] arg0, String arg1, int arg2) {
        super(arg0, arg1, arg2);
    }

    public AbstractSQLLexer(char[] arg0, String arg1) {
        super(arg0, arg1);
    }

    public AbstractSQLLexer(int arg0) {
        super(arg0);
    }

    public AbstractSQLLexer(IntSegmentedTuple arg0, char[] arg1, String arg2, int arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    public AbstractSQLLexer(IntSegmentedTuple arg0, char[] arg1, String arg2) {
        super(arg0, arg1, arg2);
    }

    public AbstractSQLLexer(String arg0, int arg1) throws IOException {
        super(arg0, arg1);
    }

    public AbstractSQLLexer(String arg0) throws IOException {
        super(arg0);
    }
}

