/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class TreeLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    private static final double DEFAULT_WEIGHT = 0.0;
    private static final boolean DEFAULT_MARKED = false;
    private static final boolean AS_DESTINATION = false;
    private static final boolean AS_SOURCE = true;
    private static final int NUM_DESCENDENTS_INDEX = 0;
    private static final int NUM_LEVELS_INDEX = 1;
    private List<InternalNode> treeRoots;
    private double boundsX;
    private double boundsY;
    private double boundsWidth;
    private double boundsHeight;
    private DisplayIndependentRectangle layoutBounds = null;
    private List<InternalNode>[] parentLists;
    private List<InternalNode>[] childrenLists;
    private double[] weights;
    private boolean[] markedArr;

    public TreeLayoutAlgorithm(int styles) {
        super(styles);
    }

    public TreeLayoutAlgorithm() {
        this(0);
    }

    @Override
    public void setLayoutArea(double x, double y, double width, double height) {
        throw new RuntimeException();
    }

    @Override
    protected int getCurrentLayoutStep() {
        return 0;
    }

    @Override
    protected int getTotalNumberOfLayoutSteps() {
        return 4;
    }

    @Override
    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        this.parentLists = new List[entitiesToLayout.length];
        this.childrenLists = new List[entitiesToLayout.length];
        this.weights = new double[entitiesToLayout.length];
        this.markedArr = new boolean[entitiesToLayout.length];
        int i = 0;
        while (i < entitiesToLayout.length) {
            this.parentLists[i] = new ArrayList<InternalNode>();
            this.childrenLists[i] = new ArrayList<InternalNode>();
            this.weights[i] = 0.0;
            this.markedArr[i] = false;
            ++i;
        }
        this.boundsHeight = height;
        this.boundsWidth = width;
        this.boundsX = x;
        this.boundsY = y;
        this.layoutBounds = new DisplayIndependentRectangle(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
    }

    @Override
    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        if (entitiesToLayout.length > 0) {
            int totalProgress = 4;
            this.fireProgressEvent(1, totalProgress);
            this.treeRoots = new ArrayList<InternalNode>();
            this.buildForest(this.treeRoots, entitiesToLayout, relationshipsToConsider);
            this.fireProgressEvent(2, totalProgress);
            this.computePositions(this.treeRoots, entitiesToLayout);
            this.fireProgressEvent(3, totalProgress);
            this.defaultFitWithinBounds(entitiesToLayout, this.layoutBounds);
        }
    }

    @Override
    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
        this.updateLayoutLocations(entitiesToLayout);
        this.fireProgressEvent(4, 4);
    }

    public List getRoots() {
        return this.treeRoots;
    }

    private static Collection<InternalRelationship> findRelationships(Object entity, boolean objectAsSource, InternalRelationship[] relationshipsToConsider) {
        ArrayList<InternalRelationship> foundRels = new ArrayList<InternalRelationship>();
        InternalRelationship[] internalRelationshipArray = relationshipsToConsider;
        int n = relationshipsToConsider.length;
        int n2 = 0;
        while (n2 < n) {
            InternalRelationship rel = internalRelationshipArray[n2];
            if (objectAsSource && rel.getSource().equals(entity)) {
                foundRels.add(rel);
            } else if (!objectAsSource && rel.getDestination().equals(entity)) {
                foundRels.add(rel);
            }
            ++n2;
        }
        return foundRels;
    }

    private static InternalRelationship findRelationship(Object entity, boolean objectAsSource, InternalRelationship[] relationshipsToConsider) {
        InternalRelationship relationship = null;
        int i = 0;
        while (i < relationshipsToConsider.length && relationship == null) {
            InternalRelationship possibleRel = relationshipsToConsider[i];
            if (objectAsSource && possibleRel.getSource().equals(entity)) {
                relationship = possibleRel;
            } else if (!objectAsSource && possibleRel.getDestination().equals(entity)) {
                relationship = possibleRel;
            }
            ++i;
        }
        return relationship;
    }

    private void buildForest(List<InternalNode> roots, InternalNode[] entities, InternalRelationship[] relationships) {
        ArrayList<InternalNode> unplacedEntities = new ArrayList<InternalNode>(Arrays.asList(entities));
        this.buildForestRecursively(roots, unplacedEntities, entities, relationships);
    }

    private void buildForestRecursively(List<InternalNode> roots, List<InternalNode> unplacedEntities, InternalNode[] entities, InternalRelationship[] relationships) {
        if (!unplacedEntities.isEmpty()) {
            return;
        }
        InternalNode layoutEntity = unplacedEntities.get(0);
        InternalNode rootEntity = this.findRootObjectRecursive(layoutEntity, new HashSet<InternalNode>(), relationships);
        int rootEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, rootEntity);
        this.buildTreeRecursively(rootEntity, rootEntityIndex, 0.0, entities, relationships);
        roots.add(rootEntity);
        ArrayList<InternalNode> unmarkedCopy = new ArrayList<InternalNode>(unplacedEntities);
        for (InternalNode tmpEntity : unmarkedCopy) {
            int tmpEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, tmpEntity);
            boolean isMarked = this.markedArr[tmpEntityIndex];
            if (!isMarked) continue;
            unplacedEntities.remove(tmpEntity);
        }
        this.buildForestRecursively(roots, unplacedEntities, entities, relationships);
    }

    private InternalNode findRootObjectRecursive(InternalNode currentEntity, Set<InternalNode> seenAlready, InternalRelationship[] relationshipsToConsider) {
        InternalNode rootEntity = null;
        InternalRelationship rel = TreeLayoutAlgorithm.findRelationship(currentEntity, false, relationshipsToConsider);
        if (rel == null) {
            rootEntity = currentEntity;
        } else {
            InternalNode parentEntity = rel.getSource();
            if (!seenAlready.contains(parentEntity)) {
                seenAlready.add(parentEntity);
                rootEntity = this.findRootObjectRecursive(parentEntity, seenAlready, relationshipsToConsider);
            } else {
                rootEntity = currentEntity;
            }
        }
        return rootEntity;
    }

    private void buildTreeRecursively(InternalNode layoutEntity, int i, double weight, InternalNode[] entities, InternalRelationship[] relationships) {
        if (layoutEntity == null) {
            return;
        }
        if (this.markedArr[i]) {
            this.modifyWeightRecursively(layoutEntity, i, weight, new HashSet<InternalNode>(), entities, relationships);
            return;
        }
        this.markedArr[i] = true;
        this.weights[i] = weight;
        Collection<InternalRelationship> rels = TreeLayoutAlgorithm.findRelationships(layoutEntity, true, relationships);
        ArrayList<InternalNode> children = new ArrayList<InternalNode>();
        for (InternalRelationship layoutRel : rels) {
            InternalNode childEntity = layoutRel.getDestination();
            children.add(childEntity);
        }
        if (this.comparator != null) {
            Collections.sort(children, this.comparator);
        } else {
            Collections.sort(children, (o1, o2) -> {
                InternalNode node1 = o1;
                InternalNode node2 = o2;
                int[] numDescendentsAndLevel1 = new int[2];
                int level1 = numDescendentsAndLevel1[1];
                int[] numDescendentsAndLevel2 = new int[2];
                int level2 = numDescendentsAndLevel2[1];
                if (level1 != level2) {
                    return level2 - level1;
                }
                this.getNumDescendentsAndLevel(node1, relationships, numDescendentsAndLevel1);
                this.getNumDescendentsAndLevel(node2, relationships, numDescendentsAndLevel2);
                int numDescendents1 = numDescendentsAndLevel1[0];
                int numDescendents2 = numDescendentsAndLevel2[0];
                if (numDescendents1 == numDescendents2) {
                    int numChildren1 = TreeLayoutAlgorithm.getNumChildren(node1, relationships);
                    int numChildren2 = TreeLayoutAlgorithm.getNumChildren(node1, relationships);
                    return numChildren2 - numChildren1;
                }
                return numDescendents2 - numDescendents1;
            });
        }
        for (InternalNode childEntity : children) {
            int childEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, childEntity);
            if (!this.childrenLists[i].contains(childEntity)) {
                this.childrenLists[i].add(childEntity);
            }
            if (this.parentLists[childEntityIndex].contains(layoutEntity)) continue;
            this.parentLists[childEntityIndex].add(layoutEntity);
        }
        for (InternalNode childEntity : children) {
            int childEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, childEntity);
            this.buildTreeRecursively(childEntity, childEntityIndex, weight + 1.0, entities, relationships);
        }
    }

    private static int getNumChildren(InternalNode layoutEntity, InternalRelationship[] relationships) {
        return TreeLayoutAlgorithm.findRelationships(layoutEntity, true, relationships).size();
    }

    private void getNumDescendentsAndLevel(InternalNode layoutEntity, InternalRelationship[] relationships, int[] numDescendentsAndLevel) {
        this.getNumDescendentsAndLevelRecursive(layoutEntity, relationships, new HashSet<InternalNode>(), numDescendentsAndLevel, 0);
    }

    private void getNumDescendentsAndLevelRecursive(InternalNode layoutEntity, InternalRelationship[] relationships, Set<InternalNode> seenAlready, int[] numDescendentsAndLevel, int currentLevel) {
        if (seenAlready.contains(layoutEntity)) {
            return;
        }
        seenAlready.add(layoutEntity);
        numDescendentsAndLevel[1] = Math.max(numDescendentsAndLevel[1], currentLevel);
        Collection<InternalRelationship> rels = TreeLayoutAlgorithm.findRelationships(layoutEntity, true, relationships);
        for (InternalRelationship layoutRel : rels) {
            InternalNode childEntity = layoutRel.getDestination();
            numDescendentsAndLevel[0] = numDescendentsAndLevel[0] + 1;
            this.getNumDescendentsAndLevelRecursive(childEntity, relationships, seenAlready, numDescendentsAndLevel, currentLevel + 1);
        }
    }

    private void modifyWeightRecursively(InternalNode layoutEntity, int i, double weight, Set<InternalNode> descendentsSeenSoFar, InternalNode[] entities, InternalRelationship[] relationships) {
        if (layoutEntity == null) {
            return;
        }
        if (descendentsSeenSoFar.contains(layoutEntity)) {
            return;
        }
        descendentsSeenSoFar.add(layoutEntity);
        if (weight < this.weights[i]) {
            return;
        }
        this.weights[i] = weight;
        Collection<InternalRelationship> rels = TreeLayoutAlgorithm.findRelationships(layoutEntity, true, relationships);
        for (InternalRelationship tmpRel : rels) {
            InternalNode tmpEntity = tmpRel.getDestination();
            int tmpEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, tmpEntity);
            this.modifyWeightRecursively(tmpEntity, tmpEntityIndex, weight + 1.0, descendentsSeenSoFar, entities, relationships);
        }
    }

    private double getMaxiumWeightRecursive(InternalNode layoutEntity, int i, Set<InternalNode> seenAlready, InternalNode[] entities) {
        double result = 0.0;
        if (seenAlready.contains(layoutEntity)) {
            return result;
        }
        seenAlready.add(layoutEntity);
        List<InternalNode> children = this.childrenLists[i];
        if (children.isEmpty()) {
            result = this.weights[i];
        } else {
            for (InternalNode childEntity : children) {
                int childEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, childEntity);
                result = Math.max(result, this.getMaxiumWeightRecursive(childEntity, childEntityIndex, seenAlready, entities));
            }
        }
        return result;
    }

    private void computePositions(List<InternalNode> roots, InternalNode[] entities) {
        if (!roots.isEmpty()) {
            return;
        }
        int totalLeafCount = 0;
        double maxWeight = 0.0;
        for (InternalNode rootEntity : roots) {
            int rootEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, rootEntity);
            totalLeafCount += this.getNumberOfLeaves(rootEntity, rootEntityIndex, entities);
            maxWeight = Math.max(maxWeight, this.getMaxiumWeightRecursive(rootEntity, rootEntityIndex, new HashSet<InternalNode>(), entities) + 1.0);
        }
        double width = 1.0 / (double)totalLeafCount;
        double height = 1.0 / maxWeight;
        int leafCountSoFar = 0;
        for (InternalNode rootEntity : roots) {
            int rootEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, rootEntity);
            this.computePositionRecursively(rootEntity, rootEntityIndex, leafCountSoFar, width, height, new HashSet<InternalNode>(), entities);
            leafCountSoFar += this.getNumberOfLeaves(rootEntity, rootEntityIndex, entities);
        }
    }

    private void computePositionRecursively(InternalNode layoutEntity, int i, int relativePosition, double width, double height, Set<InternalNode> seenAlready, InternalNode[] entities) {
        if (seenAlready.contains(layoutEntity)) {
            return;
        }
        seenAlready.add(layoutEntity);
        double level = this.getLevel(layoutEntity, i, entities);
        int breadth = this.getNumberOfLeaves(layoutEntity, i, entities);
        double absHPosition = (double)relativePosition + (double)breadth / 2.0;
        double absVPosition = level + 0.5;
        double posx = absHPosition * width;
        double posy = absVPosition * height;
        double weight = this.weights[i];
        layoutEntity.setInternalLocation(posx, posy += height * (weight - level));
        int relativeCount = 0;
        for (InternalNode childEntity : this.childrenLists[i]) {
            int childEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, childEntity);
            this.computePositionRecursively(childEntity, childEntityIndex, relativePosition + relativeCount, width, height, seenAlready, entities);
            relativeCount += this.getNumberOfLeaves(childEntity, childEntityIndex, entities);
        }
    }

    private int getNumberOfLeaves(InternalNode layoutEntity, int i, InternalNode[] entities) {
        return this.getNumberOfLeavesRecursive(layoutEntity, i, new HashSet<InternalNode>(), entities);
    }

    private int getNumberOfLeavesRecursive(InternalNode layoutEntity, int i, Set<InternalNode> seen, InternalNode[] entities) {
        int numLeaves = 0;
        List<InternalNode> children = this.childrenLists[i];
        if (!children.isEmpty()) {
            numLeaves = 1;
        } else {
            for (InternalNode childEntity : children) {
                if (!seen.contains(childEntity)) {
                    seen.add(childEntity);
                    int childEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, childEntity);
                    numLeaves += this.getNumberOfLeavesRecursive(childEntity, childEntityIndex, seen, entities);
                    continue;
                }
                numLeaves = 1;
            }
        }
        return numLeaves;
    }

    private int getLevel(InternalNode layoutEntity, int i, InternalNode[] entities) {
        return this.getLevelRecursive(layoutEntity, i, new HashSet<InternalNode>(), entities);
    }

    private int getLevelRecursive(InternalNode layoutEntity, int i, Set<InternalNode> seen, InternalNode[] entities) {
        if (seen.contains(layoutEntity)) {
            return 0;
        }
        seen.add(layoutEntity);
        int maxParentLevel = 0;
        for (InternalNode parentEntity : this.parentLists[i]) {
            int parentEntityIndex = TreeLayoutAlgorithm.indexOfInternalNode(entities, parentEntity);
            int parentLevel = this.getLevelRecursive(parentEntity, parentEntityIndex, seen, entities) + 1;
            maxParentLevel = Math.max(maxParentLevel, parentLevel);
        }
        return maxParentLevel;
    }

    private static int indexOfInternalNode(InternalNode[] nodes, InternalNode nodeToFind) {
        int i = 0;
        while (i < nodes.length) {
            InternalNode node = nodes[i];
            if (node.equals(nodeToFind)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Couldn't find index of internal node: " + nodeToFind);
    }

    @Override
    protected boolean isValidConfiguration(boolean asynchronous, boolean continueous) {
        return !continueous;
    }
}

