/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.widgets;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;

class CharacterPairsTableWidget
extends TableViewer {
    CharacterPairsTableWidget(Table table) {
        super(table);
        this.setContentProvider((IContentProvider)new CharacterPairContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new CharacterPairLabelProvider());
        GC gc = new GC((Drawable)table.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumnLayout columnLayout = new TableColumnLayout();
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(LanguageConfigurationMessages.CharacterPairsTableWidget_start);
        int minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.CharacterPairsTableWidget_start);
        columnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(LanguageConfigurationMessages.CharacterPairsTableWidget_end);
        minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.CharacterPairsTableWidget_end);
        columnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        gc.dispose();
    }

    protected int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private static final class CharacterPairContentProvider
    implements IStructuredContentProvider {
        private List<CharacterPair> characterPairList = Collections.emptyList();

        private CharacterPairContentProvider() {
        }

        public Object[] getElements(@Nullable Object input) {
            return this.characterPairList.toArray(CharacterPair[]::new);
        }

        public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
            this.characterPairList = newInput == null ? Collections.emptyList() : (List)newInput;
        }

        public void dispose() {
            this.characterPairList = Collections.emptyList();
        }
    }

    protected static class CharacterPairLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected CharacterPairLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            return null;
        }

        public @Nullable String getText(@Nullable Object element) {
            return this.getColumnText(element, 0);
        }

        public @Nullable String getColumnText(@Nullable Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            return switch (columnIndex) {
                case 0 -> ((CharacterPair)element).open;
                case 1 -> ((CharacterPair)element).close;
                default -> "";
            };
        }
    }
}

