/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.preferences.TerminalColorPresets;
import org.eclipse.tm.terminal.model.TerminalColor;
import org.eclipse.tm.terminal.model.TerminalStyle;

public class StyleMap {
    String fFontName = "terminal.views.view.font.definition";
    private Point fCharSize;
    private final TerminalStyle fDefaultStyle;
    private boolean fInvertColors;
    private boolean fProportional;
    private final int[] fOffsets = new int[256];
    private final Map<TerminalColor, RGB> fColorMap = new EnumMap<TerminalColor, RGB>(TerminalColor.class);

    public StyleMap() {
        this.fDefaultStyle = TerminalStyle.getDefaultStyle();
        this.initFont();
        this.initColors();
    }

    private void initColors() {
        TerminalColor[] values;
        EnumMap<TerminalColor, RGB> map = new EnumMap<TerminalColor, RGB>(TerminalColor.class);
        TerminalColor[] terminalColorArray = values = TerminalColor.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            TerminalColor terminalColor = terminalColorArray[n2];
            RGB rgb = TerminalColorPresets.INSTANCE.getDefaultPreset().getRGB(terminalColor);
            map.put(terminalColor, rgb);
            ++n2;
        }
        this.updateColors(map);
    }

    private void initFont() {
        this.updateFont("terminal.views.view.font.definition");
    }

    private RGB getRGB(TerminalColor color) {
        return this.fColorMap.get((Object)color);
    }

    public RGB getForegrondRGB(TerminalStyle style) {
        RGB foregroundRGB = (style = this.defaultIfNull(style)).isReverse() ? style.getBackgroundRGB() : style.getForegroundRGB();
        if (foregroundRGB != null) {
            return foregroundRGB;
        }
        TerminalColor color = style.isReverse() ? style.getBackgroundTerminalColor() : style.getForegroundTerminalColor();
        if (color == null) {
            color = TerminalColor.FOREGROUND;
        }
        color = color.convertColor(this.fInvertColors, style.isBold());
        return this.getRGB(color);
    }

    public RGB getBackgroundRGB(TerminalStyle style) {
        RGB backgroundRGB = (style = this.defaultIfNull(style)).isReverse() ? style.getForegroundRGB() : style.getBackgroundRGB();
        if (backgroundRGB != null) {
            return backgroundRGB;
        }
        TerminalColor color = style.isReverse() ? style.getForegroundTerminalColor() : style.getBackgroundTerminalColor();
        if (color == null) {
            color = TerminalColor.BACKGROUND;
        }
        color = color.convertColor(this.fInvertColors, style.isBold());
        return this.getRGB(color);
    }

    private TerminalStyle defaultIfNull(TerminalStyle style) {
        if (style == null) {
            style = this.fDefaultStyle;
        }
        return style;
    }

    public void setInvertedColors(boolean invert) {
        this.fInvertColors = invert;
    }

    public boolean isInvertedColors() {
        return this.fInvertColors;
    }

    public Font getFont(TerminalStyle style) {
        if ((style = this.defaultIfNull(style)).isBold()) {
            return JFaceResources.getFontRegistry().getBold(this.fFontName);
        }
        if (style.isUnderline()) {
            return JFaceResources.getFontRegistry().getItalic(this.fFontName);
        }
        return JFaceResources.getFontRegistry().get(this.fFontName);
    }

    public Font getFont() {
        return JFaceResources.getFontRegistry().get(this.fFontName);
    }

    public int getFontWidth() {
        return this.fCharSize.x;
    }

    public int getFontHeight() {
        return this.fCharSize.y;
    }

    @Deprecated
    public void updateFont() {
        this.updateFont("terminal.views.view.font.definition");
    }

    public void updateFont(String fontName) {
        Display display = Display.getCurrent();
        GC gc = new GC((Drawable)display);
        this.fFontName = JFaceResources.getFontRegistry().hasValueFor(fontName) ? fontName : "org.eclipse.jface.textfont";
        gc.setFont(this.getFont());
        this.fCharSize = gc.textExtent("W");
        this.fProportional = false;
        char c = ' ';
        while (c <= '~') {
            if (this.measureChar(gc, c, true)) {
                this.fProportional = true;
            }
            c = (char)(c + '\u0001');
        }
        if (this.fProportional) {
            this.fCharSize.x -= 2;
            c = '\u007f';
            while (c < this.fOffsets.length) {
                this.measureChar(gc, c, false);
                c = (char)(c + '\u0001');
            }
            i = 32;
            while (i < this.fOffsets.length) {
                this.fOffsets[i] = (this.fCharSize.x - this.fOffsets[i]) / 2;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.fOffsets.length) {
                this.fOffsets[i] = 0;
                ++i;
            }
            String t = "The quick brown Fox jumps over the Lazy Dog.";
            Point ext = gc.textExtent(t);
            if (ext.x != this.fCharSize.x * t.length()) {
                this.fProportional = true;
            }
            gc.setFont(this.getFont(this.fDefaultStyle.setBold(true)));
            Point charSizeBold = gc.textExtent("W");
            if (this.fCharSize.x != charSizeBold.x) {
                this.fProportional = true;
            }
        }
        gc.dispose();
    }

    private boolean measureChar(GC gc, char c, boolean updateMax) {
        boolean proportional = false;
        Point ext = gc.textExtent(String.valueOf(c));
        if (ext.x > 0 && ext.y > 0 && (this.fCharSize.x != ext.x || this.fCharSize.y != ext.y)) {
            proportional = true;
            if (updateMax) {
                this.fCharSize.x = Math.max(this.fCharSize.x, ext.x);
                this.fCharSize.y = Math.max(this.fCharSize.y, ext.y);
            }
        }
        this.fOffsets[c] = ext.x;
        return proportional;
    }

    public boolean isFontProportional() {
        return this.fProportional;
    }

    public int getCharOffset(char c) {
        if (c >= this.fOffsets.length) {
            return 0;
        }
        return this.fOffsets[c];
    }

    public void updateColors(Map<TerminalColor, RGB> colorMap) {
        this.fColorMap.putAll(colorMap);
    }
}

