/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.debug.ui.ITCFObject;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class CBreakpointTypeFieldEditor
extends FieldEditor {
    private Composite fParent;
    private final String fLabel;
    private final int fType;
    private final String fCapability;
    private boolean wasSelected;
    private Button checkBox;

    public CBreakpointTypeFieldEditor(Composite parent, String label, int type, String capability) {
        this.fParent = parent;
        this.fLabel = label;
        this.fType = type;
        this.fCapability = capability;
        this.init("org.eclipse.cdt.debug.core.breakpointType", "");
        this.createControl(parent);
    }

    public void setPage(DialogPage dialogPage) {
        super.setPage(dialogPage);
        this.updateEnablement();
    }

    public void dispose() {
        this.fParent = null;
        super.dispose();
    }

    protected void updateEnablement() {
        IChannel channel = this.getActiveChannel();
        Boolean enabled = channel == null || channel.getState() != 1 ? Boolean.FALSE : this.checkChannelCapabilities(channel);
        this.setEnabled(enabled, this.fParent);
    }

    protected Boolean checkChannelCapabilities(final IChannel channel) {
        Boolean result = Boolean.FALSE;
        result = (Boolean)new TCFTask<Boolean>(){

            public void run() {
                IBreakpoints service = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                service.getCapabilities(null, new IBreakpoints.DoneGetCapabilities(){

                    public void doneGetCapabilities(IToken token, Exception error, Map<String, Object> capabilities) {
                        this.done(Boolean.TRUE.equals(capabilities.get(CBreakpointTypeFieldEditor.this.fCapability)));
                    }
                });
            }
        }.getE();
        return result;
    }

    protected IChannel getActiveChannel() {
        Object debugContext = this.getDebugContext();
        if (debugContext instanceof ITCFObject) {
            return ((ITCFObject)debugContext).getChannel();
        }
        return null;
    }

    protected Object getDebugContext() {
        IWorkbenchPropertyPage page = (IWorkbenchPropertyPage)this.getPage();
        if (page != null) {
            IAdaptable element = page.getElement();
            IDebugContextProvider provider = (IDebugContextProvider)element.getAdapter(IDebugContextProvider.class);
            if (provider != null) {
                ISelection selection = provider.getActiveContext();
                if (selection instanceof IStructuredSelection) {
                    return ((IStructuredSelection)selection).getFirstElement();
                }
                return null;
            }
            return DebugUITools.getDebugContext();
        }
        return null;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.checkBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.checkBox = this.getChangeControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.checkBox.setLayoutData((Object)gd);
    }

    public Control getDescriptionControl(Composite parent) {
        return this.getLabelControl(parent);
    }

    protected void doLoad() {
        if (this.checkBox != null) {
            int type = this.getPreferenceStore().getInt(this.getPreferenceName());
            boolean value = (type & this.fType) != 0;
            this.checkBox.setSelection(value);
            this.wasSelected = value;
        }
    }

    protected void doLoadDefault() {
        if (this.checkBox != null) {
            int type = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            boolean value = (type & this.fType) != 0;
            this.checkBox.setSelection(value);
            this.wasSelected = value;
        }
    }

    protected void doStore() {
        int type = this.getPreferenceStore().getInt(this.getPreferenceName());
        boolean selection = this.checkBox.getSelection();
        type = selection ? (type |= this.fType) : (type &= ~this.fType);
        this.getPreferenceStore().setValue(this.getPreferenceName(), type);
    }

    public boolean getBooleanValue() {
        return this.checkBox.getSelection();
    }

    protected Button getChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = new Button(parent, 16416);
            this.checkBox.setText(this.fLabel);
            this.checkBox.setFont(parent.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = CBreakpointTypeFieldEditor.this.checkBox.getSelection();
                    CBreakpointTypeFieldEditor.this.valueChanged(CBreakpointTypeFieldEditor.this.wasSelected, isSelected);
                    CBreakpointTypeFieldEditor.this.wasSelected = isSelected;
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CBreakpointTypeFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged("field_editor_value", oldValue, newValue);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getChangeControl(parent).setEnabled(enabled);
    }
}

