/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.controller;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.collection.ComposerPackages;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;

public class GraphController
extends LabelProvider
implements IStructuredContentProvider,
IGraphEntityContentProvider,
IEntityStyleProvider {
    private Color LIGHT_BLUE = new Color((Device)Display.getDefault(), 216, 228, 248);
    private Color DARK_BLUE = new Color((Device)Display.getDefault(), 1, 70, 122);
    private Color LIGHT_GREY = new Color(null, 192, 192, 192);
    private Color GREEN = new Color((Device)Display.getDefault(), 166, 222, 168);
    private ComposerPackages packages;
    private IComposerProject composerProject;
    private String filterText;

    public GraphController(IComposerProject project) {
        this.composerProject = project;
    }

    public void setComposerProject(IComposerProject project) {
        this.composerProject = project;
    }

    public Object[] getConnectedTo(Object entity) {
        if (!(entity instanceof ComposerPackage)) {
            return null;
        }
        ComposerPackages connections = new ComposerPackages();
        ComposerPackage pkg = (ComposerPackage)entity;
        for (ComposerPackage target : this.packages) {
            if (!pkg.getRequire().has((VersionedPackage)target) && !pkg.getRequireDev().has((VersionedPackage)target)) continue;
            connections.add((Object)target);
        }
        return connections.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ComposerPackages) {
            this.packages = (ComposerPackages)newInput;
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.packages.toArray();
    }

    public String getText(Object element) {
        if (element instanceof ComposerPackage) {
            return ((ComposerPackage)element).getName();
        }
        if (element instanceof EntityConnectionData) {
            return "";
        }
        return super.getText(element);
    }

    public Color getNodeHighlightColor(Object entity) {
        return ColorConstants.yellow;
    }

    public Color getBorderColor(Object entity) {
        return this.LIGHT_GREY;
    }

    public Color getBorderHighlightColor(Object entity) {
        return this.LIGHT_GREY;
    }

    public int getBorderWidth(Object entity) {
        return 0;
    }

    public Color getBackgroundColour(Object entity) {
        if (entity instanceof ComposerPackage) {
            ComposerPackage pkg = (ComposerPackage)entity;
            if (this.filterText != null && this.filterText.length() > 0 && pkg.getName().contains(this.filterText)) {
                return this.GREEN;
            }
            if (this.composerProject.getComposerPackage().getRequireDev().has((VersionedPackage)((ComposerPackage)entity))) {
                return ColorConstants.lightGray;
            }
        }
        return this.LIGHT_BLUE;
    }

    public Color getForegroundColour(Object entity) {
        return this.DARK_BLUE;
    }

    public IFigure getTooltip(Object entity) {
        return null;
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        this.filterText = filterText;
    }
}

