/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.reconciler.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public class FoldingReconcilerStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument document;
    private String oldDocument;
    private ProjectionViewer projectionViewer;
    private final List<Annotation> oldAnnotations = new ArrayList<Annotation>();
    private final List<Position> oldPositions = new ArrayList<Position>();
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$pde$internal$genericeditor$target$extension$reconciler$folding$FoldingReconcilerStrategy$SearchingFor;

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProjectionViewer(ProjectionViewer projectionViewer) {
        this.projectionViewer = projectionViewer;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void initialReconcile() {
        ProjectionAnnotationModel projectionAnnotationModel = this.projectionViewer.getProjectionAnnotationModel();
        if (this.document.get().equals(this.oldDocument) || projectionAnnotationModel == null) {
            return;
        }
        this.oldDocument = this.document.get();
        List<Position> positions = this.getNewPositionsOfAnnotations();
        ArrayList<Position> positionsToRemove = new ArrayList<Position>();
        ArrayList<Annotation> annotationToRemove = new ArrayList<Annotation>();
        for (Position position : this.oldPositions) {
            if (!positions.contains(position)) {
                projectionAnnotationModel.removeAnnotation(this.oldAnnotations.get(this.oldPositions.indexOf(position)));
                positionsToRemove.add(position);
                annotationToRemove.add(this.oldAnnotations.get(this.oldPositions.indexOf(position)));
                continue;
            }
            positions.remove(position);
        }
        this.oldPositions.removeAll(positionsToRemove);
        this.oldAnnotations.removeAll(annotationToRemove);
        for (Position position : positions) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            projectionAnnotationModel.addAnnotation((Annotation)annotation, position);
            this.oldPositions.add(position);
            this.oldAnnotations.add((Annotation)annotation);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<Position> getNewPositionsOfAnnotations() {
        positions = new ArrayList<Position>();
        startOfAnnotation = new HashMap<String, ArrayList<E>>();
        searchingFor = SearchingFor.START_OF_TAG;
        characters = this.document.getLength();
        currentCharIndex = 0;
        wordStartIndex = 0;
        sectionStartIndex = 0;
        isCurrentTagClosing = false;
        word = "";
        try {
            while (currentCharIndex < characters) {
                currentChar = this.document.getChar(currentCharIndex);
                switch (FoldingReconcilerStrategy.$SWITCH_TABLE$org$eclipse$pde$internal$genericeditor$target$extension$reconciler$folding$FoldingReconcilerStrategy$SearchingFor()[searchingFor.ordinal()]) {
                    case 1: {
                        if (currentChar != '<') ** GOTO lbl85
                        nextChar = this.document.getChar(currentCharIndex + 1);
                        if (nextChar != '/') ** GOTO lbl20
                        isCurrentTagClosing = true;
                        ** GOTO lbl38
lbl20:
                        // 1 sources

                        if (nextChar == '?') {
                            searchingFor = SearchingFor.START_OF_TAG;
                        } else if (this.document.get(currentCharIndex + 1, 3).equals("!--")) {
                            word = "!--";
                            sectionStartIndex = currentCharIndex;
                            if (startOfAnnotation.containsKey(word)) {
                                ((List)startOfAnnotation.get(word)).add(sectionStartIndex);
                            } else {
                                startingIndexes = new ArrayList<Integer>();
                                startingIndexes.add(sectionStartIndex);
                                startOfAnnotation.put(word, startingIndexes);
                            }
                            searchingFor = SearchingFor.END_OF_COMMENT;
                        } else {
                            isCurrentTagClosing = false;
lbl38:
                            // 2 sources

                            sectionStartIndex = currentCharIndex;
                            searchingFor = SearchingFor.START_OF_WORD;
                        }
                        ** GOTO lbl85
                    }
                    case 2: {
                        if (Character.isLetter(currentChar)) {
                            wordStartIndex = currentCharIndex;
                            searchingFor = SearchingFor.END_OF_WORD;
                        }
                        ** GOTO lbl85
                    }
                    case 4: {
                        if (this.document.get(currentCharIndex, 3).equals("-->")) {
                            searchingFor = SearchingFor.END_OF_LINE;
                        }
                        ** GOTO lbl85
                    }
                    case 3: {
                        if (!Character.isLetter(currentChar)) {
                            word = this.document.get(wordStartIndex, currentCharIndex - wordStartIndex);
                            if (isCurrentTagClosing) {
                                searchingFor = SearchingFor.END_OF_LINE;
                                if (characters == currentCharIndex + 1) {
                                    break;
                                }
                            } else if (startOfAnnotation.containsKey(word)) {
                                ((List)startOfAnnotation.get(word)).add(sectionStartIndex);
                                searchingFor = SearchingFor.START_OF_TAG;
                            } else {
                                startingIndexes = new ArrayList<Integer>();
                                startingIndexes.add(sectionStartIndex);
                                startOfAnnotation.put(word, startingIndexes);
                                searchingFor = SearchingFor.START_OF_TAG;
                            }
                        }
                        ** GOTO lbl85
                    }
                    case 5: {
                        if (startOfAnnotation.containsKey(word)) {
                            if (currentChar == '\n' || characters == currentCharIndex + 1) {
                                listOfAnnotationIndexes = (List)startOfAnnotation.get(word);
                                start = (Integer)listOfAnnotationIndexes.get(0);
                                if (this.document.getLineOfOffset(start) != this.document.getLineOfOffset(currentCharIndex)) {
                                    positions.add(new Position(start, currentCharIndex + 1 - start));
                                }
                                if (!listOfAnnotationIndexes.isEmpty()) {
                                    listOfAnnotationIndexes.remove(0);
                                } else {
                                    startOfAnnotation.remove(word);
                                }
                            }
                            searchingFor = SearchingFor.START_OF_TAG;
                        }
                    }
lbl85:
                    // 13 sources

                    default: {
                        ++currentCharIndex;
                    }
                }
            }
        }
        catch (BadLocationException v0) {}
        return positions;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$pde$internal$genericeditor$target$extension$reconciler$folding$FoldingReconcilerStrategy$SearchingFor() {
        if ($SWITCH_TABLE$org$eclipse$pde$internal$genericeditor$target$extension$reconciler$folding$FoldingReconcilerStrategy$SearchingFor != null) {
            return $SWITCH_TABLE$org$eclipse$pde$internal$genericeditor$target$extension$reconciler$folding$FoldingReconcilerStrategy$SearchingFor;
        }
        int[] nArray = new int[SearchingFor.values().length];
        try {
            nArray[SearchingFor.END_OF_COMMENT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SearchingFor.END_OF_LINE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SearchingFor.END_OF_WORD.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SearchingFor.START_OF_TAG.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SearchingFor.START_OF_WORD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$pde$internal$genericeditor$target$extension$reconciler$folding$FoldingReconcilerStrategy$SearchingFor = nArray;
        return nArray;
    }

    private static enum SearchingFor {
        START_OF_TAG,
        START_OF_WORD,
        END_OF_WORD,
        END_OF_COMMENT,
        END_OF_LINE;

    }
}

