/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.search.UseScanManager;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class ApiUseScanPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.pde.api.tools.ui.apiusescan.prefpage";
    private IWorkingCopyManager fManager;
    CheckboxTableViewer fTableViewer;
    HashSet<String> fLocationList = new HashSet();
    Button remove = null;
    Button editbutton = null;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 768, 0, 0);
        SWTFactory.createWrapLabel(comp, PreferenceMessages.ApiUseScanPreferencePage_0, 2, 250);
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, PreferenceMessages.ApiUseScanPreferencePage_2, 2);
        Table table = new Table(comp, 68130);
        table.setLayoutData((Object)new GridData(1808));
        GridData gd = (GridData)table.getLayoutData();
        gd.widthHint = 250;
        table.addKeyListener(KeyListener.keyReleasedAdapter(e -> {
            if (e.stateMask == 0 && e.keyCode == 127) {
                this.removeLocation();
            }
        }));
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableColumnLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Composite bcomp = SWTFactory.createComposite(comp, 1, 1, 1042, 0, 0);
        Button button = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_3, null);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.select(true)));
        button = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_10, null);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.select(false)));
        SWTFactory.createHorizontalSpacer(bcomp, 1);
        button = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_4, null);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String loc = this.getDirectory(null);
            if (loc != null) {
                String exactLocation = UseScanManager.getExactScanLocation((String)loc);
                if (exactLocation == null) {
                    this.addLocation(loc);
                } else {
                    this.addLocation(exactLocation);
                }
            }
        }));
        button = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_5, null);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String loc = this.getArchive(null);
            if (loc != null) {
                this.addLocation(loc);
            }
        }));
        this.editbutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_1, null);
        this.editbutton.setEnabled(false);
        this.editbutton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.edit()));
        this.remove = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_6, null);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.removeLocation()));
        this.fTableViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = this.fTableViewer.getStructuredSelection();
            this.remove.setEnabled(!selection.isEmpty());
            this.editbutton.setEnabled(selection.size() == 1);
        });
        this.fTableViewer.addDoubleClickListener(event -> this.edit());
        HashMap<String, Integer> linkdata = new HashMap<String, Integer>();
        linkdata.put("PropertyAndPreferencePage.initialTab", 4);
        PreferenceLinkArea apiErrorLinkArea = new PreferenceLinkArea(comp, 0, "org.eclipse.pde.api.tools.ui.apitools.errorwarnings.prefpage", PreferenceMessages.ApiUseScanPreferencePage_9, (IWorkbenchPreferenceContainer)this.getContainer(), linkdata);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        apiErrorLinkArea.getControl().setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IApiToolsHelpContextIds.APIUSESCANS_PREF_PAGE);
        this.performInit();
        this.validateScans();
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    void select(boolean checked) {
        this.fTableViewer.setAllChecked(checked);
        this.fTableViewer.refresh();
    }

    String getDirectory(String prevLocation) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(PreferenceMessages.ApiUseScanPreferencePage_7);
        if (prevLocation != null) {
            dialog.setFilterPath(prevLocation);
        }
        return dialog.open();
    }

    String getArchive(File file) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterNames(new String[]{PreferenceMessages.archives__zip});
        dialog.setFilterExtensions(new String[]{"*.zip;*.jar"});
        if (file != null) {
            dialog.setFilterPath(file.getParent());
            dialog.setFileName(file.getName());
        }
        return dialog.open();
    }

    void addLocation(String location) {
        this.fLocationList.add(location);
        this.fTableViewer.refresh();
        this.fTableViewer.setChecked((Object)location, true);
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)location));
        this.validateScans();
    }

    void edit() {
        IStructuredSelection selection = this.fTableViewer.getStructuredSelection();
        String location = selection.getFirstElement().toString();
        File file = new File(location);
        String newloc = null;
        newloc = file.isDirectory() ? this.getDirectory(location) : this.getArchive(file);
        if (newloc != null) {
            this.fLocationList.remove(location);
            this.addLocation(newloc);
        }
    }

    void removeLocation() {
        IStructuredSelection selection = this.fTableViewer.getStructuredSelection();
        this.fLocationList.removeAll(selection.toList());
        this.fTableViewer.refresh();
        this.validateScans();
    }

    private void validateScans() {
        if (this.fLocationList.size() > 0) {
            String loc2 = null;
            for (String loc2 : this.fLocationList) {
                if (UseScanManager.isValidScanLocation((String)loc2)) continue;
                this.setErrorMessage(NLS.bind((String)PreferenceMessages.ApiUseScanPreferencePage_8, (Object)loc2));
                this.setValid(false);
                return;
            }
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    public boolean performOk() {
        this.applyChanges();
        return true;
    }

    protected void performApply() {
        this.applyChanges();
    }

    protected void performDefaults() {
        this.fLocationList.clear();
        this.fTableViewer.refresh();
        this.setValid(true);
        this.setErrorMessage(null);
        super.performDefaults();
    }

    private void performInit() {
        this.fManager = this.getContainer() == null ? new WorkingCopyManager() : ((IWorkbenchPreferenceContainer)this.getContainer()).getWorkingCopyManager();
        this.fLocationList.clear();
        String location = this.getStoredValue("API_USE_SCAN_LOCATION", null);
        ArrayList<String> checkedLocations = new ArrayList<String>();
        if (location != null && location.length() > 0) {
            String[] locations;
            String[] stringArray = locations = location.split("\\|");
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                String locationString = stringArray[n2];
                String[] values = locationString.split("\\*");
                this.fLocationList.add(values[0]);
                if (Boolean.parseBoolean(values[1])) {
                    checkedLocations.add(values[0]);
                }
                ++n2;
            }
            this.fLocationList.remove("");
        }
        this.fTableViewer.setInput(this.fLocationList);
        this.fTableViewer.setCheckedElements((Object[])checkedLocations.toArray(new String[checkedLocations.size()]));
        this.fTableViewer.refresh();
        this.setErrorMessage(null);
    }

    private void applyChanges() {
        IProject[] projects;
        StringBuilder locations = new StringBuilder();
        Iterator<String> iterator = this.fLocationList.iterator();
        while (iterator.hasNext()) {
            String string;
            String location = string = iterator.next();
            locations.append((Object)location);
            locations.append("*");
            locations.append(this.fTableViewer.getChecked((Object)location));
            locations.append("|");
        }
        Object[] newCheckedLocations = this.fTableViewer.getCheckedElements();
        boolean hasLocationChanges = this.hasLocationsChanges(locations.toString());
        if (hasLocationChanges && newCheckedLocations.length != 0 && (projects = Util.getApiProjects()) != null && MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferenceMessages.ApiUseScanPreferencePage_11, (String)PreferenceMessages.ApiUseScanPreferencePage_12)) {
            Util.getBuildJob((IProject[])projects).schedule();
        }
        if (hasLocationChanges && newCheckedLocations.length == 0) {
            this.findAndDeleteAPIUseScanMarkers();
        }
        this.setStoredValue("API_USE_SCAN_LOCATION", locations.toString());
        try {
            this.fManager.applyChanges();
        }
        catch (BackingStoreException e) {
            ApiUIPlugin.log(e);
        }
    }

    private void findAndDeleteAPIUseScanMarkers() {
        IProject[] apiProjects = Util.getApiProjects();
        if (apiProjects == null) {
            return;
        }
        IProject[] iProjectArray = apiProjects;
        int n = apiProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            try {
                iProject.deleteMarkers("org.eclipse.pde.api.tools.marker.apiusescan", false, 2);
            }
            catch (CoreException coreException) {}
            ++n2;
        }
    }

    private boolean hasLocationsChanges(String newLocations) {
        Object[] newCheckedLocations;
        int n;
        int n2;
        Object[] objectArray;
        String oldLocations = this.getStoredValue("API_USE_SCAN_LOCATION", null);
        if (oldLocations != null && oldLocations.equalsIgnoreCase(newLocations)) {
            return false;
        }
        ArrayList<String> oldCheckedElements = new ArrayList<String>();
        if (oldLocations != null && oldLocations.length() > 0) {
            String[] locations = oldLocations.split("\\|");
            objectArray = locations;
            n2 = locations.length;
            n = 0;
            while (n < n2) {
                Object location = objectArray[n];
                String[] values = ((String)location).split("\\*");
                if (Boolean.parseBoolean(values[1])) {
                    oldCheckedElements.add(values[0]);
                }
                ++n;
            }
        }
        if ((newCheckedLocations = this.fTableViewer.getCheckedElements()).length != oldCheckedElements.size()) {
            return true;
        }
        objectArray = newCheckedLocations;
        n2 = newCheckedLocations.length;
        n = 0;
        while (n < n2) {
            Object newCheckedLocation = objectArray[n];
            if (!oldCheckedElements.contains(newCheckedLocation)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setStoredValue(String key, String value) {
        IEclipsePreferences node = this.getNode();
        if (value != null) {
            node.put(key, value);
        } else {
            node.remove(key);
        }
    }

    public String getStoredValue(String key, String defaultValue) {
        IEclipsePreferences node = this.getNode();
        if (node != null) {
            return node.get(key, defaultValue);
        }
        return defaultValue;
    }

    private IEclipsePreferences getNode() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.api.tools");
        if (this.fManager != null) {
            return this.fManager.getWorkingCopy(node);
        }
        return node;
    }

    class TableColumnLabelProvider
    extends ColumnLabelProvider {
        Image archive = null;

        TableColumnLabelProvider() {
        }

        public void dispose() {
            if (this.archive != null) {
                this.archive.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object element) {
            File file = new File(element.toString());
            if (file.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (this.archive == null) {
                ImageDescriptor image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName());
                this.archive = image.createImage();
            }
            return this.archive;
        }
    }
}

