/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.history;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.mylyn.internal.tasks.core.sync.GetTaskHistoryJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.compare.TaskDataDiffNode;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.team.ui.history.Messages;
import org.eclipse.mylyn.internal.team.ui.history.TaskHistoryContentProvider;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskHistory;
import org.eclipse.mylyn.tasks.core.data.TaskRevision;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class TaskHistoryPage
extends HistoryPage {
    private TaskHistoryContentProvider contentProvider;
    private GetTaskHistoryJob refreshOperation;
    private TreeViewer viewer;

    public static boolean canShowHistoryFor(Object object) {
        ITask task = TaskHistoryPage.getTask(object);
        if (task != null) {
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
            return connector.canGetTaskHistory(repository, task);
        }
        return false;
    }

    public static ITask getTask(Object object) {
        ITask task = null;
        if (object instanceof ITask) {
            task = (ITask)object;
        } else if (object instanceof IAdaptable) {
            task = (ITask)((IAdaptable)object).getAdapter(ITask.class);
        }
        return task;
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 65536);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        TreeViewerColumn authorViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        authorViewerColumn.setLabelProvider((CellLabelProvider)new AuthorLabelProvider());
        TreeColumn authorColumn = authorViewerColumn.getColumn();
        authorColumn.setText(Messages.TaskHistoryPage_Author_Column_Label);
        authorColumn.setWidth(120);
        authorColumn.setData("org.eclipse.mylyn.column.viewer.support.column.can.hide", (Object)false);
        TreeViewerColumn timeViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        timeViewerColumn.setLabelProvider((CellLabelProvider)new TimeLabelProvider());
        TreeColumn timeColumn = timeViewerColumn.getColumn();
        timeColumn.setText(Messages.TaskHistoryPage_Time_Column_Label);
        timeColumn.setWidth(140);
        TreeViewerColumn fieldViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        fieldViewerColumn.setLabelProvider((CellLabelProvider)new FieldLabelProvider());
        TreeColumn fieldColumn = fieldViewerColumn.getColumn();
        fieldColumn.setText(Messages.TaskHistoryPage_Field_Column_Label);
        fieldColumn.setWidth(120);
        TreeViewerColumn removedViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        removedViewerColumn.setLabelProvider((CellLabelProvider)new RemovedLabelProvider());
        TreeColumn remmovedColumn = removedViewerColumn.getColumn();
        remmovedColumn.setText(Messages.TaskHistoryPage_Removed_Column_Label);
        remmovedColumn.setWidth(120);
        TreeViewerColumn addedViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        addedViewerColumn.setLabelProvider((CellLabelProvider)new AddedLabelProvider());
        TreeColumn addedColumn = addedViewerColumn.getColumn();
        addedColumn.setText(Messages.TaskHistoryPage_Added_Column_Label);
        addedColumn.setWidth(120);
        this.contentProvider = new TaskHistoryContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object item = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (item instanceof TaskRevision) {
                    final TaskRevision revision = (TaskRevision)item;
                    final TaskHistory history = (TaskHistory)TaskHistoryPage.this.viewer.getInput();
                    CompareConfiguration configuration = new CompareConfiguration();
                    configuration.setProperty("IGNORE_WHITESPACE", (Object)true);
                    configuration.setLeftEditable(false);
                    configuration.setLeftLabel(Messages.TaskHistoryPage_Old_Value_Label);
                    configuration.setRightEditable(false);
                    configuration.setRightLabel(Messages.TaskHistoryPage_New_Value_Label);
                    CompareEditorInput editorInput = new CompareEditorInput(configuration){

                        protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(history.getTask().getConnectorKind());
                                TaskData newData = connector.getTaskData(history.getRepository(), history.getTask().getTaskId(), monitor);
                                TaskData oldData = TasksUiInternal.computeTaskData((TaskData)newData, (TaskHistory)history, (String)revision.getId(), (IProgressMonitor)monitor);
                                return new TaskDataDiffNode(3, oldData, newData);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    CompareUI.openCompareEditor((CompareEditorInput)editorInput);
                }
            }
        });
    }

    public void dispose() {
        this.cancelRefresh();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public String getDescription() {
        return NLS.bind((String)Messages.TaskHistoryPage_Task_history_for_X_Desscription_Label, (Object)this.getName());
    }

    public String getName() {
        ITask task = this.getTask();
        return task != null ? task.getSummary() : null;
    }

    public ITask getTask() {
        return TaskHistoryPage.getTask(this.getInput());
    }

    public boolean inputSet() {
        this.cancelRefresh();
        if (this.viewer == null) {
            return false;
        }
        ITask task = this.getTask();
        if (task != null) {
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
            this.refreshOperation = new GetTaskHistoryJob(connector, repository, task);
            this.refreshOperation.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(final IJobChangeEvent event) {
                    if (!event.getResult().isOK()) {
                        return;
                    }
                    if (Display.getDefault().isDisposed()) {
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TaskHistoryPage.this.viewer.getControl() != null && !(this).TaskHistoryPage.this.viewer.getControl().isDisposed()) {
                                TaskHistory history = ((GetTaskHistoryJob)event.getJob()).getHistory();
                                (this).TaskHistoryPage.this.viewer.setInput((Object)history);
                            }
                        }
                    });
                }
            });
            this.schedule((Job)this.refreshOperation);
            return true;
        }
        return false;
    }

    public boolean isValidInput(Object object) {
        return TaskHistoryPage.canShowHistoryFor(object);
    }

    public void refresh() {
        this.inputSet();
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    private void cancelRefresh() {
        if (this.refreshOperation != null) {
            this.refreshOperation.cancel();
            this.refreshOperation = null;
        }
    }

    private IWorkbenchPartSite getWorkbenchSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        return part != null ? part.getSite() : null;
    }

    private void schedule(Job job) {
        IWorkbenchSiteProgressService progress;
        IWorkbenchPartSite site = this.getWorkbenchSite();
        if (site != null && (progress = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            progress.schedule(job, 0L, true);
            return;
        }
        job.schedule();
    }

    private class AddedLabelProvider
    extends ChangeLabelProvider {
        private AddedLabelProvider() {
        }

        @Override
        public String getText(TaskRevision.Change change) {
            return change.getAdded();
        }
    }

    private static class AuthorLabelProvider
    extends ColumnLabelProvider {
        private AuthorLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TaskRevision) {
                TaskRevision entry = (TaskRevision)element;
                return entry.getAuthor().toString();
            }
            if (element instanceof TaskRevision.Change) {
                return null;
            }
            return super.getText(element);
        }
    }

    private static abstract class ChangeLabelProvider
    extends ColumnLabelProvider {
        private ChangeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TaskRevision) {
                TaskRevision entry = (TaskRevision)element;
                if (entry.getChanges().size() == 1) {
                    return this.getText((TaskRevision.Change)entry.getChanges().get(0));
                }
                return null;
            }
            if (element instanceof TaskRevision.Change) {
                return this.getText((TaskRevision.Change)element);
            }
            return super.getText(element);
        }

        public abstract String getText(TaskRevision.Change var1);
    }

    private class FieldLabelProvider
    extends ChangeLabelProvider {
        private FieldLabelProvider() {
        }

        @Override
        public String getText(TaskRevision.Change change) {
            return change.getField();
        }
    }

    private class RemovedLabelProvider
    extends ChangeLabelProvider {
        private RemovedLabelProvider() {
        }

        @Override
        public String getText(TaskRevision.Change change) {
            return change.getRemoved();
        }
    }

    private static class TimeLabelProvider
    extends ColumnLabelProvider {
        private final DateFormat formatter = DateFormat.getDateTimeInstance(2, 3);

        private TimeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TaskRevision) {
                TaskRevision entry = (TaskRevision)element;
                return entry.getDate() != null ? this.formatter.format(entry.getDate()) : null;
            }
            if (element instanceof TaskRevision.Change) {
                return null;
            }
            return super.getText(element);
        }
    }
}

