/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Usage;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="oql")
@Icon(value="/META-INF/icons/oql.gif")
@Usage(value="oql \"select * from ...\"")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/queryingheapobjects.html")
public class OQLQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public String queryString = "select * from ...";
    @Argument(isMandatory=false)
    public List<IContextObject> contexts;

    public IOQLQuery.Result execute(IProgressListener listener) throws Exception {
        try {
            IOQLQuery query;
            Object result;
            String oqlQuery = this.queryString;
            if (this.contexts != null) {
                Pattern p = Pattern.compile("select (.*) from( .*)?", 2);
                Matcher m = p.matcher(oqlQuery);
                String rep = m.find() ? m.group(1) : "*";
                StringBuilder sb = new StringBuilder();
                for (IContextObject c : this.contexts) {
                    if (c instanceof IContextObjectSet) {
                        IContextObjectSet context = (IContextObjectSet)c;
                        String q2 = context.getOQL();
                        if (q2 != null) {
                            OQL.union(sb, q2.replaceFirst("\\*", rep));
                        } else {
                            int[] o = context.getObjectIds();
                            if (o.length >= 1) {
                                q2 = OQL.forObjectIds(context.getObjectIds());
                                OQL.union(sb, q2.replaceFirst("\\*", rep));
                            }
                        }
                    } else if (c.getObjectId() >= 0) {
                        String q3 = OQL.forObjectId(c.getObjectId());
                        OQL.union(sb, q3.replaceFirst("\\*", rep));
                    }
                    if (sb.length() > 1000) break;
                }
                if (sb.length() > 0) {
                    this.queryString = sb.toString();
                    if (sb.length() > 1000) {
                        throw new SnapshotException(Messages.OQLQuery_TooManyObjects);
                    }
                }
            }
            if ((result = (query = SnapshotFactory.createQuery(this.queryString)).execute(this.snapshot, listener)) == null) {
                return new OQLTextResult(String.valueOf(Messages.OQLQuery_NoResult) + "\n\n" + query, this.queryString);
            }
            if (result instanceof IOQLQuery.Result) {
                return (IOQLQuery.Result)result;
            }
            if (result instanceof int[]) {
                return new ObjectListResultImpl(this.snapshot, this.queryString, (int[])result);
            }
            if (result instanceof List) {
                return new ObjectTableResultImpl(this.snapshot, this.queryString, (List)result);
            }
            return new OQLTextResult(String.valueOf(result), this.queryString);
        }
        catch (IProgressListener.OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder(256);
            buf.append(String.valueOf(Messages.OQLQuery_ExecutedQuery) + "\n");
            buf.append(this.queryString);
            Throwable t = null;
            if (e instanceof SnapshotException) {
                buf.append("\n\n" + Messages.OQLQuery_ProblemReported + "\n");
                buf.append(e.getMessage());
                t = e.getCause();
            } else {
                t = e;
            }
            if (t != null) {
                buf.append("\n\n");
                StringWriter w = new StringWriter();
                PrintWriter o = new PrintWriter(w);
                t.printStackTrace(o);
                o.flush();
                buf.append(w.toString());
            }
            return new OQLTextResult(buf.toString(), this.queryString);
        }
    }

    static class OQLTextResult
    extends TextResult
    implements IOQLQuery.Result {
        String queryString;

        public OQLTextResult(String text, String queryString) {
            super(text);
            this.queryString = queryString;
        }

        @Override
        public String getOQLQuery() {
            return this.queryString;
        }
    }

    static class ObjectListResultImpl
    extends ObjectListResult.Outbound
    implements IOQLQuery.Result,
    IResultTree {
        String queryString;

        public ObjectListResultImpl(ISnapshot snapshot, String queryString, int[] objectIds) {
            super(snapshot, objectIds);
            this.queryString = queryString;
        }

        @Override
        public String getOQLQuery() {
            return this.queryString;
        }
    }

    static class ObjectTableResultImpl
    implements IOQLQuery.Result,
    IResultTable,
    IDecorator,
    IIconProvider {
        String queryString;
        List<?> objs;
        boolean hasIObjects;

        public ObjectTableResultImpl(ISnapshot snapshot, String queryString, List<?> objs) {
            this.queryString = queryString;
            this.objs = objs;
            for (Object o : objs) {
                if (!(o instanceof ObjectReference) && !(o instanceof IObject)) continue;
                this.hasIObjects = true;
                break;
            }
        }

        @Override
        public String getOQLQuery() {
            return this.queryString;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            if (this.hasIObjects) {
                return new Column[]{new Column(Messages.Column_ClassName).decorator((IDecorator)this), new Column(Messages.Column_ShallowHeap, Bytes.class).noTotals(), new Column(Messages.Column_RetainedHeap, Bytes.class).noTotals()};
            }
            return new Column[]{new Column(Messages.OQLQuery_Column_Value)};
        }

        public Object getColumnValue(Object row, int columnIndex) {
            int rw = (Integer)row;
            switch (columnIndex) {
                case 0: {
                    Object o = this.objs.get(rw);
                    if (o instanceof ObjectReference) {
                        try {
                            return ((ObjectReference)o).getObject().getDisplayName();
                        }
                        catch (SnapshotException e) {
                            return new IllegalStateException(e);
                        }
                    }
                    if (o instanceof IObject) {
                        return ((IObject)o).getDisplayName();
                    }
                    if (o != null) {
                        return o.toString();
                    }
                    return null;
                }
                case 1: {
                    if (!this.hasIObjects) {
                        throw new IllegalArgumentException();
                    }
                    Object o = this.objs.get(rw);
                    if (o instanceof ObjectReference) {
                        try {
                            return ((ObjectReference)o).getObject().getUsedHeapSize();
                        }
                        catch (SnapshotException e) {
                            return new IllegalStateException(e);
                        }
                    }
                    if (o instanceof IObject) {
                        return ((IObject)o).getUsedHeapSize();
                    }
                    return null;
                }
                case 2: {
                    if (!this.hasIObjects) {
                        throw new IllegalArgumentException();
                    }
                    Object o = this.objs.get(rw);
                    if (o instanceof ObjectReference) {
                        try {
                            return ((ObjectReference)o).getObject().getRetainedHeapSize();
                        }
                        catch (SnapshotException e) {
                            return new IllegalStateException(e);
                        }
                    }
                    if (o instanceof IObject) {
                        return ((IObject)o).getRetainedHeapSize();
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException(row.toString());
        }

        public IContextObject getContext(Object row) {
            if (!this.hasIObjects) {
                return null;
            }
            final int rw = (Integer)row;
            return new IContextObjectSet(){

                public int getObjectId() {
                    Object o = objs.get(rw);
                    if (o instanceof ObjectReference) {
                        try {
                            return ((ObjectReference)o).getObjectId();
                        }
                        catch (SnapshotException e) {
                            return -1;
                        }
                    }
                    if (o instanceof IObject) {
                        try {
                            return ((IObject)o).getObjectId();
                        }
                        catch (RuntimeException e) {
                            if (e.getCause() instanceof SnapshotException) {
                                return -1;
                            }
                            throw e;
                        }
                    }
                    return -1;
                }

                public int[] getObjectIds() {
                    int objId = this.getObjectId();
                    if (objId == -1) {
                        return new int[0];
                    }
                    return new int[]{objId};
                }

                public String getOQL() {
                    Object o = objs.get(rw);
                    if (o instanceof ObjectReference) {
                        return OQL.forAddress(((ObjectReference)o).getObjectAddress());
                    }
                    if (o instanceof IObject) {
                        return OQL.forAddress(((IObject)o).getObjectAddress());
                    }
                    return null;
                }
            };
        }

        public int getRowCount() {
            return this.objs.size();
        }

        public Object getRow(int rowId) {
            return rowId;
        }

        public String prefix(Object row) {
            return null;
        }

        public String suffix(Object row) {
            if (!this.hasIObjects) {
                return null;
            }
            int rw = (Integer)row;
            Object o = this.objs.get(rw);
            if (o instanceof ObjectReference) {
                try {
                    GCRootInfo[] gc = ((ObjectReference)o).getObject().getGCRootInfo();
                    if (gc != null) {
                        return GCRootInfo.getTypeSetAsString(gc);
                    }
                    return null;
                }
                catch (SnapshotException gc) {
                    return Messages.OQLQuery_Unindexed;
                }
            }
            if (o instanceof IObject) {
                try {
                    GCRootInfo[] gc = ((IObject)o).getGCRootInfo();
                    if (gc != null) {
                        return GCRootInfo.getTypeSetAsString(gc);
                    }
                    return null;
                }
                catch (SnapshotException snapshotException) {
                    return Messages.OQLQuery_Unindexed;
                }
            }
            return null;
        }

        public URL getIcon(Object row) {
            if (!this.hasIObjects) {
                return null;
            }
            int rw = (Integer)row;
            Object o = this.objs.get(rw);
            if (o instanceof ObjectReference || o instanceof IObject) {
                try {
                    IObject o2 = o instanceof IObject ? (IObject)o : ((ObjectReference)o).getObject();
                    try {
                        int objectId = o2.getObjectId();
                        return Icons.forObject(o2.getSnapshot(), objectId);
                    }
                    catch (RuntimeException e) {
                        if (!(e.getCause() instanceof SnapshotException)) {
                            throw e;
                        }
                        if (o2 instanceof IClassLoader) {
                            return Icons.CLASSLOADER_INSTANCE;
                        }
                        if (o2 instanceof IClass) {
                            return Icons.CLASS_INSTANCE;
                        }
                        if (o2 instanceof IArray) {
                            return Icons.ARRAY_INSTANCE;
                        }
                        return Icons.OBJECT_INSTANCE;
                    }
                }
                catch (SnapshotException snapshotException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

