/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.RpmlintLog;
import org.eclipse.linuxtools.internal.rpm.rpmlint.actions.Messages;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class RunRpmlintAction
extends AbstractHandler {
    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structured;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            for (Object element : structured.toList()) {
                IFile rpmFile = null;
                Object e = element;
                if (e instanceof IFile) {
                    void file;
                    IFile cfr_ignored_1 = (IFile)e;
                    IFile cfr_ignored_2 = (IFile)e;
                    rpmFile = file;
                } else {
                    Object e2 = element;
                    if (e2 instanceof IAdaptable) {
                        void a;
                        IAdaptable cfr_ignored_3 = (IAdaptable)e2;
                        IAdaptable cfr_ignored_4 = (IAdaptable)e2;
                        rpmFile = (IFile)a.getAdapter(IFile.class);
                    }
                }
                if (rpmFile == null) continue;
                RunRpmlintAction.runRpmlint(rpmFile.getLocation().toString());
            }
        } else {
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editor != null) {
                IEditorInput editorInput = editor.getEditorInput();
                IEditorInput iEditorInput = editorInput;
                if (iEditorInput instanceof IFileEditorInput) {
                    void fei;
                    IFileEditorInput rpmFile = (IFileEditorInput)iEditorInput;
                    IFileEditorInput cfr_ignored_5 = (IFileEditorInput)iEditorInput;
                    RunRpmlintAction.runRpmlint(fei.getFile().getLocation().toString());
                } else {
                    IEditorInput iEditorInput2 = editorInput;
                    if (iEditorInput2 instanceof IURIEditorInput) {
                        void uei;
                        IURIEditorInput iURIEditorInput = (IURIEditorInput)iEditorInput2;
                        IURIEditorInput cfr_ignored_6 = (IURIEditorInput)iEditorInput2;
                        RunRpmlintAction.runRpmlint(uei.getURI().getPath());
                    }
                }
            }
        }
        return null;
    }

    private static void runRpmlint(String location) {
        String rpmlintPath = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.linuxtools.rpm.rpmlint").getString("RpmlintPath");
        try {
            if (Files.exists(Paths.get(rpmlintPath, new String[0]), new LinkOption[0])) {
                String output = Utils.runCommandToString((String[])new String[]{rpmlintPath, "-i", location});
                MessageConsole myConsole = RunRpmlintAction.findConsole(Messages.RunRpmlintAction_0);
                MessageConsoleStream out = myConsole.newMessageStream();
                myConsole.clearConsole();
                myConsole.activate();
                out.println(output);
            } else {
                Status warning = Status.warning((String)Messages.RunRpmlintAction_1, null);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.RunRpmlintAction_2, null, (IStatus)warning);
            }
        }
        catch (IOException e) {
            RpmlintLog.logError(e);
        }
    }

    private static MessageConsole findConsole(String name) {
        IConsole[] existing;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] iConsoleArray = existing = conMan.getConsoles();
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole element = iConsoleArray[n2];
            if (name.equals(element.getName())) {
                return (MessageConsole)element;
            }
            ++n2;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

