/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.resource.java;

import java.lang.reflect.Modifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public interface JavaResourceMethod
extends JavaResourceAttribute {
    public static final String PARAMETER_TYPE_NAMES_LIST = "parameterTypeNames";
    public static final String CONSTRUCTOR_PROPERTY = "constructor";
    public static final Predicate<JavaResourceMethod> IS_CONSTRUCTOR = new IsConstructor();
    public static final Predicate<JavaResourceMethod> IS_PROPERTY_GETTER = new IsPropertyGetter();
    public static final Transformer<JavaResourceMethod, JavaResourceMethod> SET_METHOD_TRANSFORMER = new SetMethodTransformer();

    public String getMethodName();

    public ListIterable<String> getParameterTypeNames();

    public String getParameterTypeName(int var1);

    public int getParametersSize();

    public boolean isConstructor();

    public boolean isFor(MethodSignature var1, int var2);

    public void synchronizeWith(MethodDeclaration var1);

    public static class IsConstructor
    extends PredicateAdapter<JavaResourceMethod> {
        public boolean evaluate(JavaResourceMethod method) {
            return method.isConstructor();
        }
    }

    public static class IsPropertyGetter
    extends PredicateAdapter<JavaResourceMethod> {
        public boolean evaluate(JavaResourceMethod method) {
            String methodName = method.getMethodName();
            if (methodName.length() <= 3 && !methodName.startsWith("is")) {
                return false;
            }
            String returnType = this.getInstanceMethodReturnType(method);
            if (returnType == null) {
                return false;
            }
            if (method.getParametersSize() != 0) {
                return false;
            }
            if (methodName.startsWith("is")) {
                return returnType.equals("boolean");
            }
            if (!methodName.startsWith("get")) {
                return false;
            }
            if (!returnType.equals("boolean")) {
                return true;
            }
            String isMethodName = "is" + methodName.substring(3);
            for (JavaResourceMethod sibling : method.getResourceType().getMethods()) {
                if (!sibling.getMethodName().equals(isMethodName) || sibling.getParametersSize() != 0) continue;
                return ObjectTools.notEquals((Object)this.getInstanceMethodReturnType(sibling), (Object)"boolean");
            }
            return true;
        }

        private String getInstanceMethodReturnType(JavaResourceMethod method) {
            if (Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            if (method.isConstructor()) {
                return null;
            }
            String returnType = method.getTypeBinding().getQualifiedName();
            if (returnType == null) {
                return null;
            }
            if (returnType.equals("void")) {
                return null;
            }
            return returnType;
        }
    }

    public static class SetMethodTransformer
    extends TransformerAdapter<JavaResourceMethod, JavaResourceMethod> {
        public JavaResourceMethod transform(JavaResourceMethod getMethod) {
            String getMethodName = getMethod.getMethodName();
            String setMethodName = "set" + getMethodName.substring(this.calculateNameIndex(getMethodName));
            String propertyTypeName = getMethod.getTypeBinding().getQualifiedName();
            for (JavaResourceMethod sibling : getMethod.getResourceType().getMethods()) {
                if (!sibling.getMethodName().equals(setMethodName) || sibling.getParametersSize() != 1 || !sibling.getParameterTypeName(0).equals(propertyTypeName)) continue;
                return this.methodIsValidGetterSibling(sibling) ? sibling : null;
            }
            return null;
        }

        private int calculateNameIndex(String getMethodName) {
            int len = getMethodName.length();
            if (getMethodName.startsWith("get") && len >= 3) {
                return 3;
            }
            if (getMethodName.startsWith("is") && len >= 2) {
                return 2;
            }
            throw new IllegalArgumentException(getMethodName);
        }

        private boolean methodIsValidGetterSibling(JavaResourceMethod method) {
            return !method.isConstructor() && !Modifier.isStatic(method.getModifiers()) && ObjectTools.equals((Object)method.getTypeBinding().getQualifiedName(), (Object)"void");
        }
    }
}

