/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.beans.property;

import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.gef.common.beans.binding.SetMultimapExpressionHelper;
import org.eclipse.gef.common.beans.property.SetMultimapProperty;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.common.collections.SetMultimapChangeListener;

public abstract class SetMultimapPropertyBase<K, V>
extends SetMultimapProperty<K, V> {
    private final SetMultimapChangeListener<K, V> invalidatingValueObserver = new SetMultimapChangeListener<K, V>(){

        @Override
        public void onChanged(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
            SetMultimapPropertyBase.this.invalidateProperties();
            SetMultimapPropertyBase.this.invalidated();
            SetMultimapPropertyBase.this.fireValueChangedEvent(change);
        }
    };
    private SetMultimapExpressionHelper<K, V> helper = null;
    private ObservableSetMultimap<K, V> value = null;
    private boolean valid = true;
    private SizeProperty sizeProperty = null;
    private EmptyProperty emptyProperty = null;
    private ObservableValue<? extends ObservableSetMultimap<K, V>> observedValue = null;
    private InvalidationListener invalidatingObservedValueObserver = null;

    public SetMultimapPropertyBase() {
    }

    public SetMultimapPropertyBase(ObservableSetMultimap<K, V> initialValue) {
        this.value = initialValue;
        if (initialValue != null) {
            initialValue.addListener(this.invalidatingValueObserver);
        }
    }

    public void addListener(ChangeListener<? super ObservableSetMultimap<K, V>> listener) {
        if (this.helper == null) {
            this.helper = new SetMultimapExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        if (this.helper == null) {
            this.helper = new SetMultimapExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    @Override
    public void addListener(SetMultimapChangeListener<? super K, ? super V> listener) {
        if (this.helper == null) {
            this.helper = new SetMultimapExpressionHelper(this);
        }
        this.helper.addListener(listener);
    }

    @Override
    protected void appendValueToString(StringBuilder result) {
        if (this.isBound()) {
            result.append("bound, ");
            if (this.valid) {
                result.append("value: " + this.get());
            } else {
                result.append("invalid");
            }
        } else {
            result.append("value: " + this.get());
        }
    }

    public void bind(ObservableValue<? extends ObservableSetMultimap<K, V>> observedValue) {
        if (observedValue == null) {
            throw new NullPointerException("Cannot bind to null.");
        }
        if (!observedValue.equals(this.observedValue)) {
            this.unbind();
            this.observedValue = observedValue;
            if (this.invalidatingObservedValueObserver == null) {
                this.invalidatingObservedValueObserver = new InvalidatingObserver(this);
            }
            observedValue.addListener(this.invalidatingObservedValueObserver);
            this.markInvalid(this.value);
        }
    }

    @Override
    public ReadOnlyBooleanProperty emptyProperty() {
        if (this.emptyProperty == null) {
            this.emptyProperty = new EmptyProperty();
        }
        return this.emptyProperty;
    }

    protected void fireValueChangedEvent() {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent();
        }
    }

    protected void fireValueChangedEvent(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent(change);
        }
    }

    public ObservableSetMultimap<K, V> get() {
        if (!this.valid) {
            this.value = this.observedValue == null ? this.value : (ObservableSetMultimap)this.observedValue.getValue();
            this.valid = true;
            if (this.value != null) {
                this.value.addListener(this.invalidatingValueObserver);
            }
        }
        return this.value;
    }

    protected void invalidated() {
    }

    private void invalidateProperties() {
        if (this.sizeProperty != null) {
            this.sizeProperty.fireValueChangedEvent();
        }
        if (this.emptyProperty != null) {
            this.emptyProperty.fireValueChangedEvent();
        }
    }

    public boolean isBound() {
        return this.observedValue != null;
    }

    private void markInvalid(ObservableSetMultimap<K, V> oldValue) {
        if (this.valid) {
            if (oldValue != null) {
                oldValue.removeListener(this.invalidatingValueObserver);
            }
            this.valid = false;
            this.invalidateProperties();
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    public void removeListener(ChangeListener<? super ObservableSetMultimap<K, V>> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    @Override
    public void removeListener(SetMultimapChangeListener<? super K, ? super V> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void set(ObservableSetMultimap<K, V> newValue) {
        if (this.isBound()) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        if (this.value != newValue) {
            ObservableSetMultimap<K, V> oldValue = this.value;
            this.value = newValue;
            this.markInvalid(oldValue);
        }
    }

    @Override
    public ReadOnlyIntegerProperty sizeProperty() {
        if (this.sizeProperty == null) {
            this.sizeProperty = new SizeProperty();
        }
        return this.sizeProperty;
    }

    public void unbind() {
        if (this.observedValue != null) {
            this.value = (ObservableSetMultimap)this.observedValue.getValue();
            this.observedValue.removeListener(this.invalidatingObservedValueObserver);
            this.invalidatingObservedValueObserver = null;
            this.observedValue = null;
        }
    }

    private class EmptyProperty
    extends ReadOnlyBooleanPropertyBase {
        private EmptyProperty() {
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public boolean get() {
            return SetMultimapPropertyBase.this.isEmpty();
        }

        public Object getBean() {
            return SetMultimapPropertyBase.this;
        }

        public String getName() {
            return "empty";
        }
    }

    private static class InvalidatingObserver<K, V>
    implements InvalidationListener {
        private WeakReference<SetMultimapPropertyBase<K, V>> setMultimapPropertyRef;

        public InvalidatingObserver(SetMultimapPropertyBase<K, V> setMultimapProperty) {
            this.setMultimapPropertyRef = new WeakReference<SetMultimapPropertyBase<K, V>>(setMultimapProperty);
        }

        public void invalidated(Observable observable) {
            SetMultimapPropertyBase setMultimapProperty = (SetMultimapPropertyBase)this.setMultimapPropertyRef.get();
            if (setMultimapProperty == null) {
                observable.removeListener((InvalidationListener)this);
            } else {
                setMultimapProperty.markInvalid(setMultimapProperty.value);
            }
        }
    }

    private class SizeProperty
    extends ReadOnlyIntegerPropertyBase {
        private SizeProperty() {
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public int get() {
            return SetMultimapPropertyBase.this.size();
        }

        public Object getBean() {
            return SetMultimapPropertyBase.this;
        }

        public String getName() {
            return "size";
        }
    }
}

