/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.merge;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="replaceEnum", label="Replace Enumeration", description="In the metamodel, an enumeration is replaced by another one. More specifically, the enumeration is deleted and the other enumeration used instead. In the model, the values of this enumeration are replaced based on a mapping of literals.", breaking=true)
public class ReplaceEnum
extends OperationImplementation {
    @EdaptParameter(main=true, description="The enumeration to be replaced")
    public EEnum toReplace;
    @EdaptParameter(description="The enumeration by which it is replaced")
    public EEnum replaceBy;
    @EdaptParameter(description="The literals to be replaced")
    public List<EEnumLiteral> literalsToReplace;
    @EdaptParameter(description="The literals by which they are replaced (in the same order)")
    public List<EEnumLiteral> literalsReplaceBy;

    @EdaptConstraint(restricts="literalsToReplace", description="The replaced literals must belong to the replaced enumeration")
    public boolean checkLiteralsToReplaceCommonEnumeration(EEnumLiteral literalsToReplace) {
        return this.toReplace.getELiterals().contains((Object)literalsToReplace);
    }

    @EdaptConstraint(restricts="literalsReplaceBy", description="The replacing literals must belong to the replacing enumeration")
    public boolean checkLiteralsReplaceBy(EEnumLiteral literalsReplaceBy) {
        return this.replaceBy.getELiterals().contains((Object)literalsReplaceBy);
    }

    @EdaptConstraint(description="The replacing and replaced literals must be of the same size")
    public boolean checkLiteralsSameSize() {
        return this.literalsReplaceBy.size() == this.literalsToReplace.size();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EList attributes = metamodel.getInverse((EModelElement)this.toReplace, EcorePackage.Literals.EATTRIBUTE__EATTRIBUTE_TYPE);
        for (EAttribute attribute : attributes) {
            attribute.setEType((EClassifier)this.replaceBy);
        }
        metamodel.delete((EModelElement)this.toReplace);
        for (EAttribute attribute : attributes) {
            EClass eClass = attribute.getEContainingClass();
            for (Instance instance : model.getAllInstances(eClass)) {
                if (!instance.isSet((EStructuralFeature)attribute)) continue;
                Object value = instance.get((EStructuralFeature)attribute);
                int index = this.literalsToReplace.indexOf(value);
                instance.set((EStructuralFeature)attribute, (Object)this.literalsReplaceBy.get(index));
            }
        }
    }
}

