/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.execute;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ResultContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ResultTableElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ResultTableViewer
extends TableViewer {
    String[] columnProperties;
    ResultSet resultSet;
    TextCellEditor stringEditor;

    public ResultTableViewer(int style, ResultSet resultSet, Composite parent) {
        super(new Table(parent, style));
        this.resultSet = resultSet;
        Table table = this.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        if (resultSet != null) {
            try {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int numberOfColumns = metaData.getColumnCount();
                this.columnProperties = new String[numberOfColumns];
                if (numberOfColumns > 0) {
                    int i = 1;
                    while (i <= numberOfColumns) {
                        String label = metaData.getColumnLabel(i);
                        TableColumn column = new TableColumn(table, 0);
                        column.setText(label);
                        column.setWidth(80);
                        this.columnProperties[i - 1] = new String(label);
                        ++i;
                    }
                }
                this.setContentProvider((IContentProvider)ResultContentProvider.createMyTable(this.columnProperties, resultSet));
                this.setLabelProvider((IBaseLabelProvider)new ResultLabelProvider());
            }
            catch (Exception exception) {
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages._UI_DIALOG_OP_FAILED_TITLE, (String)exception.toString(), null);
            }
        }
    }

    public int getRecordsDisplayedCount() {
        return ((ResultContentProvider)this.getContentProvider()).getRecordsDisplayedCount();
    }

    public void setLinesVisible(boolean visible) {
        this.getTable().setLinesVisible(visible);
    }

    class ResultLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ResultLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof ResultTableElement) {
                return ((ResultTableElement)object).getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

