/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import java.util.Optional;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.Messages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.ASTNodeFactoryFactory;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CatchByReferenceQuickFix
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return Messages.CatchByReferenceQuickFix_Message;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        IASTSimpleDeclaration declaration = this.getDeclaration(index, marker);
        if (declaration == null) {
            CheckersUiActivator.log("Could not find declaration");
            return;
        }
        IASTTranslationUnit ast = declaration.getTranslationUnit();
        ASTRewrite rewrite = ASTRewrite.create((IASTTranslationUnit)ast);
        this.getNewDeclSpecifier(declaration).ifPresent(ds -> {
            ASTRewrite aSTRewrite2 = rewrite.replace((IASTNode)declaration.getDeclSpecifier(), (IASTNode)ds, null);
        });
        rewrite.replace((IASTNode)declaration.getDeclarators()[0], (IASTNode)CatchByReferenceQuickFix.getNewDeclarator(declaration), null);
        try {
            rewrite.rewriteAST().perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }

    protected Optional<IASTDeclSpecifier> getNewDeclSpecifier(IASTSimpleDeclaration declaration) {
        return Optional.empty();
    }

    private static IASTDeclarator getNewDeclarator(IASTSimpleDeclaration declaration) {
        ICPPNodeFactory nodeFactory = ASTNodeFactoryFactory.getDefaultCPPNodeFactory();
        ICPPASTReferenceOperator reference = nodeFactory.newReferenceOperator(false);
        IASTDeclarator declarator = declaration.getDeclarators()[0];
        IASTDeclarator replacement = declarator.copy(IASTNode.CopyStyle.withLocations);
        replacement.addPointerOperator((IASTPointerOperator)reference);
        return replacement;
    }

    private IASTSimpleDeclaration getDeclaration(IIndex index, IMarker marker) {
        try {
            ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
            IASTTranslationUnit ast = tu.getAST(index, 6);
            int start = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            if (start != -1 && end != -1) {
                IASTNode node = ast.getNodeSelector(null).findNode(start, end - start);
                while (node != null && !(node instanceof IASTSimpleDeclaration)) {
                    node = node.getParent();
                }
                return (IASTSimpleDeclaration)node;
            }
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
        return null;
    }
}

