/**
 * Copyright (c) 2010 Henning Heitkoetter.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Henning Heitkoetter - initial API and implementation
 */
package org.eclipse.bpmn2.util;

import org.eclipse.emf.ecore.resource.Resource;

/**
 * A BPMN 2.0 enabled resource that provides BPMN2-specific features.
 * @author Henning Heitkoetter
 *
 */
public interface Bpmn2Resource extends Resource {
    /**
     * Returns the adapter for resolving opposite references attached to this resource 
     * (respectively its resource set). Every resource has its own adapter.
     * @return The adapter associated with this resource.
     */
    Bpmn2OppositeReferenceAdapter getOppositeReferenceAdapter();
}
