/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.AccountGeneralPreferences;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.client.Key;
import java.sql.Timestamp;

public final class Account {
    public static final String USER_NAME_PATTERN_FIRST = "[a-zA-Z]";
    public static final String USER_NAME_PATTERN_REST = "[a-zA-Z0-9._-]";
    public static final String USER_NAME_PATTERN_LAST = "[a-zA-Z0-9]";
    public static final String USER_NAME_PATTERN = "^[a-zA-Z][a-zA-Z0-9._-]*[a-zA-Z0-9]$";
    @Column(id=1)
    protected Id accountId;
    @Column(id=2)
    protected Timestamp registeredOn;
    @Column(id=3, notNull=false)
    protected String fullName;
    @Column(id=4, notNull=false)
    protected String preferredEmail;
    @Column(id=5, notNull=false)
    protected Timestamp contactFiledOn;
    @Column(id=6, name="--NONE--")
    protected AccountGeneralPreferences generalPreferences;
    protected String userName;

    protected Account() {
    }

    public Account(Id newId) {
        this.accountId = newId;
        this.registeredOn = new Timestamp(System.currentTimeMillis());
        this.generalPreferences = new AccountGeneralPreferences();
        this.generalPreferences.resetToDefaults();
    }

    public Id getId() {
        return this.accountId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        this.fullName = name;
    }

    public String getPreferredEmail() {
        return this.preferredEmail;
    }

    public void setPreferredEmail(String addr) {
        this.preferredEmail = addr;
    }

    public Timestamp getRegisteredOn() {
        return this.registeredOn;
    }

    public AccountGeneralPreferences getGeneralPreferences() {
        return this.generalPreferences;
    }

    public void setGeneralPreferences(AccountGeneralPreferences p) {
        this.generalPreferences = p;
    }

    public boolean isContactFiled() {
        return this.contactFiledOn != null;
    }

    public Timestamp getContactFiledOn() {
        return this.contactFiledOn;
    }

    public void setContactFiled() {
        this.contactFiledOn = new Timestamp(System.currentTimeMillis());
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public static enum FieldName {
        FULL_NAME,
        USER_NAME,
        REGISTER_NEW_EMAIL;

    }

    public static class Id
    extends IntKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected int id;

        protected Id() {
        }

        public Id(int id) {
            this.id = id;
        }

        public int get() {
            return this.id;
        }

        protected void set(int newValue) {
            this.id = newValue;
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }
    }
}

