/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event;

import java.util.Objects;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfLostEvent
extends TmfEvent
implements ITmfLostEvent {
    private final TmfTimeRange fTimeRange;
    private final long fNbLostEvents;

    public TmfLostEvent(ITmfTrace trace, long rank, ITmfTimestamp timestamp, ITmfEventType type, TmfTimeRange timeRange, long nbLostEvents) {
        super(trace, rank, timestamp, type, null);
        this.fTimeRange = timeRange;
        this.fNbLostEvents = nbLostEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return this.fTimeRange;
    }

    @Override
    public long getNbLostEvents() {
        return this.fNbLostEvents;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.fNbLostEvents ^ this.fNbLostEvents >>> 32);
        result = 31 * result + (this.fTimeRange == null ? 0 : this.fTimeRange.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TmfLostEvent)) {
            return false;
        }
        TmfLostEvent other = (TmfLostEvent)obj;
        if (this.fNbLostEvents != other.fNbLostEvents) {
            return false;
        }
        return Objects.equals(this.fTimeRange, other.fTimeRange);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [Event=" + super.toString() + ", fTimeRange=" + this.fTimeRange + ", fNbLostEvents=" + this.fNbLostEvents + "]";
    }
}

