/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.persistence;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tcf.te.runtime.events.EventManager;

public class LaunchConfigurationChangedEvent
extends EventObject {
    private static final long serialVersionUID = 1934509221613969948L;
    private final String attributeName;
    private final Object oldValue;
    private final Object newValue;

    public LaunchConfigurationChangedEvent(ILaunchConfiguration source, String attributeName, Object oldValue, Object newValue) {
        super(source);
        Assert.isNotNull((Object)attributeName);
        this.attributeName = attributeName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return (ILaunchConfiguration)this.getSource();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    @Override
    public String toString() {
        StringBuffer toString = new StringBuffer(this.getClass().getName());
        String prefix = "";
        if (EventManager.isTracingEnabled()) {
            prefix = "\n\t\t";
        }
        toString.append(String.valueOf(prefix) + "{launch configuration=");
        toString.append(this.getLaunchConfiguration().getName());
        toString.append("," + prefix + "attributeName=");
        toString.append(this.getAttributeName());
        toString.append("," + prefix + "old value=");
        toString.append(this.getOldValue());
        toString.append("," + prefix + "new value=");
        toString.append(this.getNewValue());
        toString.append("}");
        return toString.toString();
    }
}

