/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
implements Iterable<String> {
    private Integer min;
    private Integer max;
    private Integer curr;
    private boolean empty;

    public Range() {
        this.empty = true;
    }

    public Range(int val) {
        this(val, val);
    }

    public Range(int min, int max) throws IllegalArgumentException {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        this.min = min;
        this.max = max;
        this.empty = false;
    }

    public void clear() {
        this.empty = true;
    }

    public boolean contains(int val) {
        return !this.empty && val >= this.min && val <= this.max;
    }

    public Range contains(Range r) {
        Range newRange = new Range();
        if (r.getMaxValue() >= this.min && r.getMinValue() <= this.max) {
            newRange.setMinValue(r.getMinValue() < this.min ? this.min.intValue() : r.getMinValue());
            newRange.setMaxValue(r.getMaxValue() > this.max ? this.max.intValue() : r.getMaxValue());
        }
        return newRange;
    }

    public int getMaxValue() {
        return this.max;
    }

    public int getMinValue() {
        return this.min;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public Iterator<String> iterator() {
        this.curr = this.min;
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return Range.this.curr <= Range.this.max;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    Range range = Range.this;
                    Integer n = range.curr;
                    range.curr = n + 1;
                    return n.toString();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setMaxValue(int val) {
        this.max = val;
        this.empty = false;
    }

    public void setMinValue(int val) {
        this.min = val;
        this.empty = false;
    }

    public int size() {
        return this.empty ? 0 : this.max - this.min + 1;
    }

    public String toString() {
        if (this.min == this.max) {
            return "" + this.min;
        }
        return this.min + "-" + this.max;
    }
}

