/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.internal.launch.IMavenLauncher;
import org.osgi.service.component.annotations.Component;

@Component(service={IMavenLauncher.class})
public class EclipseMavenLauncher
implements IMavenLauncher {
    public CompletableFuture<?> runMaven(File basedir, String goals, Map<String, String> mavenProperties, final boolean interactive) throws CoreException {
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, launchManager.generateLaunchConfigurationName("mavenrun-" + UUID.randomUUID()));
        workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedir.getAbsolutePath());
        workingCopy.setAttribute("M2_GOALS", goals);
        workingCopy.setAttribute("M2_SAVE_BEFORE_LAUNCH", false);
        workingCopy.setAttribute("M2_BATCH", !interactive);
        ArrayList properties = new ArrayList();
        mavenProperties.forEach((propertyKey, propertyValue) -> {
            if (propertyKey != null && !propertyKey.isBlank()) {
                String prop = String.valueOf(propertyKey.strip()) + (propertyValue == null ? "" : "=" + propertyValue);
                properties.add(prop);
            }
        });
        workingCopy.setAttribute("M2_PROPERTIES", properties);
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        final CompletableFuture run = new CompletableFuture();
        final ILaunchConfiguration configuration = workingCopy.doSave();
        final AtomicReference consolePrintOut = new AtomicReference();
        launchManager.addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

            public void launchesRemoved(ILaunch[] launches) {
                this.getMavenLaunch(launches).ifPresent(launch -> {
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                    if (!run.isDone()) {
                        run.cancel(true);
                    }
                });
            }

            public void launchesChanged(ILaunch[] launches) {
                this.getMavenLaunch(launches).ifPresent(launch -> {
                    IProcess[] iProcessArray = launch.getProcesses();
                    int n = iProcessArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess process = iProcessArray[n2];
                        IStreamsProxy streamsProxy = process.getStreamsProxy();
                        List printout = Collections.synchronizedList(new ArrayList());
                        if (consolePrintOut.compareAndSet(null, printout)) {
                            streamsProxy.getOutputStreamMonitor().addListener((text, m) -> {
                                boolean bl = printout.add(text);
                            });
                            streamsProxy.getErrorStreamMonitor().addListener((text, m) -> {
                                boolean bl = printout.add(text);
                            });
                        }
                        ++n2;
                    }
                });
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesTerminated(ILaunch[] launches) {
                this.getMavenLaunch(launches).ifPresent(launch -> {
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                    IProcess[] iProcessArray = launch.getProcesses();
                    int n = iProcessArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess process = iProcessArray[n2];
                        try {
                            int exitValue = process.getExitValue();
                            if (exitValue != 0) {
                                String message = "Process exit value was " + exitValue;
                                if (consolePrintOut.get() != null) {
                                    message = String.valueOf(message) + ". Console printout:\n" + "===============================================================\n" + ((List)consolePrintOut.get()).stream().collect(Collectors.joining()) + "\n\"===============================================================";
                                }
                                run.completeExceptionally(new IllegalStateException(message));
                                return;
                            }
                        }
                        catch (DebugException ex) {
                            run.completeExceptionally(ex);
                            return;
                        }
                        ++n2;
                    }
                    if (!interactive) {
                        launchManager.removeLaunch(launch);
                    }
                    run.completeAsync(() -> launch);
                });
            }

            private Optional<ILaunch> getMavenLaunch(ILaunch[] launches) {
                return Arrays.stream(launches).filter(l -> l.getLaunchConfiguration() == configuration).findFirst();
            }
        });
        DebugUITools.launch((ILaunchConfiguration)configuration, (String)"run");
        return run;
    }
}

