/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.internal.diffmergetool.ExternalMergeTool;
import org.eclipse.jgit.internal.diffmergetool.FileElement;
import org.eclipse.jgit.internal.diffmergetool.InformNoToolHandler;
import org.eclipse.jgit.internal.diffmergetool.MergeTools;
import org.eclipse.jgit.internal.diffmergetool.PromptContinueHandler;
import org.eclipse.jgit.internal.diffmergetool.ToolException;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.internal.BooleanTriState;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.RestOfArgumentsHandler;

@Command(name="mergetool", common=true, usage="usage_MergeTool")
class MergeTool
extends TextBuiltin {
    private MergeTools mergeTools;
    private Optional<String> toolName = Optional.empty();
    private BooleanTriState prompt = BooleanTriState.UNSET;
    @Option(name="--tool-help", usage="usage_toolHelp")
    private boolean toolHelp;
    private boolean gui = false;
    @Argument(required=false, index=0, metaVar="metaVar_paths")
    @Option(name="--", metaVar="metaVar_paths", handler=RestOfArgumentsHandler.class)
    protected List<String> filterPaths;
    private BufferedReader inputReader;

    MergeTool() {
    }

    @Option(name="--tool", aliases={"-t"}, metaVar="metaVar_tool", usage="usage_ToolForMerge")
    void setToolName(String name) {
        this.toolName = Optional.of(name);
    }

    @Option(name="--prompt", usage="usage_prompt")
    void setPrompt(boolean on) {
        this.prompt = BooleanTriState.TRUE;
    }

    @Option(name="--no-prompt", aliases={"-y"}, usage="usage_noPrompt")
    void noPrompt(boolean on) {
        this.prompt = BooleanTriState.FALSE;
    }

    @Option(name="--gui", aliases={"-g"}, usage="usage_MergeGuiTool")
    void setGui(boolean on) {
        this.gui = true;
    }

    @Option(name="--no-gui", usage="usage_noGui")
    void noGui(boolean on) {
        this.gui = false;
    }

    @Override
    protected void init(Repository repository, String gitDir) {
        super.init(repository, gitDir);
        this.mergeTools = new MergeTools(repository);
        this.inputReader = new BufferedReader(new InputStreamReader(this.ins, SystemReader.getInstance().getDefaultCharset()));
    }

    @Override
    protected void run() {
        try {
            if (this.toolHelp) {
                this.showToolHelp();
            } else {
                Map<String, IndexDiff.StageState> files = this.getFiles();
                if (files.size() > 0) {
                    this.merge(files);
                } else {
                    this.outw.println(CLIText.get().mergeToolNoFiles);
                }
            }
            this.outw.flush();
        }
        catch (Exception e) {
            throw MergeTool.die(e.getMessage(), (Throwable)e);
        }
    }

    private void informUserNoTool(List<String> tools) {
        try {
            StringBuilder toolNames = new StringBuilder();
            for (String name : tools) {
                toolNames.append(String.valueOf(name) + " ");
            }
            this.outw.println(MessageFormat.format(CLIText.get().mergeToolPromptToolName, toolNames));
            this.outw.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot output text", e);
        }
    }

    private void merge(Map<String, IndexDiff.StageState> files) throws Exception {
        ArrayList<String> mergedFilePaths = new ArrayList<String>(files.keySet());
        Collections.sort(mergedFilePaths);
        StringBuilder mergedFiles = new StringBuilder();
        for (String mergedFilePath : mergedFilePaths) {
            mergedFiles.append(MessageFormat.format("{0}\n", mergedFilePath));
        }
        this.outw.println(MessageFormat.format(CLIText.get().mergeToolMerging, mergedFiles));
        this.outw.flush();
        boolean showPrompt = this.mergeTools.isInteractive();
        if (this.prompt != BooleanTriState.UNSET) {
            showPrompt = this.prompt == BooleanTriState.TRUE;
        }
        MergeResult mergeResult = MergeResult.SUCCESSFUL;
        for (String mergedFilePath : mergedFilePaths) {
            if (mergeResult == MergeResult.FAILED && showPrompt && !this.isContinueUnresolvedPaths()) {
                mergeResult = MergeResult.ABORTED;
            }
            if (mergeResult == MergeResult.ABORTED) break;
            IndexDiff.StageState fileState = files.get(mergedFilePath);
            if (fileState == IndexDiff.StageState.BOTH_MODIFIED) {
                mergeResult = this.mergeModified(mergedFilePath, showPrompt);
                continue;
            }
            if (fileState == IndexDiff.StageState.DELETED_BY_US || fileState == IndexDiff.StageState.DELETED_BY_THEM) {
                mergeResult = this.mergeDeleted(mergedFilePath, fileState == IndexDiff.StageState.DELETED_BY_US);
                continue;
            }
            this.outw.println(MessageFormat.format(CLIText.get().mergeToolUnknownConflict, mergedFilePath));
            mergeResult = MergeResult.ABORTED;
        }
    }

    /*
     * Unable to fully structure code
     */
    private MergeResult mergeModified(String mergedFilePath, boolean showPrompt) throws Exception {
        this.outw.println(MessageFormat.format(CLIText.get().mergeToolNormalConflict, new Object[]{mergedFilePath}));
        this.outw.flush();
        isMergeSuccessful = true;
        baseSource = ContentSource.create((ObjectReader)this.db.newObjectReader());
        localSource = ContentSource.create((ObjectReader)this.db.newObjectReader());
        remoteSource = ContentSource.create((ObjectReader)this.db.newObjectReader());
        tempDir = this.mergeTools.createTempDirectory();
        tempFilesParent = tempDir != null ? tempDir : this.db.getWorkTree();
        try {
            base = null;
            local = null;
            remote = null;
            merged = new FileElement(mergedFilePath, FileElement.Type.MERGED, this.db.getWorkTree());
            cache = this.db.readDirCache();
            var14_14 = null;
            var15_17 = null;
            try {
                revWalk = new RevWalk(this.db);
                try {
                    treeWalk = new TreeWalk(this.db, revWalk.getObjectReader());
                    try {
                        treeWalk.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{mergedFilePath}));
                        cacheIter = new DirCacheIterator(cache);
                        treeWalk.addTree((AbstractTreeIterator)cacheIter);
                        while (treeWalk.next()) {
                            if (treeWalk.isSubtree()) {
                                treeWalk.enterSubtree();
                                continue;
                            }
                            eolStreamType = treeWalk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                            filterCommand = treeWalk.getFilterCommand("smudge");
                            opt = (WorkingTreeOptions)this.db.getConfig().get(WorkingTreeOptions.KEY);
                            checkoutMetadata = new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand);
                            entry = ((DirCacheIterator)treeWalk.getTree(DirCacheIterator.class)).getDirCacheEntry();
                            if (entry == null) continue;
                            id = entry.getObjectId();
                            switch (entry.getStage()) {
                                case 1: {
                                    base = new FileElement(mergedFilePath, FileElement.Type.BASE);
                                    DirCacheCheckout.getContent((Repository)this.db, (String)mergedFilePath, (DirCacheCheckout.CheckoutMetadata)checkoutMetadata, (ObjectLoader)baseSource.open(mergedFilePath, id), (WorkingTreeOptions)opt, (OutputStream)new FileOutputStream(base.createTempFile(tempFilesParent)));
                                    break;
                                }
                                case 2: {
                                    local = new FileElement(mergedFilePath, FileElement.Type.LOCAL);
                                    DirCacheCheckout.getContent((Repository)this.db, (String)mergedFilePath, (DirCacheCheckout.CheckoutMetadata)checkoutMetadata, (ObjectLoader)localSource.open(mergedFilePath, id), (WorkingTreeOptions)opt, (OutputStream)new FileOutputStream(local.createTempFile(tempFilesParent)));
                                    break;
                                }
                                case 3: {
                                    remote = new FileElement(mergedFilePath, FileElement.Type.REMOTE);
                                    DirCacheCheckout.getContent((Repository)this.db, (String)mergedFilePath, (DirCacheCheckout.CheckoutMetadata)checkoutMetadata, (ObjectLoader)remoteSource.open(mergedFilePath, id), (WorkingTreeOptions)opt, (OutputStream)new FileOutputStream(remote.createTempFile(tempFilesParent)));
                                }
                            }
                        }
                    }
                    finally {
                        if (treeWalk != null) {
                            treeWalk.close();
                        }
                    }
                    ** if (revWalk == null) goto lbl-1000
                }
                catch (Throwable var15_18) {
                    if (var14_14 == null) {
                        var14_14 = var15_18;
                    } else if (var14_14 != var15_18) {
                        var14_14.addSuppressed(var15_18);
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                    throw var14_14;
                }
lbl-1000:
                // 1 sources

                {
                    revWalk.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var15_19) {
                if (var14_14 == null) {
                    var14_14 = var15_19;
                } else if (var14_14 != var15_19) {
                    var14_14.addSuppressed(var15_19);
                }
                throw var14_14;
            }
            if (local == null || remote == null) {
                throw MergeTool.die(MessageFormat.format(CLIText.get().mergeToolDied, new Object[]{mergedFilePath}));
            }
            modifiedBefore = merged.getFile().lastModified();
            try {
                block36: {
                    optionalResult = this.mergeTools.merge(local, remote, merged, base, tempDir, this.toolName, this.prompt, this.gui, (PromptContinueHandler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Z, promptForLaunch(java.lang.String ), (Ljava/lang/String;)Z)((MergeTool)this), (InformNoToolHandler)LambdaMetafactory.metafactory(null, null, null, (Ljava/util/List;)V, informUserNoTool(java.util.List<java.lang.String> ), (Ljava/util/List;)V)((MergeTool)this));
                    if (!optionalResult.isPresent()) break block36;
                    result = (FS.ExecutionResult)optionalResult.get();
                    defaultCharset = SystemReader.getInstance().getDefaultCharset();
                    this.outw.println(new String(result.getStdout().toByteArray(), defaultCharset));
                    this.outw.flush();
                    this.errw.println(new String(result.getStderr().toByteArray(), defaultCharset));
                    this.errw.flush();
                    ** GOTO lbl102
                }
                var26_31 = MergeResult.ABORTED;
                return var26_31;
            }
            catch (ToolException e) {
                isMergeSuccessful = false;
                this.outw.println(e.getResultStdout());
                this.outw.flush();
                this.errw.println(e.getMessage());
                this.errw.println(MessageFormat.format(CLIText.get().mergeToolMergeFailed, new Object[]{mergedFilePath}));
                this.errw.flush();
                if (e.isCommandExecutionError()) {
                    throw MergeTool.die(CLIText.get().mergeToolExecutionError, (Throwable)e);
                }
lbl102:
                // 3 sources

                if (isMergeSuccessful && modifiedBefore == (modifiedAfter = merged.getFile().lastModified())) {
                    this.outw.println(MessageFormat.format(CLIText.get().mergeToolFileUnchanged, new Object[]{mergedFilePath}));
                    v0 = isMergeSuccessful = showPrompt == false || this.isMergeSuccessful() != false;
                }
                if (isMergeSuccessful) {
                    this.addFile(mergedFilePath);
                }
            }
        }
        finally {
            baseSource.close();
            localSource.close();
            remoteSource.close();
        }
        return isMergeSuccessful != false ? MergeResult.SUCCESSFUL : MergeResult.FAILED;
    }

    private MergeResult mergeDeleted(String mergedFilePath, boolean deletedByUs) throws Exception {
        this.outw.println(MessageFormat.format(CLIText.get().mergeToolFileUnchanged, mergedFilePath));
        if (deletedByUs) {
            this.outw.println(CLIText.get().mergeToolDeletedConflictByUs);
        } else {
            this.outw.println(CLIText.get().mergeToolDeletedConflictByThem);
        }
        int mergeDecision = this.getDeletedMergeDecision();
        if (mergeDecision == 1) {
            this.addFile(mergedFilePath);
        } else if (mergeDecision == -1) {
            this.rmFile(mergedFilePath);
        } else {
            return MergeResult.ABORTED;
        }
        return MergeResult.SUCCESSFUL;
    }

    private void addFile(String fileName) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.db);){
            git.add().addFilepattern(fileName).call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void rmFile(String fileName) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.db);){
            git.rm().addFilepattern(fileName).call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean hasUserAccepted(String message) throws IOException {
        boolean yes = true;
        this.outw.print((Object)(String.valueOf(message) + " "));
        this.outw.flush();
        BufferedReader br = this.inputReader;
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.equalsIgnoreCase("y")) {
                yes = true;
                break;
            }
            if (line.equalsIgnoreCase("n")) {
                yes = false;
                break;
            }
            this.outw.print((Object)message);
            this.outw.flush();
        }
        return yes;
    }

    private boolean isContinueUnresolvedPaths() throws IOException {
        return this.hasUserAccepted(CLIText.get().mergeToolContinueUnresolvedPaths);
    }

    private boolean isMergeSuccessful() throws IOException {
        return this.hasUserAccepted(CLIText.get().mergeToolWasMergeSuccessfull);
    }

    private boolean promptForLaunch(String toolNamePrompt) {
        try {
            boolean launch = true;
            this.outw.print((Object)(String.valueOf(MessageFormat.format(CLIText.get().mergeToolLaunch, toolNamePrompt)) + " "));
            this.outw.flush();
            BufferedReader br = this.inputReader;
            String line = null;
            line = br.readLine();
            if (line != null && !line.equalsIgnoreCase("y") && !line.equalsIgnoreCase("")) {
                launch = false;
            }
            return launch;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot output text", e);
        }
    }

    private int getDeletedMergeDecision() throws IOException {
        int ret = 0;
        String message = String.valueOf(CLIText.get().mergeToolDeletedMergeDecision) + " ";
        this.outw.print((Object)message);
        this.outw.flush();
        BufferedReader br = this.inputReader;
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.equalsIgnoreCase("m")) {
                ret = 1;
                break;
            }
            if (line.equalsIgnoreCase("d")) {
                ret = -1;
                break;
            }
            if (line.equalsIgnoreCase("a")) break;
            this.outw.print((Object)message);
            this.outw.flush();
        }
        return ret;
    }

    private void showToolHelp() throws IOException {
        Map predefTools = this.mergeTools.getPredefinedTools(true);
        StringBuilder availableToolNames = new StringBuilder();
        StringBuilder notAvailableToolNames = new StringBuilder();
        for (String name : predefTools.keySet()) {
            if (((ExternalMergeTool)predefTools.get(name)).isAvailable()) {
                availableToolNames.append(MessageFormat.format("\t\t{0}\n", name));
                continue;
            }
            notAvailableToolNames.append(MessageFormat.format("\t\t{0}\n", name));
        }
        StringBuilder userToolNames = new StringBuilder();
        Map userTools = this.mergeTools.getUserDefinedTools();
        for (String name : userTools.keySet()) {
            userToolNames.append(MessageFormat.format("\t\t{0}.cmd {1}\n", name, ((ExternalMergeTool)userTools.get(name)).getCommand()));
        }
        this.outw.println(MessageFormat.format(CLIText.get().mergeToolHelpSetToFollowing, availableToolNames, userToolNames, notAvailableToolNames));
    }

    private Map<String, IndexDiff.StageState> getFiles() throws RevisionSyntaxException, NoWorkTreeException, GitAPIException {
        TreeMap<String, IndexDiff.StageState> files = new TreeMap();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.db);){
            StatusCommand statusCommand = git.status();
            if (this.filterPaths != null && this.filterPaths.size() > 0) {
                for (String path : this.filterPaths) {
                    statusCommand.addPath(path);
                }
            }
            Status status = statusCommand.call();
            files = status.getConflictingStageState();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return files;
    }

    static enum MergeResult {
        SUCCESSFUL,
        FAILED,
        ABORTED;

    }
}

