/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.features;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.examples.filesystem.ui.FilesystemPredefinedColoredAreas;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.AdaptedGradientColoredAreas;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class GradientColorFeature
extends AbstractCustomFeature {
    private static final String DESCRIPTION = "Select Gradient";
    private final String gradientId;

    public GradientColorFeature(IFeatureProvider fp, String gradientId) {
        super(fp);
        this.gradientId = gradientId;
    }

    public String getDescription() {
        return "Select Gradient: " + this.gradientId;
    }

    public String getName() {
        return this.gradientId;
    }

    public boolean canExecute(ICustomContext context) {
        GraphicsAlgorithm ga;
        AdaptedGradientColoredAreas coloredAreas = FilesystemPredefinedColoredAreas.getAdaptedGradientColoredAreas(this.gradientId);
        if (coloredAreas == null) {
            return false;
        }
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length >= 1 && (ga = pes[0].getGraphicsAlgorithm()) != null) {
            for (GraphicsAlgorithm innerGa : ga.getGraphicsAlgorithmChildren()) {
                if (innerGa != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length >= 1) {
            int i = 0;
            while (i < pes.length) {
                PictogramElement pe = pes[i];
                GraphicsAlgorithm currentGa = pe.getGraphicsAlgorithm();
                EList gaChildren = currentGa.getGraphicsAlgorithmChildren();
                for (GraphicsAlgorithm innerGa : gaChildren) {
                    if (!(innerGa instanceof RoundedRectangle) && !(innerGa instanceof Rectangle)) continue;
                    AdaptedGradientColoredAreas ca = FilesystemPredefinedColoredAreas.getAdaptedGradientColoredAreas(this.gradientId);
                    Graphiti.getGaService().setRenderingStyle((AbstractStyle)innerGa, ca);
                }
                ++i;
            }
        }
    }
}

