/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.format;

import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.internal.format.IJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.JSONArrayFormatter;
import org.eclipse.wst.json.core.internal.format.JSONDocumentFormatter;
import org.eclipse.wst.json.core.internal.format.JSONObjectFormatter;
import org.eclipse.wst.json.core.internal.format.JSONPairFormatter;
import org.eclipse.wst.json.core.internal.format.UnknownRuleFormatter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public class JSONSourceFormatterFactory {
    private static JSONSourceFormatterFactory fInstance;

    private JSONSourceFormatterFactory() {
    }

    public IJSONSourceFormatter getSourceFormatter(INodeNotifier target) {
        IJSONNode node = (IJSONNode)target;
        short type = node.getNodeType();
        switch (type) {
            case -1: {
                return JSONDocumentFormatter.getInstance();
            }
            case 0: {
                return JSONObjectFormatter.getInstance();
            }
            case 1: {
                return JSONArrayFormatter.getInstance();
            }
            case 2: {
                return JSONPairFormatter.getInstance();
            }
        }
        return UnknownRuleFormatter.getInstance();
    }

    public static synchronized JSONSourceFormatterFactory getInstance() {
        if (fInstance == null) {
            fInstance = new JSONSourceFormatterFactory();
        }
        return fInstance;
    }
}

