/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.editor;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.editor.tools.api.editor.EditorCustomization;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public class EditorCustomizationManager {
    private static final String ID = "org.eclipse.sirius.editor.editorCustomization";
    private static final String CLASS_ATTRIBUTE = "class";
    private static EditorCustomizationManager eINSTANCE = EditorCustomizationManager.init();
    private final Collection<EditorCustomization> customizers = new LinkedHashSet<EditorCustomization>();

    public static EditorCustomizationManager init() {
        EditorCustomizationManager manager = new EditorCustomizationManager();
        if (SiriusPlugin.IS_ECLIPSE_RUNNING) {
            List contributedCustomizer = EclipseUtil.getExtensionPlugins(EditorCustomization.class, (String)ID, (String)CLASS_ATTRIBUTE);
            for (EditorCustomization menuBuilder : contributedCustomizer) {
                manager.add(menuBuilder);
            }
        }
        return manager;
    }

    private void add(EditorCustomization editorCustomizer) {
        this.customizers.add(editorCustomizer);
    }

    public boolean isHidden(EModelElement feature) {
        for (EditorCustomization editorCustomization : this.customizers) {
            if (!editorCustomization.isHidden(feature)) continue;
            return true;
        }
        return false;
    }

    public boolean showTheAllTab() {
        for (EditorCustomization editorCustomization : this.customizers) {
            if (editorCustomization.showAllTab()) continue;
            return false;
        }
        return true;
    }

    public static EditorCustomizationManager getInstance() {
        return eINSTANCE;
    }
}

