/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.impl.extension.uddi;

import java.util.Vector;
import org.apache.wsil.QName;
import org.apache.wsil.WSILElement;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.ExtensionReader;
import org.apache.wsil.extension.uddi.BusinessDescription;
import org.apache.wsil.extension.uddi.ServiceDescription;
import org.apache.wsil.impl.extension.uddi.BusinessDescriptionImpl;
import org.apache.wsil.impl.extension.uddi.ServiceDescriptionImpl;
import org.apache.wsil.util.XMLUtil;
import org.uddi4j.util.BusinessKey;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.DiscoveryURL;
import org.uddi4j.util.KeyedReference;
import org.uddi4j.util.ServiceKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class UDDIExtensionReader
implements ExtensionReader {
    public ExtensionElement parseElement(Element element, WSILElement wSILElement) throws WSILException {
        ExtensionElement extensionElement = null;
        QName qName = new QName(element);
        if (qName.equals(ServiceDescription.QNAME) || qName.equals(ServiceDescription.QNAME_V2)) {
            extensionElement = this.parseServiceDescription(element, wSILElement);
        } else if (qName.equals(BusinessDescription.QNAME) || qName.equals(BusinessDescription.QNAME_V2)) {
            extensionElement = this.parseBusinessDescription(element, wSILElement);
        } else {
            throw new WSILException("WSIL document contains undefined UDDI extension element: " + element.getTagName() + ".");
        }
        return extensionElement;
    }

    protected ExtensionElement parseServiceDescription(Element element, WSILElement wSILElement) throws WSILException {
        ServiceDescriptionImpl serviceDescriptionImpl = new ServiceDescriptionImpl();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = (Attr)namedNodeMap.item(0);
        String string = attr.getValue();
        serviceDescriptionImpl.setLocation(string);
        Element element2 = XMLUtil.getFirstChild(element);
        while (element2 != null) {
            if (ServiceDescription.SERVICE_KEY_QNAME.equals(element2) || ServiceDescription.SERVICE_KEY_QNAME_V2.equals(element2)) {
                serviceDescriptionImpl.setServiceKey(this.parseServiceKey(element2, serviceDescriptionImpl));
            } else {
                if (!ServiceDescription.DISCOVERY_URL_QNAME.equals(element2)) {
                    if (!ServiceDescription.DISCOVERY_URL_QNAME_V2.equals(element2)) {
                        throw new WSILException("WSIL document contains undefined UDDI extension element: " + element2.getTagName() + ".");
                    }
                }
                serviceDescriptionImpl.setDiscoveryURL(this.parseDiscoveryURL(element2, serviceDescriptionImpl));
            }
            element2 = XMLUtil.getNextSibling(element2);
        }
        return serviceDescriptionImpl;
    }

    protected ExtensionElement parseBusinessDescription(Element element, WSILElement wSILElement) {
        BusinessDescriptionImpl businessDescriptionImpl = new BusinessDescriptionImpl();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = (Attr)namedNodeMap.item(0);
        String string = attr.getValue();
        businessDescriptionImpl.setLocation(string);
        Element element2 = XMLUtil.getFirstChild(element);
        while (element2 != null) {
            if (BusinessDescription.BUSINESS_KEY_QNAME.equals(element2)) {
                businessDescriptionImpl.setBusinessKey(this.parseBusinessKey(element2, businessDescriptionImpl));
            } else if (BusinessDescription.DISCOVERY_URL_QNAME.equals(element2)) {
                businessDescriptionImpl.setDiscoveryURL(this.parseDiscoveryURL(element2, businessDescriptionImpl));
            }
            element2 = XMLUtil.getNextSibling(element2);
        }
        return businessDescriptionImpl;
    }

    protected BusinessKey parseBusinessKey(Element element, WSILElement wSILElement) {
        BusinessKey businessKey = new BusinessKey();
        businessKey.setText(XMLUtil.getText(element));
        return businessKey;
    }

    protected DiscoveryURL parseDiscoveryURL(Element element, WSILElement wSILElement) {
        DiscoveryURL discoveryURL = new DiscoveryURL();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = (Attr)namedNodeMap.item(0);
        String string = attr.getValue();
        discoveryURL.setUseType(string);
        discoveryURL.setText(XMLUtil.getText(element));
        return discoveryURL;
    }

    protected ServiceKey parseServiceKey(Element element, WSILElement wSILElement) {
        ServiceKey serviceKey = new ServiceKey();
        serviceKey.setText(XMLUtil.getText(element));
        return serviceKey;
    }

    protected CategoryBag parseCategoryBag(Element element, WSILElement wSILElement) {
        CategoryBag categoryBag = new CategoryBag();
        Element element2 = XMLUtil.getFirstChild(element);
        NamedNodeMap namedNodeMap = element2.getAttributes();
        Attr attr = (Attr)namedNodeMap.item(0);
        String string = attr.getValue();
        attr = (Attr)namedNodeMap.item(1);
        String string2 = attr.getValue();
        KeyedReference keyedReference = new KeyedReference(string, string2);
        Vector<KeyedReference> vector = new Vector<KeyedReference>();
        vector.add(keyedReference);
        categoryBag.setKeyedReferenceVector(vector);
        return categoryBag;
    }
}

