/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.EngineConfig;
import org.mandas.docker.client.messages.swarm.NodeDescription;
import org.mandas.docker.client.messages.swarm.Platform;
import org.mandas.docker.client.messages.swarm.Resources;

final class ImmutableNodeDescription
implements NodeDescription {
    private final String hostname;
    private final Platform platform;
    private final Resources resources;
    private final EngineConfig engine;

    private ImmutableNodeDescription(String hostname, Platform platform, Resources resources, EngineConfig engine) {
        this.hostname = hostname;
        this.platform = platform;
        this.resources = resources;
        this.engine = engine;
    }

    @Override
    @JsonProperty(value="Hostname")
    public String hostname() {
        return this.hostname;
    }

    @Override
    @JsonProperty(value="Platform")
    public Platform platform() {
        return this.platform;
    }

    @Override
    @JsonProperty(value="Resources")
    public Resources resources() {
        return this.resources;
    }

    @Override
    @JsonProperty(value="Engine")
    public EngineConfig engine() {
        return this.engine;
    }

    public final ImmutableNodeDescription withHostname(String value) {
        String newValue = Objects.requireNonNull(value, "hostname");
        if (this.hostname.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeDescription(newValue, this.platform, this.resources, this.engine);
    }

    public final ImmutableNodeDescription withPlatform(Platform value) {
        if (this.platform == value) {
            return this;
        }
        Platform newValue = Objects.requireNonNull(value, "platform");
        return new ImmutableNodeDescription(this.hostname, newValue, this.resources, this.engine);
    }

    public final ImmutableNodeDescription withResources(Resources value) {
        if (this.resources == value) {
            return this;
        }
        Resources newValue = Objects.requireNonNull(value, "resources");
        return new ImmutableNodeDescription(this.hostname, this.platform, newValue, this.engine);
    }

    public final ImmutableNodeDescription withEngine(EngineConfig value) {
        if (this.engine == value) {
            return this;
        }
        EngineConfig newValue = Objects.requireNonNull(value, "engine");
        return new ImmutableNodeDescription(this.hostname, this.platform, this.resources, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeDescription && this.equalTo((ImmutableNodeDescription)another);
    }

    private boolean equalTo(ImmutableNodeDescription another) {
        return this.hostname.equals(another.hostname) && this.platform.equals(another.platform) && this.resources.equals(another.resources) && this.engine.equals(another.engine);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hostname.hashCode();
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.resources.hashCode();
        h += (h << 5) + this.engine.hashCode();
        return h;
    }

    public String toString() {
        return "NodeDescription{hostname=" + this.hostname + ", platform=" + this.platform + ", resources=" + this.resources + ", engine=" + this.engine + "}";
    }

    public static ImmutableNodeDescription copyOf(NodeDescription instance) {
        if (instance instanceof ImmutableNodeDescription) {
            return (ImmutableNodeDescription)instance;
        }
        return ImmutableNodeDescription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_HOSTNAME = 1L;
        private static final long INIT_BIT_PLATFORM = 2L;
        private static final long INIT_BIT_RESOURCES = 4L;
        private static final long INIT_BIT_ENGINE = 8L;
        private long initBits = 15L;
        private String hostname;
        private Platform platform;
        private Resources resources;
        private EngineConfig engine;

        private Builder() {
        }

        public final Builder from(NodeDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.hostname(instance.hostname());
            this.platform(instance.platform());
            this.resources(instance.resources());
            this.engine(instance.engine());
            return this;
        }

        @JsonProperty(value="Hostname")
        public final Builder hostname(String hostname) {
            this.hostname = Objects.requireNonNull(hostname, "hostname");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Platform")
        public final Builder platform(Platform platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Resources")
        public final Builder resources(Resources resources) {
            this.resources = Objects.requireNonNull(resources, "resources");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Engine")
        public final Builder engine(EngineConfig engine) {
            this.engine = Objects.requireNonNull(engine, "engine");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableNodeDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeDescription(this.hostname, this.platform, this.resources, this.engine);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hostname");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("platform");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("resources");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("engine");
            }
            return "Cannot build NodeDescription, some of required attributes are not set " + attributes;
        }
    }
}

