/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.jdt.JreSystemVersion;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.ClasspathDescriptor;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.Messages;
import org.eclipse.m2e.jdt.internal.ModuleSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaProjectConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    private static final IPath[] DEFAULT_INCLUSIONS = new IPath[0];
    private static final Logger log = LoggerFactory.getLogger(AbstractJavaProjectConfigurator.class);
    private static final String GOAL_COMPILE = "compile";
    private static final String GOAL_TESTCOMPILE = "testCompile";
    public static final String COMPILER_PLUGIN_ARTIFACT_ID = "maven-compiler-plugin";
    public static final String COMPILER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String GOAL_ENFORCE = "enforce";
    public static final String ENFORCER_PLUGIN_ARTIFACT_ID = "maven-enforcer-plugin";
    public static final String ENFORCER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    protected static final List<String> RELEASES;
    protected static final List<String> SOURCES;
    protected static final List<String> TARGETS;
    private static final String GOAL_RESOURCES = "resources";
    private static final String GOAL_TESTRESOURCES = "testResources";
    private static final String RESOURCES_PLUGIN_ARTIFACT_ID = "maven-resources-plugin";
    private static final String RESOURCES_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    protected static final LinkedHashMap<String, String> ENVIRONMENTS;
    protected static final String DEFAULT_COMPILER_LEVEL = "1.5";

    static {
        ENVIRONMENTS = new LinkedHashMap();
        ArrayList<String> sources = new ArrayList<String>(Arrays.asList("1.1,1.2,1.3,1.4,1.5,5,1.6,6,1.7,7,1.8,8".split(",")));
        ArrayList<String> targets = new ArrayList<String>(Arrays.asList("1.1,1.2,1.3,1.4,jsr14,1.5,5,1.6,6,1.7,7,1.8,8".split(",")));
        ArrayList<String> releases = new ArrayList<String>(Arrays.asList("6,7,8".split(",")));
        ENVIRONMENTS.put("1.1", "JRE-1.1");
        ENVIRONMENTS.put("1.2", "J2SE-1.2");
        ENVIRONMENTS.put("1.3", "J2SE-1.3");
        ENVIRONMENTS.put("1.4", "J2SE-1.4");
        ENVIRONMENTS.put(DEFAULT_COMPILER_LEVEL, "J2SE-1.5");
        ENVIRONMENTS.put("jsr14", "J2SE-1.5");
        ENVIRONMENTS.put("1.6", "JavaSE-1.6");
        ENVIRONMENTS.put("1.7", "JavaSE-1.7");
        ENVIRONMENTS.put("1.8", "JavaSE-1.8");
        int i = 9;
        while (i < 20) {
            String level = String.valueOf(i);
            IExecutionEnvironment modernJavaSe = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment("JavaSE-" + level);
            if (modernJavaSe == null) break;
            String level1 = "1." + level;
            sources.add(level1);
            sources.add(level);
            targets.add(level1);
            targets.add(level);
            releases.add(level);
            ENVIRONMENTS.put(level, modernJavaSe.getId());
            ++i;
        }
        SOURCES = Collections.unmodifiableList(sources);
        TARGETS = Collections.unmodifiableList(targets);
        RELEASES = Collections.unmodifiableList(releases);
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.mavenProjectFacade().getProject();
        monitor.setTaskName(String.valueOf(Messages.AbstractJavaProjectConfigurator_task_name) + project.getName());
        this.addJavaNature(project, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        HashMap<String, String> options = new HashMap<String, String>();
        this.addJavaProjectOptions(options, request, monitor);
        ClasspathDescriptor classpath = new ClasspathDescriptor(javaProject);
        this.addProjectSourceFolders(classpath, options, request, monitor);
        String executionEnvironmentId = this.getExecutionEnvironmentId(options);
        String buildEnvironmentId = this.getMinimumJavaBuildEnvironmentId(request, monitor);
        this.addJREClasspathContainer(classpath, buildEnvironmentId != null ? buildEnvironmentId : executionEnvironmentId);
        this.addMavenClasspathContainer(classpath);
        this.addCustomClasspathEntries(javaProject, classpath);
        IContainer classesFolder = this.getOutputLocation(request, project);
        javaProject.setRawClasspath(classpath.getEntries(), classesFolder.getFullPath(), monitor);
        this.invokeJavaProjectConfigurators(classpath, request, monitor);
        for (Map.Entry option : options.entrySet()) {
            javaProject.setOption((String)option.getKey(), (String)option.getValue());
        }
        javaProject.setRawClasspath(classpath.getEntries(), classesFolder.getFullPath(), monitor);
        MavenJdtPlugin.getDefault().getBuildpathManager().updateClasspath(project, monitor);
    }

    protected IContainer getOutputLocation(ProjectConfigurationRequest request, IProject project) {
        MavenProject mavenProject = request.mavenProject();
        return this.getFolder(project, mavenProject.getBuild().getOutputDirectory());
    }

    protected String getExecutionEnvironmentId(Map<String, String> options) {
        return ENVIRONMENTS.get(options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
    }

    protected void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        AbstractJavaProjectConfigurator.addNature((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
    }

    protected void addCustomClasspathEntries(IJavaProject javaProject, IClasspathDescriptor classpath) {
    }

    protected void invokeJavaProjectConfigurators(IClasspathDescriptor classpath, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        ILifecycleMapping lifecycleMapping = configurationManager.getLifecycleMapping(facade);
        if (lifecycleMapping == null) {
            return;
        }
        for (AbstractProjectConfigurator configurator : lifecycleMapping.getProjectConfigurators(facade, monitor)) {
            if (!(configurator instanceof IJavaProjectConfigurator var9_9)) continue;
            javaConfigurator.configureRawClasspath(request, classpath, monitor);
        }
    }

    protected void addJREClasspathContainer(IClasspathDescriptor classpath, String environmentId) {
        IClasspathEntry cpe;
        IExecutionEnvironment executionEnvironment = this.getExecutionEnvironment(environmentId);
        if (executionEnvironment == null) {
            cpe = JavaRuntime.getDefaultJREContainerEntry();
        } else {
            IPath containerPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)executionEnvironment);
            cpe = JavaCore.newContainerEntry((IPath)containerPath);
        }
        IClasspathEntryDescriptor cped = classpath.replaceEntry(descriptor -> JavaRuntime.JRE_CONTAINER.equals(descriptor.getPath().segment(0)), cpe);
        if (cped == null) {
            classpath.addEntry(cpe);
        }
    }

    private IExecutionEnvironment getExecutionEnvironment(String environmentId) {
        if (environmentId == null || JreSystemVersion.WORKSPACE_DEFAULT == MavenJdtPlugin.getDefault().getJreSystemVersion()) {
            return null;
        }
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = manager.getExecutionEnvironments();
        int n = iExecutionEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
            if (environment.getId().equals(environmentId)) {
                return environment;
            }
            ++n2;
        }
        return null;
    }

    protected void addMavenClasspathContainer(IClasspathDescriptor classpath) {
        List<IClasspathEntryDescriptor> descriptors = classpath.getEntryDescriptors();
        ArrayList<IAccessRule> accessRules = new ArrayList<IAccessRule>();
        boolean isExported = false;
        for (IClasspathEntryDescriptor descriptor : descriptors) {
            if (!MavenClasspathHelpers.isMaven2ClasspathContainer(descriptor.getPath())) continue;
            isExported = descriptor.isExported();
            List<IAccessRule> previousAccessRules = descriptor.getAccessRules();
            if (previousAccessRules == null) break;
            accessRules.addAll(previousAccessRules);
            break;
        }
        IClasspathEntry cpe = MavenClasspathHelpers.getDefaultContainerEntry();
        IClasspathEntryDescriptor entryDescriptor = classpath.addEntry(cpe);
        entryDescriptor.setExported(isExported);
        for (IAccessRule accessRule : accessRules) {
            entryDescriptor.addAccessRule(accessRule);
        }
    }

    protected void addProjectSourceFolders(IClasspathDescriptor classpath, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        this.addProjectSourceFolders(classpath, new HashMap<String, String>(), request, monitor);
    }

    protected void addProjectSourceFolders(IClasspathDescriptor classpath, Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            IProject project = request.mavenProjectFacade().getProject();
            MavenProject mavenProject = request.mavenProject();
            IMavenProjectFacade projectFacade = request.mavenProjectFacade();
            IFolder classes = this.getFolder(project, mavenProject.getBuild().getOutputDirectory());
            IFolder testClasses = this.getFolder(project, mavenProject.getBuild().getTestOutputDirectory());
            M2EUtils.createFolder((IFolder)classes, (boolean)true, (IProgressMonitor)mon.newChild(1));
            M2EUtils.createFolder((IFolder)testClasses, (boolean)true, (IProgressMonitor)mon.newChild(1));
            IPath[] inclusion = new IPath[]{};
            IPath[] exclusion = new IPath[]{};
            IPath[] inclusionTest = new IPath[]{};
            IPath[] exclusionTest = new IPath[]{};
            String mainSourceEncoding = null;
            String testSourceEncoding = null;
            String mainResourcesEncoding = null;
            String testResourcesEncoding = null;
            List<MojoExecution> executions = this.getCompilerMojoExecutions(request, (IProgressMonitor)mon.newChild(1));
            for (MojoExecution compile : executions) {
                if (!this.isCompileExecution(compile, mavenProject, options, monitor)) continue;
                mainSourceEncoding = (String)this.maven.getMojoParameterValue(mavenProject, compile, "encoding", String.class, monitor);
                try {
                    inclusion = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "includes", String[].class, monitor));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler inclusions, assuming defaults", (Throwable)ex);
                }
                try {
                    exclusion = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "excludes", String[].class, monitor));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler exclusions, assuming defaults", (Throwable)ex);
                }
            }
            for (MojoExecution compile : executions) {
                if (!this.isTestCompileExecution(compile, mavenProject, options, monitor)) continue;
                testSourceEncoding = (String)this.maven.getMojoParameterValue(mavenProject, compile, "encoding", String.class, monitor);
                try {
                    inclusionTest = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "testIncludes", String[].class, monitor));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler test inclusions, assuming defaults", (Throwable)ex);
                }
                try {
                    exclusionTest = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "testExcludes", String[].class, monitor));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler test exclusions, assuming defaults", (Throwable)ex);
                }
            }
            for (MojoExecution resources : projectFacade.getMojoExecutions("org.apache.maven.plugins", RESOURCES_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_RESOURCES})) {
                mainResourcesEncoding = (String)this.maven.getMojoParameterValue(mavenProject, resources, "encoding", String.class, monitor);
            }
            for (MojoExecution resources : projectFacade.getMojoExecutions("org.apache.maven.plugins", RESOURCES_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_TESTRESOURCES})) {
                testResourcesEncoding = (String)this.maven.getMojoParameterValue(mavenProject, resources, "encoding", String.class, monitor);
            }
            this.addSourceDirs(classpath, project, mavenProject.getCompileSourceRoots(), classes.getFullPath(), inclusion, exclusion, mainSourceEncoding, (IProgressMonitor)mon.newChild(1), false);
            this.addResourceDirs(classpath, project, mavenProject, mavenProject.getBuild().getResources(), classes.getFullPath(), mainResourcesEncoding, (IProgressMonitor)mon.newChild(1), false);
            boolean addTestFlag = !MavenClasspathHelpers.hasTestFlagDisabled(mavenProject);
            this.addSourceDirs(classpath, project, mavenProject.getTestCompileSourceRoots(), testClasses.getFullPath(), inclusionTest, exclusionTest, testSourceEncoding, (IProgressMonitor)mon.newChild(1), addTestFlag);
            this.addResourceDirs(classpath, project, mavenProject, mavenProject.getBuild().getTestResources(), testClasses.getFullPath(), testResourcesEncoding, (IProgressMonitor)mon.newChild(1), addTestFlag);
        }
        finally {
            mon.done();
        }
    }

    protected boolean isTestCompileExecution(MojoExecution execution, MavenProject mavenProject, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        return GOAL_TESTCOMPILE.equals(execution.getGoal()) && this.isCompliant(execution, mavenProject, options, monitor);
    }

    protected boolean isCompileExecution(MojoExecution execution, MavenProject mavenProject, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        return GOAL_COMPILE.equals(execution.getGoal()) && this.isCompliant(execution, mavenProject, options, monitor);
    }

    private boolean isCompliant(MojoExecution execution, MavenProject mavenProject, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        String release = (String)this.maven.getMojoParameterValue(mavenProject, execution, "release", String.class, monitor);
        if (release != null && !this.sanitizeJavaVersion(release).equals(options.get("org.eclipse.jdt.core.compiler.compliance"))) {
            return false;
        }
        if (release == null) {
            String source = (String)this.maven.getMojoParameterValue(mavenProject, execution, "source", String.class, monitor);
            if (source != null && !this.sanitizeJavaVersion(source).equals(options.get("org.eclipse.jdt.core.compiler.source"))) {
                return false;
            }
            String target = (String)this.maven.getMojoParameterValue(mavenProject, execution, "target", String.class, monitor);
            if (target != null && !this.sanitizeJavaVersion(target).equals(options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"))) {
                return false;
            }
        }
        return true;
    }

    private IPath[] toPaths(String[] values) {
        if (values == null) {
            return new IPath[0];
        }
        IPath[] paths = new IPath[values.length];
        int i = 0;
        while (i < values.length) {
            if (values[i] != null && !"".equals(values[i].trim())) {
                paths[i] = new Path(values[i]);
            }
            ++i;
        }
        return paths;
    }

    private void addSourceDirs(IClasspathDescriptor classpath, IProject project, List<String> sourceRoots, IPath outputPath, IPath[] inclusion, IPath[] exclusion, String sourceEncoding, IProgressMonitor monitor, boolean addTestFlag) throws CoreException {
        for (String sourceRoot : sourceRoots) {
            IClasspathEntryDescriptor enclosing;
            IFolder sourceFolder = this.getFolder(project, sourceRoot);
            if (sourceFolder == null) continue;
            sourceFolder.refreshLocal(0, monitor);
            if (sourceFolder.exists() && !sourceFolder.getProject().equals((Object)project)) continue;
            if (sourceFolder.exists()) {
                sourceFolder.setDefaultCharset(sourceEncoding, monitor);
            }
            if ((enclosing = this.getEnclosingEntryDescriptor(classpath, sourceFolder.getFullPath())) == null || this.getEntryDescriptor(classpath, sourceFolder.getFullPath()) != null) {
                log.info("Adding source folder " + sourceFolder.getFullPath());
                IClasspathEntryDescriptor descriptor = classpath.addSourceEntry(sourceFolder.getFullPath(), outputPath, inclusion, exclusion, true);
                descriptor.setClasspathAttribute("test", addTestFlag ? "true" : null);
                continue;
            }
            log.info("Not adding source folder " + sourceFolder.getFullPath() + " because it overlaps with " + enclosing.getPath());
        }
    }

    private IClasspathEntryDescriptor getEnclosingEntryDescriptor(IClasspathDescriptor classpath, IPath fullPath) {
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (!cped.getPath().isPrefixOf(fullPath)) continue;
            return cped;
        }
        return null;
    }

    private IClasspathEntryDescriptor getEntryDescriptor(IClasspathDescriptor classpath, IPath fullPath) {
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (!cped.getPath().equals((Object)fullPath)) continue;
            return cped;
        }
        return null;
    }

    private void addResourceDirs(IClasspathDescriptor classpath, IProject project, MavenProject mavenProject, List<Resource> resources, IPath outputPath, String resourceEncoding, IProgressMonitor monitor, boolean addTestFlag) throws CoreException {
        for (Resource resource : resources) {
            File resourceDirectory;
            String directory = resource.getDirectory();
            if (directory == null || !(resourceDirectory = new File(directory)).isDirectory()) continue;
            IPath relativePath = this.getProjectRelativePath(project, directory);
            IResource r = project.findMember(relativePath);
            if (r == project) {
                log.error("Skipping resource folder " + r.getFullPath());
                continue;
            }
            if (r != null && project.equals((Object)r.getProject())) {
                IPath path = r.getFullPath();
                IClasspathEntryDescriptor enclosing = this.getEnclosingEntryDescriptor(classpath, path);
                if (enclosing != null && this.overlapsWithSourceFolder(path, project, mavenProject)) {
                    this.configureOverlapWithSource(classpath, enclosing, path);
                } else if (this.overlapsWithOtherResourceFolder(path, project, mavenProject)) {
                    log.info("Skipping resource folder " + path + " since it's contained by another resource folder");
                } else {
                    this.addResourceFolder(classpath, path, outputPath, addTestFlag);
                }
                IFolder resourceFolder = project.getFolder(relativePath);
                resourceFolder.setDefaultCharset(resourceEncoding, monitor);
                continue;
            }
            log.info("Not adding resources folder " + resourceDirectory.getAbsolutePath());
        }
    }

    private void addResourceFolder(IClasspathDescriptor classpath, IPath resourceFolder, IPath outputPath, boolean addTestFlag) {
        log.info("Adding resource folder " + resourceFolder);
        IClasspathEntryDescriptor descriptor = classpath.addSourceEntry(resourceFolder, outputPath, DEFAULT_INCLUSIONS, new IPath[]{new Path("**")}, false);
        descriptor.setClasspathAttribute("test", addTestFlag ? "true" : null);
    }

    private void configureOverlapWithSource(IClasspathDescriptor classpath, IClasspathEntryDescriptor enclosing, IPath resourceFolder) {
        log.info("Resources folder " + resourceFolder + " overlaps with sources folder " + enclosing.getPath());
        enclosing.addInclusionPattern((IPath)new Path("**/*.java"));
        enclosing.removeExclusionPattern((IPath)new Path("**"));
        classpath.touchEntry(resourceFolder);
    }

    private boolean overlapsWithSourceFolder(IPath path, IProject project, MavenProject mavenProject) {
        IPath relPath = path.makeRelativeTo(project.getFullPath());
        List compile = mavenProject.getCompileSourceRoots();
        List test = mavenProject.getTestCompileSourceRoots();
        return this.isContained(relPath, project, this.getSourceFolders(project, compile)) || this.isContained(relPath, project, this.getSourceFolders(project, test));
    }

    private boolean overlapsWithOtherResourceFolder(IPath path, IProject project, MavenProject mavenProject) {
        IPath relPath = path.makeRelativeTo(project.getFullPath());
        return this.isContained(relPath, project, this.getOtherResourceFolders(project, mavenProject.getResources(), relPath)) || this.isContained(relPath, project, this.getOtherResourceFolders(project, mavenProject.getTestResources(), relPath));
    }

    private IPath[] getSourceFolders(IProject project, List<String> sources) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (String source : sources) {
            paths.add(this.getProjectRelativePath(project, source));
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    private IPath[] getOtherResourceFolders(IProject project, List<Resource> resources, IPath curPath) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (Resource res : resources) {
            IPath path = this.getProjectRelativePath(project, res.getDirectory());
            if (path.equals((Object)curPath)) continue;
            paths.add(path);
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    private boolean isContained(IPath path, IProject project, IPath[] otherPaths) {
        IPath[] iPathArray = otherPaths;
        int n = otherPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath otherPath = iPathArray[n2];
            if (otherPath.isPrefixOf(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void addJavaProjectOptions(Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        String source = null;
        String target = null;
        String release = null;
        boolean generateParameters = false;
        boolean enablePreviewFeatures = false;
        for (MojoExecution execution : this.getCompilerMojoExecutions(request, monitor)) {
            release = this.getCompilerLevel(request.mavenProject(), execution, "release", release, RELEASES, monitor);
            source = this.getCompilerLevel(request.mavenProject(), execution, "source", source, SOURCES, monitor);
            target = this.getCompilerLevel(request.mavenProject(), execution, "target", target, TARGETS, monitor);
            generateParameters = generateParameters || this.isGenerateParameters(request.mavenProject(), execution, monitor);
            enablePreviewFeatures = enablePreviewFeatures || this.isEnablePreviewFeatures(request.mavenProject(), execution, monitor);
            for (Object o : (List)this.maven.getMojoParameterValue(request.mavenProject(), execution, "compilerArgs", List.class, monitor)) {
                if (!(o instanceof String var13_13)) continue;
                boolean err = false;
                String[] settings = new String[]{};
                if (compilerArg.startsWith("-warn:")) {
                    settings = compilerArg.substring("-warn:".length()).split(",");
                } else if (compilerArg.startsWith("-err:")) {
                    err = true;
                    settings = compilerArg.substring("-err:".length()).split(",");
                }
                String[] stringArray = settings;
                int n = settings.length;
                int n2 = 0;
                while (n2 < n) {
                    String cliSetting = stringArray[n2];
                    if (cliSetting.length() >= 2) {
                        String severity = cliSetting.charAt(0) == '-' ? "ignore" : (err ? "error" : "warning");
                        String option = this.toCompilerOption(cliSetting = Character.isLetter(cliSetting.charAt(0)) ? cliSetting : cliSetting.substring(1));
                        if (option != null) {
                            options.put(option, severity);
                        }
                    }
                    ++n2;
                }
            }
        }
        if (release != null) {
            source = release;
            target = release;
        } else {
            if (source == null) {
                source = this.getDefaultSourceLevel();
                log.warn("Could not determine source level, using default " + source);
            }
            if (target == null) {
                target = this.getDefaultTargetLevel(source);
                log.warn("Could not determine target level, using default " + target);
            }
        }
        source = this.sanitizeJavaVersion(source);
        target = this.sanitizeJavaVersion(target);
        options.put("org.eclipse.jdt.core.compiler.source", source);
        options.put("org.eclipse.jdt.core.compiler.compliance", source);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", target);
        options.put("org.eclipse.jdt.core.compiler.release", release == null ? "disabled" : "enabled");
        if (generateParameters) {
            options.put("org.eclipse.jdt.core.compiler.codegen.methodParameters", "generate");
        }
        if ((jp = JavaCore.create((IProject)request.mavenProjectFacade().getProject())) != null && jp.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", false) == null) {
            options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "warning");
        }
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", enablePreviewFeatures ? "enabled" : "disabled");
        if (jp != null && jp.getOption("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", false) == null) {
            options.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        }
    }

    private String toCompilerOption(String problemSettingName) {
        return switch (problemSettingName) {
            case "serial" -> "org.eclipse.jdt.core.compiler.problem.missingSerialVersion";
            default -> null;
        };
    }

    private boolean isGenerateParameters(MavenProject mavenProject, MojoExecution execution, IProgressMonitor monitor) {
        Boolean generateParameters = null;
        try {
            generateParameters = (Boolean)this.maven.getMojoParameterValue(mavenProject, execution, "parameters", Boolean.class, monitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Boolean.TRUE.equals(generateParameters)) {
            try {
                List args = (List)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgs", List.class, monitor);
                if (args != null) {
                    generateParameters = args.contains("-parameters");
                }
            }
            catch (Exception args) {
                // empty catch block
            }
        }
        if (!Boolean.TRUE.equals(generateParameters)) {
            try {
                String compilerArgument = (String)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgument", String.class, monitor);
                if (compilerArgument != null) {
                    generateParameters = compilerArgument.contains("-parameters");
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return Boolean.TRUE.equals(generateParameters);
    }

    private boolean isEnablePreviewFeatures(MavenProject mavenProject, MojoExecution execution, IProgressMonitor monitor) {
        try {
            List args = (List)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgs", List.class, monitor);
            if (args != null && args.contains("--enable-preview")) {
                return true;
            }
        }
        catch (Exception args) {
            // empty catch block
        }
        try {
            String compilerArgument = (String)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgument", String.class, monitor);
            if (compilerArgument != null && compilerArgument.contains("--enable-preview")) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private String sanitizeJavaVersion(String version) {
        return switch (version) {
            case "5", "6", "7", "8" -> "1." + version;
            default -> {
                String subVersion;
                yield version.startsWith("1.") && Integer.parseInt(subVersion = version.substring(2)) > 8 ? subVersion : version;
            }
        };
    }

    protected String getDefaultTargetLevel(String source) {
        return DEFAULT_COMPILER_LEVEL;
    }

    protected String getDefaultSourceLevel() {
        return DEFAULT_COMPILER_LEVEL;
    }

    protected List<MojoExecution> getCompilerMojoExecutions(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        return request.mavenProjectFacade().getMojoExecutions("org.apache.maven.plugins", COMPILER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_COMPILE, GOAL_TESTCOMPILE});
    }

    protected List<MojoExecution> getEnforcerMojoExecutions(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        return request.mavenProjectFacade().getMojoExecutions("org.apache.maven.plugins", ENFORCER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_ENFORCE});
    }

    private String getCompilerLevel(MavenProject mavenProject, MojoExecution execution, String parameter, String source, List<String> levels, IProgressMonitor monitor) {
        int levelIdx = this.getLevelIndex(source, levels);
        try {
            source = (String)this.maven.getMojoParameterValue(mavenProject, execution, parameter, String.class, monitor);
        }
        catch (CoreException ex) {
            log.error("Failed to determine compiler " + parameter + " setting, assuming default", (Throwable)ex);
        }
        int newLevelIdx = this.getLevelIndex(source, levels);
        if (newLevelIdx > levelIdx) {
            levelIdx = newLevelIdx;
        }
        if (levelIdx < 0) {
            return null;
        }
        return levels.get(levelIdx);
    }

    private int getLevelIndex(String level, List<String> levels) {
        int idx = -1;
        if (level != null && (idx = levels.indexOf(level)) < 0) {
            int highestIdx = levels.size() - 1;
            try {
                if (this.asDouble(level) > this.asDouble(levels.get(highestIdx))) {
                    idx = highestIdx;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return idx;
    }

    private String getMinimumJavaBuildEnvironmentId(ProjectConfigurationRequest request, IProgressMonitor monitor) {
        try {
            List<MojoExecution> mojoExecutions = this.getEnforcerMojoExecutions(request, monitor);
            for (MojoExecution mojoExecution : mojoExecutions) {
                String version = this.getMinimumJavaBuildEnvironmentId(mojoExecution);
                if (version == null) continue;
                return version;
            }
        }
        catch (InvalidVersionSpecificationException | CoreException ex) {
            log.error("Failed to determine minimum build version, assuming default", ex);
        }
        return null;
    }

    private String getMinimumJavaBuildEnvironmentId(MojoExecution mojoExecution) throws InvalidVersionSpecificationException {
        Xpp3Dom dom = mojoExecution.getConfiguration();
        Xpp3Dom rules = dom.getChild("rules");
        if (rules == null) {
            return null;
        }
        Xpp3Dom requireJavaVersion = rules.getChild("requireJavaVersion");
        if (requireJavaVersion == null) {
            return null;
        }
        Xpp3Dom version = requireJavaVersion.getChild("version");
        if (version == null) {
            return null;
        }
        return this.getMinimumJavaBuildEnvironmentId(version.getValue());
    }

    private String getMinimumJavaBuildEnvironmentId(String versionSpec) throws InvalidVersionSpecificationException {
        VersionRange vr = VersionRange.createFromVersionSpec((String)versionSpec);
        ArtifactVersion recommendedVersion = vr.getRecommendedVersion();
        for (Map.Entry<String, String> entry : ENVIRONMENTS.entrySet()) {
            DefaultArtifactVersion environmentVersion = new DefaultArtifactVersion(entry.getKey());
            boolean foundMatchingVersion = false;
            if (recommendedVersion == null) {
                foundMatchingVersion = vr.containsVersion((ArtifactVersion)environmentVersion);
            } else {
                int compareTo = recommendedVersion.compareTo((Object)environmentVersion);
                boolean bl = foundMatchingVersion = compareTo <= 0;
            }
            if (!foundMatchingVersion) continue;
            return entry.getValue();
        }
        return null;
    }

    private double asDouble(String level) {
        if (level == null || level.isEmpty()) {
            return -1.0;
        }
        return Double.parseDouble(this.sanitizeJavaVersion(level));
    }

    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        super.unconfigure(request, monitor);
        this.removeMavenClasspathContainer(request.mavenProjectFacade().getProject());
    }

    private void removeMavenClasspathContainer(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                    newEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
    }

    protected IFolder getFolder(IProject project, String absolutePath) {
        if (project.getLocation().makeAbsolute().equals((Object)Path.fromOSString((String)absolutePath))) {
            return project.getFolder(project.getLocation());
        }
        return project.getFolder(this.getProjectRelativePath(project, absolutePath));
    }

    protected IPath getProjectRelativePath(IProject project, String absolutePath) {
        File basedir = project.getLocation().toFile();
        String relative = absolutePath.equals(basedir.getAbsolutePath()) ? "." : (absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath);
        return new Path(relative.replace('\\', '/'));
    }

    private List<String> getCompilerArguments(MavenProject mavenProject, MojoExecution execution, IProgressMonitor monitor) {
        ArrayList<String> arguments = new ArrayList<String>();
        try {
            List args = (List)this.maven.getMojoParameterValue(mavenProject, execution, "compilerArgs", List.class, monitor);
            if (args != null) {
                args.stream().filter(a -> a != null).forEach(a -> {
                    boolean bl = arguments.add(a.toString());
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arguments;
    }

    private List<String> getCompilerArguments(IMavenProjectFacade facade, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> compilerArgs = new ArrayList<String>();
        List executions = facade.getMojoExecutions("org.apache.maven.plugins", COMPILER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_COMPILE, GOAL_TESTCOMPILE});
        MavenProject mavenProject = facade.getMavenProject();
        for (MojoExecution compile : executions) {
            List<String> args;
            if (!this.isCompileExecution(compile, mavenProject, options, monitor) && !this.isTestCompileExecution(compile, mavenProject, options, monitor) || (args = this.getCompilerArguments(mavenProject, compile, monitor)) == null) continue;
            compilerArgs.addAll(args);
        }
        return compilerArgs;
    }

    @Override
    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) {
        ModuleSupport.configureClasspath(facade, classpath, monitor);
    }

    @Override
    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
        if (javaProject == null || !javaProject.exists() || classpath == null) {
            return;
        }
        List<String> compilerArgs = this.getCompilerArguments(facade, javaProject.getOptions(true), monitor);
        ModuleSupport.configureRawClasspath(request, classpath, monitor, compilerArgs);
    }
}

