/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.policies;

import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.transform.Affine;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.mvc.fx.operations.TransformVisualOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;
import org.eclipse.gef.zest.fx.parts.AbstractLabelPart;

public class TransformLabelPolicy
extends TransformPolicy {
    private Point initialOffset;

    private IContentPart<? extends javafx.scene.Node> getFirstAnchorage() {
        return (IContentPart)this.getHost().getAnchoragesUnmodifiable().keySet().iterator().next();
    }

    public AbstractLabelPart getHost() {
        return (AbstractLabelPart)super.getHost();
    }

    private Point getLabelOffsetInParent() {
        Point labelPositionInScene = this.getHost().getLabelPosition();
        if (labelPositionInScene == null) {
            return null;
        }
        Point referencePositionInScene = this.getLabelReferencePointInScene((String)this.getHost().getContent().getValue());
        Point labelOffset = NodeUtils.sceneToLocal((javafx.scene.Node)((Group)this.getHost().getVisual()).getParent(), (Point)labelPositionInScene.getTranslated(referencePositionInScene.getNegated()));
        return labelOffset;
    }

    protected Point getLabelReferencePointInScene(String labelRole) {
        IAttributeStore contentElement = (IAttributeStore)this.getHost().getContent().getKey();
        if ("element-external-label".equals(labelRole)) {
            if (contentElement instanceof Node) {
                return NodeUtils.localToScene((javafx.scene.Node)this.getFirstAnchorage().getVisual(), (IGeometry)FX2Geometry.toRectangle((Bounds)this.getFirstAnchorage().getVisual().getLayoutBounds())).getBounds().getCenter();
            }
            if (this.getHost().getContent().getKey() instanceof Edge) {
                Connection connection = (Connection)this.getFirstAnchorage().getVisual();
                return NodeUtils.localToScene((javafx.scene.Node)connection, (Point)connection.getCenter().getTranslated(0.0, ((Group)this.getHost().getVisual()).getLayoutBounds().getHeight()));
            }
            throw new IllegalArgumentException("Unsupported element.");
        }
        if ("element-label".equals(labelRole)) {
            if (contentElement instanceof Edge) {
                Connection connection = (Connection)this.getFirstAnchorage().getVisual();
                return NodeUtils.localToScene((javafx.scene.Node)connection, (Point)connection.getCenter());
            }
            throw new IllegalArgumentException("Unsupported element.");
        }
        if ("edge-source-label".equals(labelRole)) {
            Connection connection = (Connection)this.getFirstAnchorage().getVisual();
            return NodeUtils.localToScene((javafx.scene.Node)connection, (Point)connection.getStartPoint());
        }
        if ("edge-target-label".equals(labelRole)) {
            Connection connection = (Connection)this.getFirstAnchorage().getVisual();
            return NodeUtils.localToScene((javafx.scene.Node)connection, (Point)connection.getEndPoint());
        }
        throw new IllegalArgumentException("Unsupported content element.");
    }

    public void init() {
        super.init();
        this.initialOffset = this.getLabelOffsetInParent();
    }

    public boolean preserveLabelOffset() {
        if (this.initialOffset == null) {
            return false;
        }
        Point currentLabelOffset = this.getLabelOffsetInParent();
        Point delta = currentLabelOffset.getTranslated(this.initialOffset.getNegated());
        TransformVisualOperation op = (TransformVisualOperation)this.getOperation();
        Affine newTransform = op.getNewTransform();
        newTransform.setTx(op.getInitialTransform().getTx() - delta.x);
        newTransform.setTy(op.getInitialTransform().getTy() - delta.y);
        this.locallyExecuteOperation();
        return true;
    }
}

