/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.boundary.InputConnector;
import org.eclipse.viatra.query.runtime.rete.construction.plancompiler.CompilerHelper;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.OnetimeIndexer;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.network.ConnectionFactory;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.NodeFactory;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.delayed.DelayedConnectCommand;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.Mask;
import org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.RecipesFactory;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.TransparentRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.helper.RecipeRecognizer;
import org.eclipse.viatra.query.runtime.rete.recipes.helper.RecipesHelper;
import org.eclipse.viatra.query.runtime.rete.remote.Address;
import org.eclipse.viatra.query.runtime.rete.remote.RemoteReceiver;
import org.eclipse.viatra.query.runtime.rete.remote.RemoteSupplier;
import org.eclipse.viatra.query.runtime.rete.traceability.ActiveNodeConflictTrace;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;
import org.eclipse.viatra.query.runtime.rete.traceability.UserRequestTrace;
import org.eclipse.viatra.query.runtime.rete.util.Options;

public class NodeProvisioner {
    ReteContainer reteContainer;
    NodeFactory nodeFactory;
    ConnectionFactory connectionFactory;
    InputConnector inputConnector;
    IQueryRuntimeContext runtimeContext;
    Map<Supplier, RemoteReceiver> remoteReceivers = CollectionsFactory.createMap();
    Map<Address<? extends Supplier>, RemoteSupplier> remoteSuppliers = CollectionsFactory.createMap();
    private RecipeRecognizer recognizer;
    private Map<Tuple, UserRequestTrace> projectionIndexerUserRequests = CollectionsFactory.createMap();
    private Map<Tuple, ProjectionIndexerRecipe> resultSeedRecipes = CollectionsFactory.createMap();

    public NodeProvisioner(ReteContainer reteContainer) {
        this.reteContainer = reteContainer;
        this.nodeFactory = reteContainer.getNodeFactory();
        this.connectionFactory = reteContainer.getConnectionFactory();
        this.inputConnector = reteContainer.getInputConnectionFactory();
        this.runtimeContext = reteContainer.getNetwork().getEngine().getRuntimeContext();
        this.recognizer = new RecipeRecognizer(this.runtimeContext);
    }

    public synchronized Address<? extends Node> getOrCreateNodeByRecipe(RecipeTraceInfo recipeTrace) {
        ReteNodeRecipe recipe = recipeTrace.getRecipe();
        Address<? extends Node> result = this.getNodesByRecipe().get(recipe);
        if (result != null) {
            if (this.getRecipeTraces().add(recipeTrace)) {
                result.getNodeCache().assignTraceInfo(recipeTrace);
            }
        } else {
            ReteNodeRecipe canonicalRecipe = this.recognizer.canonicalizeRecipe(recipe);
            if (canonicalRecipe != recipe) {
                result = this.getNodesByRecipe().get(canonicalRecipe);
                if (result != null) {
                    recipeTrace.shadowWithEquivalentRecipe(canonicalRecipe);
                    this.getNodesByRecipe().put(recipe, result);
                    if (this.getRecipeTraces().add(recipeTrace)) {
                        result.getNodeCache().assignTraceInfo(recipeTrace);
                    }
                    this.ensureParents(recipeTrace);
                } else if (!(recipe instanceof IndexerRecipe)) {
                    throw new IllegalStateException("This should not happen: non-indexer nodes are are supposed to be constructed as soon as they are designated as canonical recipes");
                }
            }
            if (result == null) {
                Node freshNode = this.instantiateNodeForRecipe(recipeTrace, recipe);
                result = this.reteContainer.makeAddress(freshNode);
            }
        }
        return result;
    }

    private Set<RecipeTraceInfo> getRecipeTraces() {
        return this.reteContainer.network.recipeTraces;
    }

    private Node instantiateNodeForRecipe(RecipeTraceInfo recipeTrace, ReteNodeRecipe recipe) {
        this.getRecipeTraces().add(recipeTrace);
        if (recipe instanceof IndexerRecipe) {
            this.ensureParents(recipeTrace);
            ReteNodeRecipe parentRecipe = recipeTrace.getParentRecipeTraces().iterator().next().getRecipe();
            Indexer result = this.nodeFactory.createIndexer(this.reteContainer, (IndexerRecipe)recipe, this.asSupplier(this.reteContainer.network.getExistingNodeByRecipe(parentRecipe)), recipeTrace);
            if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
                this.getNodesByRecipe().put(recipe, this.reteContainer.makeAddress(result));
            }
            return result;
        }
        Supplier result = this.nodeFactory.createNode(this.reteContainer, recipe, recipeTrace);
        if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
            this.getNodesByRecipe().put(recipe, this.reteContainer.makeAddress(result));
        }
        if (recipe instanceof InputRecipe) {
            this.inputConnector.connectInput((InputRecipe)recipe, result);
        } else {
            if (recipe instanceof InputFilterRecipe) {
                this.inputConnector.connectInputFilter((InputFilterRecipe)recipe, result);
            }
            this.ensureParents(recipeTrace);
            this.connectionFactory.connectToParents(recipeTrace, result);
        }
        return result;
    }

    private Map<ReteNodeRecipe, Address<? extends Node>> getNodesByRecipe() {
        return this.reteContainer.network.nodesByRecipe;
    }

    private void ensureParents(RecipeTraceInfo recipeTrace) {
        for (RecipeTraceInfo parentTrace : recipeTrace.getParentRecipeTraces()) {
            this.getOrCreateNodeByRecipe(parentTrace);
        }
    }

    synchronized RemoteReceiver accessRemoteReceiver(Address<? extends Supplier> address) {
        throw new UnsupportedOperationException("Multi-container Rete not supported yet");
    }

    synchronized RemoteSupplier accessRemoteSupplier(Address<? extends Supplier> address) {
        throw new UnsupportedOperationException("Multi-container Rete not supported yet");
    }

    public Supplier asSupplier(Address<? extends Supplier> address) {
        if (!this.reteContainer.isLocal(address)) {
            return this.accessRemoteSupplier(address);
        }
        return this.reteContainer.resolveLocal(address);
    }

    public synchronized ProjectionIndexer accessProjectionIndexer(RecipeTraceInfo productionTrace, TupleMask mask) {
        Tuple tableKey = Tuples.staticArityFlatTupleOf((Object)productionTrace, (Object)mask);
        UserRequestTrace indexerTrace = this.projectionIndexerUserRequests.computeIfAbsent(tableKey, k -> {
            ProjectionIndexerRecipe projectionIndexerRecipe = this.projectionIndexerRecipe(productionTrace, mask);
            return new UserRequestTrace((ReteNodeRecipe)projectionIndexerRecipe, productionTrace);
        });
        Address<? extends Node> address = this.getOrCreateNodeByRecipe(indexerTrace);
        return (ProjectionIndexer)this.reteContainer.resolveLocal(address);
    }

    public synchronized ProjectionIndexer accessProjectionIndexerOnetime(RecipeTraceInfo supplierTrace, TupleMask mask) {
        if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
            return this.accessProjectionIndexer(supplierTrace, mask);
        }
        Address<? extends Node> supplierAddress = this.getOrCreateNodeByRecipe(supplierTrace);
        Supplier supplier = (Supplier)this.reteContainer.resolveLocal(supplierAddress);
        OnetimeIndexer result = new OnetimeIndexer(this.reteContainer, mask);
        this.reteContainer.getDelayedCommandQueue().add(new DelayedConnectCommand(supplier, result, this.reteContainer));
        return result;
    }

    public synchronized ProjectionIndexer peekProjectionIndexer(RecipeTraceInfo supplierTrace, TupleMask mask) {
        Address<? extends Node> address = this.getNodesByRecipe().get(this.projectionIndexerRecipe(supplierTrace, mask));
        return address == null ? null : (ProjectionIndexer)this.reteContainer.resolveLocal(address);
    }

    private ProjectionIndexerRecipe projectionIndexerRecipe(RecipeTraceInfo parentTrace, TupleMask mask) {
        ReteNodeRecipe parentRecipe = parentTrace.getRecipe();
        Tuple tableKey = Tuples.staticArityFlatTupleOf((Object)parentRecipe, (Object)mask);
        ProjectionIndexerRecipe projectionIndexerRecipe = this.resultSeedRecipes.computeIfAbsent(tableKey, k -> RecipesHelper.projectionIndexerRecipe((ReteNodeRecipe)parentRecipe, (Mask)CompilerHelper.toRecipeMask(mask)));
        return projectionIndexerRecipe;
    }

    RecipeTraceInfo accessActiveIndexer(RecipeTraceInfo inactiveIndexerRecipeTrace) {
        RecipeTraceInfo parentRecipeTrace = inactiveIndexerRecipeTrace.getParentRecipeTraces().iterator().next();
        ProjectionIndexerRecipe inactiveIndexerRecipe = (ProjectionIndexerRecipe)inactiveIndexerRecipeTrace.getRecipe();
        TransparentRecipe transparentRecipe = RecipesFactory.eINSTANCE.createTransparentRecipe();
        transparentRecipe.setParent(parentRecipeTrace.getRecipe());
        ActiveNodeConflictTrace transparentRecipeTrace = new ActiveNodeConflictTrace((ReteNodeRecipe)transparentRecipe, parentRecipeTrace, inactiveIndexerRecipeTrace);
        ProjectionIndexerRecipe activeIndexerRecipe = RecipesFactory.eINSTANCE.createProjectionIndexerRecipe();
        activeIndexerRecipe.setParent((ReteNodeRecipe)transparentRecipe);
        activeIndexerRecipe.setMask(inactiveIndexerRecipe.getMask());
        ActiveNodeConflictTrace activeIndexerRecipeTrace = new ActiveNodeConflictTrace((ReteNodeRecipe)activeIndexerRecipe, (RecipeTraceInfo)transparentRecipeTrace, inactiveIndexerRecipeTrace);
        return activeIndexerRecipeTrace;
    }
}

