/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.ui.internal.ResourceManager;
import org.eclipse.graphiti.util.ColorUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;

public class ResourceRegistry
implements IResourceRegistry {
    private Map<Object, Resource> registry = new HashMap<Object, Resource>();

    @Override
    public Color getSwtColor(int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        Resource ret = this.registry.get(rgb);
        if (ret == null) {
            ret = new Color(null, rgb);
            this.registry.put(rgb, ret);
            ResourceManager.getResourceManager().manageResource(this, ret);
        }
        Color retColor = null;
        if (ret instanceof Color) {
            retColor = (Color)ret;
        }
        return retColor;
    }

    @Override
    public void dispose() {
        ResourceManager.getResourceManager().cleanUpResources(this);
        this.registry.clear();
    }

    @Override
    public Color getSwtColor(String hexRGBString) {
        return this.getSwtColor(ColorUtil.getRedFromHex((String)hexRGBString), ColorUtil.getGreenFromHex((String)hexRGBString), ColorUtil.getBlueFromHex((String)hexRGBString));
    }

    @Override
    public Font getSwtFont(FontData fontData) {
        Resource ret = this.registry.get(fontData);
        if (ret == null) {
            ret = new Font(null, fontData);
            this.registry.put(fontData, ret);
            ResourceManager.getResourceManager().manageResource(this, ret);
        }
        return ret instanceof Font ? (Font)ret : null;
    }
}

