/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.launching.IInterpreterContainerExtension;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclCorePreferences;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.emf.common.util.EList;

public class TclPackagesInterpreterContainerExtension
implements IInterpreterContainerExtension {
    public void processEntres(IScriptProject project, List<IBuildpathEntry> buildpathEntries) {
        IInterpreterInstall install;
        if (TclCorePreferences.USE_PACKAGE_CONCEPT) {
            return;
        }
        try {
            install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return;
        }
        ArrayList<IPath> externals = new ArrayList<IPath>();
        for (IBuildpathEntry entry : buildpathEntries) {
            if (entry.getEntryKind() != 1 || !entry.isExternal()) continue;
            externals.add(entry.getPath());
        }
        HashSet<String> packageNames = new HashSet<String>();
        InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project, packageNames, packageNames);
        List<TclPackageInfo> infos = TclPackagesManager.getPackageInfos(install, packageNames, true);
        if (infos.isEmpty()) {
            return;
        }
        IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)project);
        if (env == null) {
            return;
        }
        HashSet<IPath> allPaths = new HashSet<IPath>();
        for (TclPackageInfo info : infos) {
            EList<String> sources = info.getSources();
            for (String path : sources) {
                IPath rpath = new Path(path).removeLastSegments(1);
                IPath fullPath = EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)rpath);
                allPaths.add(fullPath);
            }
        }
        HashSet<IPath> rawEntries = new HashSet<IPath>(allPaths.size());
        for (IPath entryPath : allPaths) {
            if (entryPath.isEmpty() || rawEntries.contains(entryPath) || TclPackagesInterpreterContainerExtension.isPrefixOf(externals, entryPath)) continue;
            ArrayList<IPath> excluded = new ArrayList<IPath>();
            for (IPath otherPath : allPaths) {
                IPath pattern;
                if (otherPath.isEmpty() || !entryPath.isPrefixOf(otherPath) || otherPath.equals((Object)entryPath) || excluded.contains(pattern = otherPath.removeFirstSegments(entryPath.segmentCount()).append("*"))) continue;
                excluded.add(pattern);
            }
            buildpathEntries.add(DLTKCore.newLibraryEntry((IPath)entryPath, (IAccessRule[])IAccessRule.EMPTY_RULES, (IBuildpathAttribute[])new IBuildpathAttribute[0], (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])excluded.toArray(new IPath[excluded.size()]), (boolean)false, (boolean)true));
            rawEntries.add(entryPath);
        }
    }

    private static boolean isPrefixOf(List<IPath> paths, IPath entryPath) {
        for (IPath path : paths) {
            if (!path.isPrefixOf(entryPath)) continue;
            return true;
        }
        return false;
    }
}

