/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;

public class RuntimeDetailsDialog
extends Dialog {
    private IJSRuntimeInstall fRuntime;

    public RuntimeDetailsDialog(Shell shell, IJSRuntimeInstall vm) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRuntime = vm;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PreferencesMessages.RuntimeDetailsDialog_RuntimeDetails_Title);
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        GridLayout layout = new GridLayout(2, false);
        layout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)layout);
        this.createLabel(parent, PreferencesMessages.RuntimeDetailsDialog_TypeField_Label);
        this.createLabel(parent, this.fRuntime.getRuntimeType().getName());
        this.createLabel(parent, PreferencesMessages.RuntimeDetailsDialog_NameField_Label);
        this.createLabel(parent, this.fRuntime.getName());
        this.createLabel(parent, PreferencesMessages.RuntimeDetailsDialog_LocationField_Label);
        String home = this.fRuntime.getInstallLocation().exists() ? this.fRuntime.getInstallLocation().getAbsolutePath() : NLS.bind((String)PreferencesMessages.JSRuntimes_MissingPath, (Object)this.fRuntime.getInstallLocation().getAbsolutePath());
        this.createLabel(parent, home);
        String text = this.fRuntime.getJSRuntimeArgumentsAsString();
        if (text != null) {
            this.createLabel(parent, PreferencesMessages.RuntimeDetailsDialog_ArgumentsField_Label);
            this.createLabel(parent, text);
        }
        RuntimeDetailsDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    protected String getDialogSettingsSectionName() {
        return "RUNTIME_DETAILS_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = JavaScriptPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

